<?php

namespace FakerPress\ThirdParty\Faker\Provider\pt_BR;

class Text extends \FakerPress\ThirdParty\Faker\Provider\Text
{
    /**
     * The Project Gutenberg EBook of Dom Casmurro, by Machado de Assis
     *
     * This eBook is for the use of anyone anywhere in the United States and most
     * other parts of the world at no cost and with almost no restrictions
     * whatsoever.  You may copy it, give it away or re-use it under the terms of
     * the Project Gutenberg License included with this eBook or online at
     * www.gutenberg.org.  If you are not located in the United States, you'll have
     * to check the laws of the country where you are located before using this ebook.
     *
     * Title: Dom Casmurro
     *
     * Author: Machado de Assis
     *
     * Release Date: October 15, 2017 [EBook #55752]
     *
     * Language: Portuguese
     *
     * *** START OF THIS PROJECT GUTENBERG EBOOK DOM CASMURRO ***
     *
     * Produced by Laura Natal Rodriguez & Marc D'Hooghe at Free
     * Literature (online soon in an extended version,also linking
     * to free sources for education worldwide ... MOOC's,
     * educational materials,...) (Images generously made available
     * by the Bibliotheca Nacional Digital Brasil.)
     *
     * DOM CASMURRO
     *
     * POR
     *
     * MACHADO DE ASSIS
     *
     * DA ACADEMIA BRAZILEIRA
     *
     * H. GARNIER, LIVREIRO-EDITOR
     *
     * RUA MOREIRA CEZAR, 71
     *
     * RIO DE JANEIRO
     *
     * 6, RUE DES SAINTS-PÈRES, 6
     *
     * PARIZ
     *
     * @see https://www.gutenberg.org/cache/epub/55752/pg55752.txt
     *
     * @var string
     */
    protected static $baseText = <<<'EOT'
I

Do titulo.

Uma noite destas, vindo da cidade para o Engenho Novo, encontrei no
trem da Central um rapaz aqui do bairro, que eu conheço de vista e
de chapéo. Comprimentou-me, sentou-se ao pé de mim, falou da lua e
dos ministros, e acabou recitando-me versos. A viagem era curta, e os
versos póde ser que não fossem inteiramente maus. Succedeu, porém, que
como eu estava cançado, fechei os olhos tres ou quatro vezes; tanto
bastou para que elle interrompesse a leitura e mettesse os versos no
bolso.

--Continue, disse eu accordando.

--Já acabei, murmurou elle.

--São muito bonitos.

Vi-lhe fazer um gesto para tiral-os outra vez do bolso, mas não passou
do gesto; estava amuado. No dia seguinte entrou a dizer de mim nomes
feios, e acabou alcunhando-me _Dom Casmurro._ Os visinhos, que não
gostam dos meus habitos reclusos e calados, deram curso á alcunha, que
afinal pegou. Nem por isso me zanguei. Contei a anecdota aos amigos da
cidade, e elles, por graça, chamam-me assim, alguns em bilhetes: «Dom
Casmurro, domingo vou jantar com você.»--«Vou para Petropolis, Dom
Casmurro; a casa é a mesma da Rhenania; vê se deixas essa caverna do
Engenho Novo, e vae lá passar uns quinze dias commigo.»--«Meu caro Dom
Casmurro, não cuide que o dispenso do theatro amanhã; venha e dormirá
aqui na cidade; dou-lhe camarote, dou-lhe chá, dou-lhe cama; só não lhe
dou moça.»

Não consultes diccionarios. _Casmurro_ não está aqui no sentido que
elles lhe dão, mas no que lhe poz o vulgo de homem calado e mettido
comsigo. _Dom_ veiu por ironia, para attribuir-me fumos de fidalgo.
Tudo por estar cochilando! Tambem não achei melhor titulo para a minha
narração; se não tiver outro d'aqui até ao fim do livro, vae este
mesmo. O meu poeta do trem ficará sabendo que não lhe guardo rancor.
E com pequeno esforço, sendo o titulo seu, poderá cuidar que a obra
é sua. Ha livros que apenas terão isso dos seus autores; alguns nem
tanto.




II.

Do livro.

Agora que expliquei o titulo, passo a escrever o livro. Antes disso,
porém, digamos os motivos que me põem a penna na mão.

Vivo só, com um creado. A casa em que moro é propria; fil-a
construir de proposito, levado de um desejo tão particular que me
vexa imprimil-o, mas vá lá. Um dia, ha bastantes annos, lembrou-me
reproduzir no Engenho Novo a casa em que me criei na antiga rua de
Matacavallos, dando-lhe o mesmo aspecto e economia daquella outra,
que desappareceu. Constructor e pintor entenderam bem as indicações
que lhes fiz: é o mesmo predio assobradado, tres janellas de frente,
varanda ao fundo, as mesmas alcovas e salas. Na principal destas, a
pintura do tecto e das paredes é mais ou menos egual, umas grinaldas de
flores miudas e grandes passaros que as tomam nos bicos, de espaço a
espaço. Nos quatro cantos do tecto as figuras das estações, e ao centro
das paredes os medalhões de Cesar, Augusto, Nero e Massinissa, com os
nomes por baixo... Não alcanço a razão de taes personagens. Quando
fomos para a casa de Matacavallos, já ella estava assim decorada; vinha
do decennio anterior. Naturalmente era gosto do tempo metter sabor
classico e figuras antigas em pinturas americanas. O mais é tambem
analogo e parecido. Tenho chacarinha, flôres, legume, uma casuarina, um
poço e lavadouro. Uso louça velha e mobilia velha. Emfim, agora, como
outr'ora, ha aqui o mesmo contraste da vida interior, que é pacata, com
a exterior, que é ruidosa.

O meu fim evidente era atar as duas pontas da vida, e restaurar na
velhice a adolescencia. Pois, senhor, não consegui recompor o que foi
nem o que fui. Em tudo, se o rosto é egual, a physionomia é differente.
Se só me faltassem os outros, vá; um homem consola-se mais ou menos
das pessoas que perde; mas falto eu mesmo, e esta lacuna é tudo. O que
aqui está é, mal comparando, semelhante á pintura que se põe na barba e
nos cabellos, e que apenas conserva o habito externo, como se diz nas
autopsias; o interno não aguenta tinta. Uma certidão que me desse vinte
annos de edade poderia enganar os extranhos, como todos os documentos
falsos, mas não a mim. Os amigos que me restam são de data recente;
todos os antigos foram estudar a geologia dos campos santos. Quanto ás
amigas, algumas datam de quinze annos, outras de menos, e quasi todas
creem na mocidade. Duas ou tres fariam crer nella aos outros, mas a
lingua que falam obriga muita vez a consultar os diccionarios, e tal
frequencia é cançativa.

Entretanto, vida differente não quer dizer vida peor; é outra cousa.
A certos respeitos, aquella vida antiga apparece-me despida de muitos
encantos que lhe achei; mas é tambem exacto que perdeu muito espinho
que a fez molesta, e, de memoria, conservo alguma recordação doce e
feiticeira. Em verdade, pouco appareco e menos falo. Distracções raras.
O mais do tempo é gasto em hortar, jardinar e ler; como bem e não durmo
mal.

Ora, como tudo cança, esta monotonia acabou por exhaurir-me tambem.
Quiz variar, e lembrou-me escrever um livro. Jurisprudencia,
philosophia e politica acudiram-me, mas não me acudiram as forças
necessarias. Depois, pensei em fazer uma _Historia dos Suburbios_,
menos secca que as memorias do padre Luiz Gonçalves dos Santos,
relativas á cidade; era obra modesta, mas exigia documentos e datas,
como preliminares, tudo arido e longo. Foi então que os bustos pintados
nas paredes entraram a falar-me e a dizer-me que, uma vez que elles não
alcançavam reconstituir-me os tempos idos, pegasse da penna e contasse
alguns. Talvez a narração me désse a illusão, e as sombras viessem
perpassar ligeiras, como ao poeta, não o do trem, mas o do _Fausto: Ahi
vindes outra vez, inquietas sombras...?_

Fiquei tão alegre com esta ideia, que ainda agora me treme a penna na
mão. Sim, Nero, Augusto, Massinissa, e tu, grande Cesar, que me incitas
a fazer os meus commentarios, agradeço-vos o conselho, e vou deitar ao
papel as reminiscencias que me vierem vindo. Deste modo, viverei o que
vivi, e assentarei a mão para alguma obra de maior tomo. Eia, comecemos
a evocação por uma celebre tarde de Novembro, que nunca me esqueceu.
Tive outras muitas, melhores, e peores, mas aquella nunca se me apagou
do espirito. É o que vás entender, lendo.




III

A denuncia.

Ia a entrar na sala de visitas, quando ouvi proferir o meu nome e
escondi-me atraz da porta. A casa era a da rua de Matacavallos, o mez
Novembro, o anno é que é um tanto remoto, mas eu não hei de trocar as
datas á minha vida só para agradar ás pessoas que não amam historias
velhas; o anno era de 1857.

--D. Gloria, a senhora persiste na ideia de metter o nosso Bentinho no
seminario? É mais que tempo, e já agora póde haver uma difficuldade.

--Que difficuldade?

--Uma grande difficuldade.

Minha mãe quiz saber o que era. José Dias, depois de alguns instantes
de concentrarão, veiu ver se havia alguem no corredor; não deu por mim,
voltou e, abafando a voz, disse que a difficuldade estava na casa ao
pé, a gente do Padua.

--A gente do Padua?

--Ha algum tempo estou para lhe dizer isto, mas não me atrevia. Não
me parece bonito que o nosso Bentinho ande mettido nos cantos com a
filha do _Tartaruga_, e esta é a difficuldade, porque se elles pegam de
namoro, a senhora terá muito que lutar para separal-os.

--Não acho. Mettidos nos cantos?

--É um modo de falar. Em segredinhos, sempre juntos. Bentinho quasi
que não sae de lá. A pequena é uma desmiolada; o pae faz que não vê;
tomara elle que as cousas corressem de maneira, que... Comprehendo o
seu gesto; a senhora não crê em taes calculos, parece-lhe que todos têm
a alma candida...

--Mas, Sr. José Dias, tenho visto os pequenos brincando, e nunca vi
nada que faça desconfiar. Basta a edade; Bentinho mal tem quinze annos.
Capitú fez quatorze á semana passada; são dous creançolas. Não se
esqueça que foram criados juntos, desde aquella grande enchente, ha
dez annos, em que a familia Padua perdeu tanta cousa; d'ahi vieram as
nossas relações. Pois eu hei de crer...? Mano Cosme, você que acha?

Tio Cosme respondeu com um «Ora!» que, traduzido em vulgar, queria
dizer: «São imaginações do José Dias; os pequenos divertem-se, eu
divirto-me; onde está o gamão?»

--Sim, creio que o senhor está enganado.

--Póde ser, minha senhora. Oxalá tenham razão; mas creia que não falei
senão depois de muito examinar...

--Em todo caso, vae sendo tempo, interrompeu minha mãe; vou tratar de
mettel-o no seminario quanto antes.

--Bem, uma vez que não perdeu a ideia de o fazer padre, tem-se ganho o
principal. Bentinho ha de satisfazer os desejos de sua mãe. E depois
a egreja brasileira tem altos destinos. Não esqueçamos que um bispo
presidiu a Constituinte, e que o padre Feijó governou o imperio...

--Governou como a cara d'elle! atalhou tio Cosme, cedendo a antigos
rancores politicos.

--Perdão, doutor, não estou defendendo ninguem, estou citando. O que eu
quero é dizer que o clero ainda tem grande papel no Brasil.

--Você o que quer é um capote; ande, vá buscar o gamão. Quanto ao
pequeno, se tem de ser padre, realmente é melhor que não comece a dizer
missa atraz das portas. Mas, olhe cá, mana Gloria, ha mesmo necessidade
de fazel-o padre?

--É promessa, ha de cumprir-se.

--Sei que você fez promessa... mas, uma promessa assim... não sei...
Creio que, bem pensado... Você que acha, prima Justina?

--Eu?

--Verdade é que cada um sabe melhor de si, continuou tio Cosme; Deus é
que sabe do todos. Comtudo, uma promessa de tantos annos... Mas, que
é isso, mana Gloria? Está chorando? Ora esta! Pois isto é cousa de
lagrimas?

Minha mãe assoou-se sem responder. Prima Justina creio que se levantou
e foi ter com ella. Seguiu-se um alto silencio, durante o qual estive
a pique de entrar na sala, mas outra força maior, outra emoção... Não
pude ouvir as palavras que tio Cosme entrou a dizer. Prima Justina
exhortava: «Prima Gloria! prima Gloria!» José Dias desculpava-se: «Se
soubesse, não teria falado, mas falei pela veneração, pela estima, pelo
affecto, para cumprir um dever amargo, um dever amarissimo...»




IV

Um dever amarissimo!

José Dias amava os superlativos. Era um modo de dar feição monumental
ás ideias; não as havendo, servir a prolongar as phrases. Levantou-se
para ir buscar o gamão, que estava no interior da casa. Cosi-me muito á
parede, e vi-o passar com as suas calças brancas engommadas, presilhas,
rodaque e gravata de mola. Foi dos ultimos que usaram presilhas no Rio
de Janeiro, e talvez neste mundo. Trazia as calças curtas para que lhe
ficassem bem esticadas. A gravata de setim preto, com um aro de aço
por dentro, immobilisava-lhe o pescoço; era então moda. O rodaque de
chita, veste caseira o leve, parecia nelle uma casaca de cerimonia. Era
magro, chupado, com um principio de calva; teria os seus cincoenta e
cinco annos. Levantou-se com o passo vagaroso do costume, não aquelle
vagar arrastado dos preguiçosos, mas um vagar calculado e deduzido, um
syllogismo completo, a premissa antes da consequencia, a consequencia
antes da conclusão. Um dever amarissimo!




V

O aggregado.

Nem sempre ia naquelle passo vagaroso e rigido. Tambem se descompunha
em accionados, era muita vez rapido e lepido nos movimentos, tão
natural nesta como naquella maneira. Outrosim, ria largo, se era
preciso, de um grande riso sem vontade, mas communicativo, a tal ponto
as bochechas, os dentes, os olhos, toda a cara, todo a pessoa, todo o
mundo pareciam rir nelle. Nos lances graves, gravissimo.

Era nosso aggregado desde muitos annos; meu pae ainda estava na
antiga fazenda de Itaguahy, e eu acabava de nascer. Um dia appareceu
alli vendendo-se por medico homeopatha; levava um _Manual_ e uma
botica. Havia então um andaço de febres; José Dias curou o feitor
e uma escrava, e não quiz receber nenhuma remuneração. Então meu
pae propoz-lhe ficar alli vivendo, com pequeno ordenado. José Dias
recusou, dizendo que era justo levar a saude á casa de sapé do pobre.

--Quem lhe impede que vá a outras partes? Vá aonde quizer, mas fique
morando comnosco.

--Voltarei daqui a tres mezes.

Voltou dalli a duas semanas, acceitou casa e comida sem outro
estipendio, salvo o que quizessem dar por festas. Quando meu pae foi
eleito deputado e veiu para o Rio de Janeiro com a familia, elle veiu
tambem, e teve o seu quarto ao fundo da chacara. Um dia, reinando
outra vez febres em Itaguahy, disse-lhe meu pae que fosse ver a nossa
escravatura. José Dias deixou-se estar calado, suspirou e acabou
confessando que não era medico. Tomára este titulo para ajudar a
propaganda da nova escola, e não o fez sem estudar muito e muito; mas a
consciencia não lhe permittia acceitar mais doentes.

--Mas, você curou das outras vezes.

--Creio que sim; o mais acertado, porém, é dizer que foram os remedios
indicados nos livros. Elles, sim, elles, abaixo de Deus. Eu era um
charlatão... Não negue; os motivos do meu procedimento podiam ser e
eram dignos; a homeopathia é a verdade, e, para servir á verdade,
menti; mas é tempo de restabelecer tudo.

Não foi despedido, como pedia então; meu pae já não podia dispensal-o.
Tinha o dom de se fazer acceito e necessario; dava-se por falta delle,
como de pessoa de familia. Quando meu pae morreu, a dôr que o pungiu
foi enorme, disseram-me, não me lembra. Minha mãe ficou-lhe muito
grata, e não consentiu que elle deixasse o quarto da chacara; ao setimo
dia, depois da missa, elle foi despedir-se della.

--Fique, José Dias.

--Obedeço, minha senhora.

Teve um pequeno legado no testamento, uma apolice e quatro palavras de
louvor. Copiou as palavras, encaixilhou-as e pendurou-as no quarto,
por cima da cama. «Esta é a melhor apolice», dizia elle muita vez. Com
o tempo, adquiriu certa autoridade na familia, certa audiencia, ao
menos; não abusava, e sabia opinar obedecendo. Ao cabo, era amigo, não
direi optimo, mas nem tudo é optimo neste mundo. E não lhe supponhas
alma subalterna; as cortezias que fizesse vinham antes do calculo
que da indole. A roupa durava-lhe muito; ao contrario das pessoas
que enxovalham depressa o vestido novo, elle trazia o velho escovado
e liso, cirzido, abotoado, de uma elegancia pobre e modesta. Era
lido, posto que de atropello, o bastante para divertir ao serão e á
sobremesa, ou explicar algum phenomeno, falar dos effeitos do calor e
do frio, dos polos e de Robespierre. Contava muita vez uma viagem que
fizera á Europa, e confessava que a não sermos nós, já teria voltado
para lá; tinha amigos em Lisboa, mas a nossa familia, dizia elle,
abaixo de Deus, era tudo.

--Abaixo ou acima? perguntou-lhe tio Cosme um dia.

--Abaixo, repetiu José Dias cheio de veneração.

E minha mãe, que era religiosa, gostou de ver que elle punha Deus no
devido logar, e sorriu approvando. José Dias agradeceu de cabeça. Minha
mãe dava-lhe de quando em quando alguns cobres. Tio Cosme, que era
advogado, confiava-lhe a copia de papeis de autos.




VI

Tio Cosme.

Tio Cosme vivia com minha mãe, desde que ella enviuvou. Já então era
viuvo, como prima Justina; era a casa dos tres viuvos.

A fortuna troca muita vez as mãos á natureza. Formado para as serenas
funccões do capitalismo, tio Cosme não enriquecia no fòro: ia comendo.
Tinha o escriptorio na antiga rua das Violas, perto do jury, que era no
extincto Aljube. Trabalhava no crime. José Dias não perdia as defesas
oraes de tio Cosme. Era quem lhe vestia e despia a toga, com muitos
comprimentos no fim. Em casa, referia os debates. Tio Cosme, por mais
modesto que quizesse ser, sorria de persuasão.

Era gordo e pesado, tinha a respiração curta e os olhos dorminhocos.
Uma das minhas recordações mais antigas era vel-o montar todas as
manhãs a besta que minha mãe lhe deu e que o levava ao escriptorio.
O preto que a tinha ido buscar á cocheira, segurava o freio, emquanto
elle erguia o pé e pousava no estribo; a isto seguia-se um minuto de
descanço ou reflexão. Depois, dava um impulso, o primeiro, o corpo
ameaçava subir, mas não subia; segundo impulso, egual effeito. Emfim,
após alguns instantes largos, tio Cosme enfeixava todas as forças
physicas e moraes, dava o ultimo surto da terra, e desta vez caía em
cima do selim. Raramente a besta deixava de mostrar por um gesto que
acabava de receber o mundo. Tio Cosme accommodava as carnes, e a besta
partia a trote.

Tambem não me esqueceu o que elle me fez uma tarde. Posto que nascido
na roça (donde vim com dous annos) e apezar dos costumes do tempo,
eu não sabia montar, e tinha medo ao cavallo. Tio Cosme pegou em mim
e escanchou-me em cima da besta. Quando me vi no alto (tinha nove
annos), sósinho e desamparado, o chão lá embaixo, entrei a gritar
desesperadamente: «Mamãe! mamãe!» Ella acudiu pallida e tremula, cuidou
que me estivessem matando, apeou-me, affagou-me, emquanto o irmão
perguntava:

--Mana Gloria, pois um tamanhão destes tem medo de besta mansa?

--Não está acostumado.

--Deve acostumar-se. Padre que seja, se fôr vigario na roça, é preciso
que monte a cavallo; e, aqui mesmo, ainda não sendo padre, se quizer
florear como os outros rapazes, e não souber, ha de queixar-se de você,
mana Gloria.

--Pois que se queixe; tenho medo.

--Medo! Ora, medo!

A verdade é que eu só vim a apprender equitação mais tarde, menos por
gosto que por vergonha de dizer que não sabia montar. «Agora é que
elle vae namorar devéras», disseram quando eu comecei as licções. Não
se diria o mesmo de tio Cosme. Nelle era velho costume e necessidade.
Já não dava para namoros. Contam que, em rapaz, foi acceito de muitas
damas, além de partidario exaltado; mas os annos levaram-lhe o mais
do ardor politico e sexual, e a gordura acabou com o resto de ideias
publicas e especificas. Agora só cumpria as obrigações do officio e
sem amor. Nas horas de lazer vivia olhando ou jogava. Uma ou outra vez
dizia pilherias.




VII

D. Gloria.

Minha mãe era boa creatura. Quando lhe morreu o marido, Pedro de
Albuquerque Santiago, contava trinta e um annos de edade, e podia
voltar para Itaguahy. Não quiz; preferiu ficar perto da egreja em que
meu pae fòra sepultado. Vendeu a fazendola e os escravos, comprou
alguns que pôz ao ganho ou alugou, uma duzia de predios, certo numero
de apolices, e deixou-se estar na casa de Matacavallos, onde vivera
os dous ultimos annos de casada. Era filha de uma senhora mineira,
descendente de outra paulista, a familia Fernandes.

Ora, pois, naquelle anno da graça de 1857, D. Maria da Gloria Fernandes
Santiago contava quarenta e dous annos de edade. Era ainda bonita e
moça, mas teimava em esconder os saldos da juventude, por mais que a
natureza quizesse preserval-a da acção do tempo. Vivia mettida em um
eterno vestido escuro, sem adornos, com um chale preto, dobrado em
triangulo e abrochado ao peito por um camafeu. Os cabellos, em bandós,
eram apanhados sobre a nuca por um velho pente de tartaruga; alguma vez
trazia touca branca de fólhos. Lidava assim, com os seus sapatos de
cordavão rasos e surdos, a um lado e outro, vendo e guiando os serviços
todos da casa inteira, desde manhã até á noite.

Tenho alli na parede o retrato della, ao lado do do marido, taes
quaes na outra casa. A pintura escureceu muito, mas ainda dá ideia de
ambos. Não me lembra nada delle, a não ser vagamente que era alto e
usava cabelleira grande; o retrato mostra uns olhos redondos, que me
acompanham para todos os lados, effeito da pintura que me assombrava em
pequeno. O pescoço sae de uma gravata preta de muitas voltas, a cara
é toda rapada, salvo um trechosinho pegado ás orelhas. O de minha mãe
mostra que era linda. Contava então vinte annos, e tinha uma flôr entre
os dedos. No painel parece offerecer a flôr ao marido. O que se lè na
cara do ambos é que, se a felicidade conjugal póde ser comparada á
sorte grande, elles a tiraram no bilhete comprado de sociedade.

Concluo que não se devem abolir as loterias. Nenhum premiado as accusou
ainda de immoraes, como ninguem tachou de má a boceta de Pandora, por
lhe ter tirado a esperança no fundo; em alguma parte ha de ella ficar.
Aqui os tenho aos dous bem casados de outr'ora, os bem-amados, os
bem-aventurados, que se foram desta para a outra vida, continuar um
sonho provavelmente. Quando a loteria e Pandora me aborrecem, ergo os
olhos para elles, e esqueço os bilhetes brancos e a boceta fatidica.
São retratos que valem por originaes. O de minha mãe, estendendo a flôr
ao marido, parece dizer: «Sou toda sua, meu guapo cavalheiro!» O de meu
pae, olhando para a gente, faz este commentario: «Vejam como esta moça
me quer...» Se padeceram molestias, não sei, como não sei se tiveram
desgostos: era creança e comecei por não ser nascido. Depois da morte
delle, lembra-me que ella chorou muito; mas aqui estão os retratos de
ambos, sem que o encardido do tempo lhes tirasse a primeira expressão.
São como photographias instantaneas da felicidade.




VIII

É tempo!

Mas é tempo de tomar áquella tarde de Novembro, uma tarde clara e
fresca, socegada como a nossa casa e o trecho da rua em que moravamos.
Verdadeiramente foi o principio da minha vida; tudo o que succedera
antes foi como o pintar e vestir das pessoas que tinham de entrar em
scena, o accender das luzes, o preparo das rabecas, a symphonia...
Agora é que eu ia começar a minha opera. «A vida é uma opera,» dizia-me
um velho tenor italiano que aqui viveu e morreu... E explicou-me um dia
a definição, em tal maneira que me fez crer nella. Talvez valha a pena
dal-a; é só um capitulo.




IX

A opera.

Já não tinha voz, mas teimava em dizer que a tinha. «O desuso é que
me faz mal», accrescentava. Sempre que uma companhia nova chegava da
Europa, ia ao empresario e expunha-lhe todas as injustiças da terra e
do ceu; o empresario commettia mais uma, e elle saía a bradar contra
a iniquidade. Trazia ainda os bigodes dos seus papeis. Quando andava,
apezar de velho, parecia cortejar uma princeza de Babylonia. Ás vezes,
cantarolava, sem abrir a bocca, algum trecho ainda mais edoso que elle
ou tanto; vozes assim abafadas são sempre possiveis. Vinha aqui jantar
commigo algumas vezes. Uma noite, depois de muito Chianti, repetiu-me
a definição do costume, e como eu lhe dissesse que a vida tanto podia
sor uma opera, como uma viagem de mar ou uma batalha, abanou a cabeça e
replicou:

--A vida é uma opera e uma grande opera. O tenor e o barytono lutam
pelo soprano, em presença do baixo e dos comprimarios, quando não são o
soprano e o contralto que lutam pelo tenor, em presença do mesmo baixo
e dos mesmos comprimarios. Ha córos numerosos, muitos bailados, e a
orchestração é excellente...

--Mas, meu caro Marcolini...

--Quê...?

E, depois de beber um gole de licor, pousou o calix, e expoz-me a
historia da creação, com palavras que vou resumir.

Deus é o poeta. A musica é de Satanaz, joven maestro de muito futuro,
que apprendeu no conservatorio do ceu. Rival de Miguel, Raphael e
Gabriel, não tolerava a precedencia que elles tinham na distribuição
dos premios. Póde ser tambem que a musica em demasia doce e mystica
daquelles outros condiscipulos fosse aborrecivel ao seu genio
essencialmente tragico. Tramou uma rebellião que foi descoberta a
tempo, e elle expulso do conservatorio. Tudo se teria passado sem mais
nada, se Deus não houvesse escripto um libretto de opera, do qual
abrira mão, por entender que tal genero de recreio era improprio da
sua eternidade. Satanaz levou o manuscripto comsigo para o inferno.
Com o fim de mostrar que valia mais que os outros,--e acaso para
reconciliar-se com o ceu--compoz a partitura, e logo que a acabou foi
leval-a ao Padre Eterno.

--Senhor, não desapprendi as licções recebidas, disse-lhe. Aqui tendes
a partitura, escutai-a, emendai-a, fazei-a executar, e se a achardes
digna das alturas, admitti-me com ella a vossos pés...

--Não, retorquiu o Senhor, não quero ouvir nada.

--Mas, Senhor...

--Nada! nada!

Satanaz supplicou ainda, sem melhor fortuna, até que Deus, cançado e
cheio de misericordia, consentiu em que a opera fosse executada, mas
fóra do ceu. Creou um theatro especial, este planeta, e inventou uma
companhia inteira, com todas as partes, primarias e comprimarias, córos
e bailarinos.

--Ouvi agora alguns ensaios!

--Não, não quero saber de ensaios. Basta-me haver composto o libretto;
estou prompto a dividir comtigo os direitos de autor.

Foi talvez um mal esta recusa; della resultaram alguns desconcertos
que a audiencia prévia e a collaboração amiga teriam evitado. Com
effeito, ha logares em que o verso vae para a direita e a musica para
a esquerda. Não falta quem diga que nisso mesmo está a belleza da
composição, fugindo á monotonia, e assim explicam o tercetto do Eden,
a aria de Abel, os córos da guilhotina e da escravidão. Não é raro que
os mesmos lances se reproduzam, sem razao sufficiente. Certos motivos
cançam á força de repetição. Tambem ha obscuridades; o maestro abusa
das massas choraes, encobrindo muita vez o sentido por um modo confuso.
As partes orchestraes são aliás tratadas com grande pericia. Tal é a
opinião dos imparciaes.

Os amigos do maestro querem que difficilmente se possa achar obra
tão bem acabada. Um ou outro admitte certas rudezas e taes ou
quaes lacunas, mas com o andar da opera é provavel que estas sejam
preenchidas ou explicadas, e aquellas desapparecam inteiramente, não se
negando o maestro a emendar a obra onde achar que não responde de todo
ao pensamento sublime do poeta. Já não dizem o mesmo os amigos deste.
Juram que o libretto foi sacrificado, que a partitura corrompeu o
sentido da lettra, e, posto seja bonita em alguns logares, e trabalhada
com arte em outros, é absolutamente diversa e até contraria ao drama. O
grotesco, por exemplo, não está no texto do poeta; é uma excrescencia
para imitar as _Mulheres patuscas de Windsor._ Este ponto é contestado
pelos satanistas com alguma apparencia de razão. Dizem elles que, ao
tempo em que o joven Satanaz compoz a grande opera, nem essa farça nem
Shakespeare eram nascidos. Chegam a affirmar que o poeta inglez não
teve outro genio senão transcrever a lettra da opera, com tal arte
e fidelidade, que parece elle proprio o autor da composição; mas,
evidentemente, é um plagiario.

--Esta peça, concluiu o velho tenor, durará emquanto durar o theatro,
não se podendo calcular em que tempo será elle demolido por utilidade
astronomica. O exito é crescente. Poeta e musico recebem pontualmente
os seus direitos autoraes, que não são os mesmos, porque a regra da
divisão é aquillo da Escriptura: «Muitos são os chamados, poucos os
escolhidos.» Deus recebe em ouro, Satanaz em papel.

--Tem graça...

--Graça? bradou elle com furia; mas aquietou-se logo, e replicou: Caro
Santiago, eu não tenho graça, eu tenho horror á graça. Isto que digo é
a verdade pura e ultima. Um dia, quando todos os livros forem queimados
por inuteis, ha de haver alguem, póde ser que tenor, e talvez italiano,
que ensine esta verdade aos homens. Tudo é musica, meu amigo. No
principio era o _dó_, e o _dó_ fez-se _ré_, etc. Este calix (e enchia-o
novamente) este calix é um breve estribilho. Não se ouve? Tambem não se
ouve o pau nem a pedra, mas tudo cabe na mesma opera...




X

Acceito a theoria.

Que é demasiada metaphysica para um só tenor, não ha duvida; mas a
perda da voz explica tudo, e ha philosophos que são, em resumo, tenores
desempregados.

Eu, leitor amigo, acceito a theoria do meu velho Marcolini, não só pela
verosimilhança, que é muita vez toda a verdade, mas porque a minha vida
se casa bem á definição. Cantei um _duo_ ternissimo, depois um _trio_,
depois um _quatuor..._ Mas não adeantemos; vamos á primeira tarde, em
que eu vim a saber que já cantava, porque a denuncia de José Dias,
meu caro leitor, foi dada principalmente a mim. A mim é que elle me
denunciou.




XI

A promessa.

Tão depressa vi desapparecer o aggregado no corredor, deixei o
esconderijo, e corri á varanda do fundo. Não quiz saber de lagrimas nem
da causa que as fazia verter a minha mãe. A causa eram provavelmente os
seus projectos ecclesiasticos, e a occasião destes é a que vou dizer,
por ser já então historia velha; datava de dezeseis annos.

Os projectos vinham do tempo em que fui concebido. Tendo-lhe nascido
morto o primeiro filho, minha mãe pegou-se com Deus para que o segundo
vingasse, promettendo, se fosse varão, mettel-o na egreja. Talvez
esperasse uma menina. Não disse nada a meu pae, nem antes, nem depois
de me dar á luz; contava fazel-o quando eu entrasse para a escola,
mas enviuvou antes disso. Viuva, sentiu terror de separar-se de mim;
mas era tão devota, tão temente a Deus, que buscou testemunhas da
obrigação, confiando a promessa a parentes e familiares. Unicamente,
para que nos separassemos o mais tarde possivel, fez-me apprender em
casa primeiras lettras, latim e doutrina, por aquelle padre Cabral,
velho amigo do tio Cosme, que ia lá jogar ás noites.

Prazos largos são faceis de subscrever; a imaginação os faz infinitos.
Minha mãe esperou que os annos viessem vindo. Entretanto, ia-me
affeiçoando á ideia da egreja; brincos de creança, livros devotos,
imagens de santos, conversações de casa, tudo convergia para o altar.
Quando iamos á missa, dizia-me sempre que era para apprender a ser
padre, e que reparasse no padre, não tirasse os olhos do padre. Em
casa, brincava de missa,--um tanto ás escondidas, porque minha mãe
dizia que missa não era cousa de brincadeira. Arranjavamos um altar,
Capitú e eu. Ella servia de sacristão, e alteravamos o ritual, no
sentido do dividirmos a hostia entre nós; a hostia era sempre um
doce. No tempo em que brincavamos assim, era muito commum ouvir á
minha visinha: «Hoje ha missa?» Eu já sabia o que isto queria dizer,
respondia affirmativamente, e ia pedir hostia por outro nome. Voltava
com ella, arranjavamos o altar, engrolavamos o latim e precipitavamos
as cerimonias. _Dominus, non sum dignus..._ Isto, que eu devia dizer
tres vezes, penso que só dizia uma, tal era a golodice do padre e do
sacristão. Não bebiamos vinho nem agua; não tinhamos o primeiro, e a
segunda viria tirar-nos o gosto do sacrificio.

Ultimamente não me falavam já do seminario, a tal ponto que eu suppunha
ser negocio findo. Quinze annos, não havendo vocação, pediam antes o
seminario do mundo que o de S. José. Minha mãe ficava muita vez a olhar
para mim, como alma perdida, ou pegava-me na mão, a pretexto de nada,
para apertal-a muito.




XII

Na varanda.

Parei na varanda; ia tonto, atordoado, as pernas bambas, o coração
parecendo querer sair-me pela bocca fóra. Não me atrevia a descer á
chacara, e passar ao quintal visinho. Comecei a andar de um lado para
outro, estacando para amparar-me, e andava outra vez e estacava. Vozes
confusas repetiam o discurso do José Dias:

«Sempre juntos...»

«Em segredinhos...»

«Se elles pegam de namoro...»

Tijolos que pisei e repisei naquella tarde, columnas amarelladas que
me passastes á direita ou á esquerda, segundo eu ia ou vinha, em vós
me ficou a melhor parte da crise, a sensação de um goso novo, que me
envolvia em mim mesmo, e logo me dispersava, e me trazia arrepios, e
me derramava não sei que balsamo interior. Ás vezes dava por mim,
sorrindo, um ar do riso de satisfação, que desmentia a abominação do
meu peccado. E as vozes repetiam-se confusas:

«Em segredinhos...»

«Sempre juntos...»

«Se elles pegam de namoro...»

Um coqueiro, vendo-me inquieto e adivinhando a causa, murmurou de
cima de si que não era feio que os meninos de quinze annos andassem
nos cantos com as meninas de quatorze; ao contrario, os adolescentes
daquella edade não tinham outro officio, nem os cantos outra utilidade.
Era um coqueiro velho, e eu cria nos coqueiros velhos, mais ainda que
nos velhos livros. Passaros, borboletas, uma cigarra que ensaiava o
estio, toda a gente viva do ar era da mesma opinião.

Com que então eu amava Capitú, e Capitú a mim? Realmente, andava cosido
ás saias della, mas não me occorria nada entre nós que fosse devéras
secreto. Antes della ir para o collegio, eram tudo travessuras de
creanca; depois que saiu do collegio, é certo que não restabelecemos
logo a antiga intimidade, mas esta voltou pouco a pouco, e no ultimo
anno era completa. Entretanto, a materia das nossas conversações era
a de sempre. Capitú chamava-me ás vezes bonito, mocetão, uma flòr;
outras pegava-me nas mãos para contar-me os dedos. E comecei a recordar
esses e outros gestos e palavras, o prazer que sentia quando ella
me passava a mão pelos cabellos, dizendo que os achava lindissimos.
Eu, sem fazer o mesmo aos della, dizia que os della eram muito mais
lindos que os meus. Então Capitú abanava a cabeça com uma grande
expressão de desengano e melancolia, tanto mais de espantar quanto que
tinha os cabellos realmente admiraveis; mas eu retorquia chamando-lhe
maluca. Quando me perguntava se sonhára com ella na vespera, e eu
dizia que não, ouvia-lhe contar que sonhára commigo, e eram aventuras
extraordinarias, que subiamos ao Corcovado pelo ar, que dansavamos na
lua, ou então que os anjos vinham perguntar-nos pelos nomes, afim de
os dar a outros anjos que acabavam de nascer. Em todos esses sonhos
andavamos unidinhos. Os que eu tinha com ella não eram assim, apenas
reproduziam a nossa familiaridade, e muita vez não passavam da simples
repetição do dia, alguma phrase, algum gesto. Tambem eu os contava.
Capitú um dia notou a differença, dizendo que os della eram mais
bonitos que os meus; eu, depois de certa hesitação, disse-lhe que eram
como a pessoa que sonhava... Fez-se còr de pitanga.

Pois, francamente, só agora entendia a emoção que me davam essas e
outras confidencias. A emoção era doce e nova, mas a causa della
fugia-me, sem que eu a buscasse nem suspeitasse. Os silencios dos
ultimos dias, que me não descobriam nada, agora os sentia como signaes
de alguma cousa, e assim as meias palavras, as perguntas curiosas, as
respostas vagas, os cuidados, o gosto de recordar a infancia. Tambem
adverti que era phenomeno recente accordar com o pensamento em Capitú,
e escutal-a de memoria, e estremecer quando lhe ouvia os passos. Se
se falava nella, em minha casa, prestava mais altenção que d'antes,
e, segundo era louvor ou critica, assim me trazia gosto ou desgosto
mais intensos que outr'ora, quando eramos sómente companheiros de
travessuras. Cheguei a pensar nella durante as missas daquelle mez, com
intervallos, é verdade, mas com exclusivismo tambem.

Tudo isto me era agora apresentado pela bocca de José Dias, que me
denunciara a mim mesmo, e a quem eu perdoava tudo, o mal que dissera,
o mal que fizera, e o que pudesse vir de um e do outro. Naquelle
instante, a eterna Verdade não valeria mais que elle, nem a eterna
Bondade, nem as demais Virtudes eternas. Em amava Capitú! Capitú
amava-me! E as minhas pernas andavam, desandavam, estacavam, tremulas
e crentes de abarcar o mundo. Esse primeiro palpitar da seiva, essa
revelação da consciencia a si propria, nunca mais me esqueceu, nem
achei que lhe fosse comparavel qualquer outra sensação da mesma
especie. Naturalmente por ser minha. Naturalmente tambem por ser a
primeira.




XIII

Capitú.

De repente, ouvi bradar uma voz de dentro da casa ao pé:

--Capitú!

E no quintal:

--Mamãe!

E outra vez na casa:

--Vem cá!

Não me pude ter. As pernas desceram-me os tres degraus que davam para
a chacara, e caminharam para o quintal visinho. Era costume dellas, ás
tardes, e ás manhãs tambem. Que as pernas tambem são pessoas, apenas
interiores aos braços, e valem de si mesmas, quando a cabeça não as
rege por meio de ideias. As minhas chegaram ao pé do muro. Havia alli
uma porta de communicação mandada rasgar por minha mãe, quando Capitú
e eu éramos pequenos. A porta não tinha chave nem taramela, abria-se
empurrando de um lado ou puxando de outro, e fechava-se ao peso de
uma pedra pendente de uma corda. Era quasi que exclusivamente nossa.
Em creancas, faziamos visita batendo de um lado, e sendo recebidos
do outro com muitas mesuras. Quando as bonecas de Capitú adoeciam,
o medico era eu. Entrava no quintal della com um pau debaixo do
braço, para imitar o bengalão do doutor João da Costa; tomava o pulso
á doente, e pedia-lhe que mostrasse a lingua. «É surda, coitada!»
exclamava Capitú. Então eu coçava o queixo, como o doutor, e acabava
mandando applicar-lhe umas sanguesugas ou dar-lhe um vomitorio: era a
therapeutica habitual do medico.

--Capitú!

--Mamãe!

--Deixa de estar esburacando o muro; vem cá.

A voz da mãe era agora mais perto, como se viesse já da porta dos
fundos. Quiz passar ao quintal, mas as pernas, ha pouco tão andarilhas,
pareciam agora presas ao chão. Afinal fiz um esforço, empurrei a porta,
e entrei. Capitú estava ao pé do muro fronteiro, voltada para elle,
riscando com um prego. O rumor da porta fel-a olhar para traz; ao dar
commigo, encostou-se ao muro, como se quizesse esconder alguma cousa.
Caminhei para ella; naturalmente levava o gesto mudado, porque ella
veiu a mim, e perguntou-me inquieta:

--Que é que você tem?

--Eu? Nada.

--Nada, não; você tem alguma cousa.

Quiz insistir que nada, mas não achei lingua. Todo eu era olhos e
coração, um coração que desta vez ia sair, com certeza, pela bocca
fora. Não podia tirar os olhos daquella creatura de quatorze annos,
alta, forte e cheia, apertada em um vestido de chita, meio desbotado.
Os cabellos grossos, feitos em duas tranças, com as pontas atadas uma á
outra, á moda do tempo, desciam-lhe pelas costas. Morena, olhos claros
e grandes, nariz recto e comprido, tinha a bocca fina e o queixo largo.
As mãos, a despeito de alguns officios rudes, eram curadas com amor;
não cheiravam a sabões finos nem aguas de toucador, mas com agua do
poço e sabão commum trazia-as sem macula. Calçava sapatos de duraque,
rasos e velhos, a que ella mesma dera alguns pontos.

--Que é que você tem? repetiu.

--Não é nada, balbuciei finalmente.

E emendei logo:

--É uma noticia.

--Noticia de què?

Pensei em dizer-lhe que ia entrar para o seminario e espreitar a
impressão que lhe faria. Se a consternasse é que realmente gostava de
mim; se não, é que não gostava. Mas todo esse calculo foi obscuro e
rapido; senti que não poderia falar claramente, tinha agora a vista não
sei como...

--Então?

--Você sabe...

Nisto olhei para o muro, o logar em que ella estivera riscando,
escrevendo ou esburacando, como dissera a mãe. Vi uns riscos abertos, e
lembrou-me o gesto que ella fizera para cobril-os. Então quiz vel-os
de perto, e dei um passo. Capitú agarrou-me, mas, ou por temer que
eu acabasse fugindo, ou por negar de outra maneira, correu adeante e
apagou o escripto. Foi o mesmo que accender em mim o desejo de ler o
que era.




XIV

A inscripção.

Tudo o que contei no fim do outro capitulo foi obra de um instante.
O que se lhe seguiu foi ainda mais rapido. Dei um pulo, e antes que
ella raspasse o muro, li estes dous nomes, abertos ao prego, o assim
dispostos:

BENTO CAPITOLINA

Voltei-me para ella; Capitú tinha os olhos no chão. Ergueu-os logo,
devagar, e ficámos a olhar um para o outro... Confissão de creanças,
tu valias bem duas ou tres paginas, mas quero ser poupado. Em verdade,
não falámos nada; o muro falou por nós. Não nos movemos, as mãos é que
se estenderam pouco a pouco, todas quatro, pegando-se, apertando-se,
fundindo-se. Não marquei a hora exacta daquelle gesto. Devia tel-a
marcado; sinto a falta de uma nota escripta naquella mesma noite, e
que eu poria aqui com os erros de orthographia que trouxesse, mas não
traria nenhum, tal era a differença entre o estudante e o adolescente.
Conhecia as regras do escrever, sem suspeitar as do amar; tinha orgias
de latim e era virgem de mulheres.

Não soltámos as mãos, nem ellas se deixaram cair de cançadas ou de
esquecidas. Os olhos fitavam-se e desfitavam-se, e depois de vagarem ao
perto, tornavam a metter-se uns pelos outros... Padre futuro, estava
assim deante della como de um altar, sendo uma das faces a Epistola e
a outra o Evangelho. A bocca podia ser o calix, os labios a patena.
Faltava dizer a missa nova, por um latim que ninguem apprende, e é a
lingua catholica dos homens. Não me tenhas por sacrilego, leitora minha
devota; a limpeza da intenção lava o que puder haver menos curial no
estylo. Estavamos alli com o ceu em nós. As mãos, unindo os nervos,
faziam das duas creaturas uma só, mas uma só creatura seraphica. Os
olhos continuaram a dizer cousas infinitas, as palavras de bocca é que
nem tentavam sair, tornavam ao coração caladas como vinham...




XV

Outra voz repentina.

Outra voz repentina, mas desta vez uma voz de homem:

--Vocês estão jogando o siso?

Era o pae de Capitú, que estava á porta dos fundos, ao pé da mulher.
Soltámos as mãos depressa, e ficámos atrapalhados. Capitú foi ao muro,
e, com o prego, disfarçadamente, apagou os nossos nomes escriptos.

--Capitú!

--Papae!

--Não me estragues o reboco do muro.

Capitú riscava sobre o riscado, para apagar bem o escripto. Padua saiu
ao quintal, a ver o que era, mas já a filha tinha começado outra cousa,
um perfil, que disse ser o retrato delle, e tanto podia ser delle como
da mãe; fel-o rir, era o essencial. De resto, elle chegou sem colera,
todo meigo, apezar do gesto duvidoso ou menos que duvidoso em que nos
apanhou. Era um homem baixo e grosso, pernas e braços curtos, costas
abahuladas, donde lhe veiu a alcunha de Tartaruga, que José Dias lhe
poz. Ninguem lhe chamava assim lá em casa; era só o aggregado.

--Vocês estavam jogando o siso? perguntou,

Olhei para um pé do sabugueiro que ficava perto; Capitú respondeu por
ambos.

--Estavamos, sim, senhor, mas Bentinho ri logo, não aguenta.

--Quando eu cheguei á porta, não ria.

--Já tinha rido das outras vezes; não póde. Papae quer ver?

E séria, fitou em mim os olhos, convidando-me ao jogo. O susto é
naturalmente serio; eu estava ainda sob a acção do que trouxe a entrada
de Padua, e não fui capaz de rir, por mais que devesse fazel-o, para
legitimar a resposta de Capitú. Esta, cançada de esperar, desviou
o rosto, dizendo que eu não ria daquella vez por estar ao pé do
pae. E nem assim ri. Ha cousas que só se apprendem tarde; é mister
nascer com ellas para fazel-as cedo. E melhor é naturalmente cedo que
artificialmente tarde. Capitú, após duas voltas, foi ter com a mãe,
que continuava á porta da casa, deixando-nos a mim e ao pae encantados
della; o pae, olhando para ella e para mim, dizia-me, cheio de ternura:

--Quem dirá que esta pequena tem quatorze annos? Parece dezesete. Mamãe
está boa? continuou voltando-se inteiramente para mim.

--Está.

--Ha muitos dias que não a vejo. Estou com vontade de dar um capote
ao doutor, mas não tenho podido, ando com trabalhos da repartição, em
casa; escrevo todos os noites que é em desespero; negocio de relatorio.
Você já viu o meu gaturamo? Está alli no fundo. Ia agora mesmo buscar a
gaiola; ande ver.

Que o meu desejo era nenhum, crê-se facilmente, sem ser preciso jurar
pelo ceu nem pela terra. Meu desejo era ir atraz de Capitú e falar-lhe
agora do mal que nos esperava, mas o pae era o pae, e demais amava
particularmente os passarinhos. Tinha-os de varia especie, côr e
tamanho. A área que havia no centro da casa era cercada de gaiolas de
canarios, que faziam cantando um barulho de todos os diabos. Trocava
passaros com outros amadores, comprava-os, apanhava alguns, no proprio
quintal, armando alçapões. Tambem, se adoeciam, tratava delles como se
fossem gente.




XVI

O administrador interino.

Padua era empregado em repartição dependente do ministerio da guerra.
Não ganhava muito, mas a mulher gastava pouco, e a vida era barata.
Demais, a casa em que morava, assobradada como a nossa, posto que
menor, era propriedade delle. Comprou-a com a sorte grande que lhe saiu
n'um meio bilhete de loteria, dez contos de reis. A primeira ideia do
Padua, quando lhe saiu o premio, foi comprar um cavallo do Cabo, um
adereço de brilhantes para a mulher, uma sepultura perpetua de familia,
mandar vir da Europa alguns passaros, etc.; mas a mulher, esta D.
Fortunata que alli está á porta dos fundos da casa, em pé, falando á
filha, alta, forte, cheia, como a filha, a mesma cabeça, os mesmos
olhos claros, a mulher é que lhe disse que o melhor era comprar a casa,
e guardar o que sobrasse para acudir ás molestias grandes. Padua
hesitou muito; afinal, teve de ceder aos conselhos de minha mãe, a quem
D. Fortunata pediu auxilio. Nem foi só nessa occasião que minha mãe
lhes valeu; um dia chegou a salvar a vida ao Padua. Escutai; a anecdota
é curta.

O administrador da repartição em que Padua trabalhava teve de ir ao
Norte, em commissão. Padua, ou por ordem regulamentar, ou por especial
designação, ficou substituindo o administrador com os respectivos
honorarios. Esta mudança de fortuna trouxe-lhe certa vertigem: era
antes dos dez contos. Não se contentou de reformar a roupa e a copa,
atirou-se ás despezas superfluas, deu joias á mulher, nos dias de
festa matava um leitão, era visto em theatros, chegou aos sapatos de
verniz. Viveu assim vinte e dous mezes na supposição de uma eterna
interinidade. Uma tarde entrou em nossa casa, afflicto e desvairado,
ia perder o logar, porque chegara o effectivo naquella manhã. Pediu a
minha mãe que velasse pelas infelizes que deixava; não podia soffrer
a desgraça, matava-se. Minha mãe falou-lhe com bondade, mas elle não
attendia a cousa nenhuma.

--Não, minha senhora, não consentirei em tal vergonha! Fazer descer
a familia, tornar atraz... Já disse, mato-me! Não hei de confessar á
minha gente esta miseria. E os outros? Que dirão os visinhos? E os
amigos? E o publico?

--Que publico, Sr. Padua? Deixe-se disso; seja homem. Lembre-se que sua
mulher não tem outra pessoa... e que ha de fazer? Pois um homem...
Seja homem, ande.

Padua enxugou os olhos e foi para casa, onde viveu prostrado alguns
dias, mudo, fechado na alcova,--ou então no quintal, ao pé do poço,
como se a ideia da morte teimasse nelle. D. Fortunata ralhava:

--Joãosinho, você é creança?

Mas, tanto lhe ouviu falar em morte que teve medo, e um dia correu
a pedir a minha mãe que lhe fizesse o favor de ver se lhe salvava o
marido que se queria matar. Minha mãe foi achal-o á beira do poço, e
intimou-lhe que vivesse. Que maluquice era aquella de parecer que ia
ficar desgraçado, por causa de uma gratificação menos, e perder um
emprego interino? Não, senhor, devia ser homem, pae de familia, imitar
a mulher e a filha... Padua obedeceu; confessou que acharia forças para
cumprir a vontade de minha mãe.

--Vontade minha, não; é obrigação sua.

--Pois seja obrigação; não desconheço que é assim mesmo.

Nos dias seguintes, continuou a entrar e sair de casa, cosido á parede,
cara no chão. Não era o mesmo homem que estragava o chapéo em cortejar
a visinhança, risonho, olhos no ar, antes mesmo da administração
interina. Vieram as semanas, a ferida foi sarando. Padua começou a
interessar-se pelos negocios domesticos, a cuidar dos passarinhos, a
dormir tranquillo as noites e as tardes, a conversar e dar noticias da
rua. A serenidade regressou; atraz della veiu a alegria, um domingo,
na figura de dous amigos, que iam jogar o solo, a tentos. Já elle ria,
já brincava, tinha o ar do costume; a ferida sarou de todo.

Com o tempo veiu um phenomeno interessante. Padua começou a falar da
administração interina, não sómente sem as saudades dos honorarios,
nem o vexame da perda, mas até com desvanecimento e orgulho. A
administração ficou sendo a hegyra, donde elle contava para deante e
para traz.

--No tempo em que eu era administrador...

Ou então:

--Ah! sim, lembra-me, foi antes da minha administração, um ou dous
mezes antes... Ora espere; a minha administração começou... É isto, mez
e meio antes; foi mez e meio antes, não foi mais.

Ou ainda:

--Justamente; havia já seis mezes que eu administrava...

Tal é o sabor posthumo das glorias interinas. José Dias bradava que
era a vaidade sobrevivente; mas o padre Cabral, que levava tudo para a
Escriptura, dizia que com o visinho Padua se dava a licção de Eliphaz a
Job: «Não desprezes a correcção do Senhor; elle fere e cura.»




XVII

Os vermes.

«Elle fere e cura!» Quando, mais tarde, vim a saber que a lança
de Achilles tambem curou uma ferida que fez, tive taes ou quaes
velleidades de escrever uma dissertação a este proposito. Cheguei a
pegar em livros velhos, livros mortos, livros enterrados, a abril-os, a
comparal-os, calando o texto e o sentido, para achar a origem commum do
oraculo pagão e do pensamento israelita. Catei os proprios vermes dos
livros, para que me dissessem o que havia nos textos roidos por elles.

--Meu senhor, respondeu-me um longo verme gordo, uns não sabemos
absolutamente nada dos textos que roemos, nem escolhemos o que roemos,
nem amamos ou detestamos o que roemos; nós roemos.

Não lhe arranquei mais nada. Os outros todos, como se houvessem
passado palavra, repeliam a mesma cantilena. Talvez esse discreto
silencio sobre os textos roidos, fosse ainda um modo de roer o roido.




XVIII

Um plano.

Pae nem mãe foram ter comnosco, quando Capitú e eu, na sala de visitas,
falavamos do seminario. Com os olhos em mim, Capitú queria saber que
noticia era a que me affligia tanto. Quando lhe disse o que era, fez-se
côr de cêra.

--Mas eu não quero, acudi logo, não quero entrar em seminarios; não
entro, é excusado teimarem commigo, não entro.

Capitú, a principio não disse nada. Recolheu os olhos, metteu-os
em si e deixou-se estar com as pupillas vagas e surtias, a bocca
entre-aberta, toda parada. Então eu, para dar forca ás affirmações,
comecei a jurar que não seria padre. Naquelle tempo jurava muito e
rijo, pela vida e pela morte. Jurei pela hora da morte. Que a luz me
faltasse na hora da morte se fosse para o seminario. Capitú não parecia
crer nem descrer, não parecia sequer ouvir; era uma figura de pau. Quiz
chamal-a, sacudil-a, mas faltou-me animo. Essa creatura que brincára
commigo, que pulára, dansára, creio até que dormira commigo, deixava-me
agora com os braços atados e medrosos. Emfim, tornou a si, mas tinha a
cara livida, e rompeu nestas palavras furiosas:

--Beata! carola! papa-missas!

Fiquei aturdido. Capitú gostava tanto de minha mãe, e minha mãe della,
que eu não podia entender tamanha explosão. É verdade que tambem
gostava de mim, e naturalmente mais, ou melhor, ou de outra maneira,
cousa bastante a explicar o despeito que lhe trazia a ameaça da
separação; mas os improperios, como entender que lhe chamasse nomes tão
feios, e principalmente para deprimir costumes religiosos, que eram os
seus? Que ella tambem ia á missa, e tres ou quatro vezes minha mãe é
que a levou, na nossa velha sege. Tambem lhe dera um rosario, uma cruz
de ouro e um livro de _Horas..._ Quiz defendel-a, mas Capitú não me
deixou, continuou a chamar-lhe beata e carola, em voz tão alta que tive
medo fosse ouvida dos paes. Nunca a vi tão irritada como então; parecia
disposta a dizer tudo a todos. Cerrava os dentes, abanava a cabeça...
Eu, assustado, não sabia que fizesse; repetia os juramentos, promettia
ir naquella mesma noite declarar em casa que, por nada neste mundo,
entraria no seminario.

--Você? Você entra.

--Não entro.

--Você verá se entra ou não.

Calou-se outra vez. Quando tornou a falar, tinha mudado; não era ainda
a Capitú do costume, mas quasi. Estava seria, sem afflicção, falava
baixo. Quiz saber a conversação da minha casa; eu contei-lh'a toda,
menos a parte que lhe dizia respeito.

--E que interesse tem José Dias em lembrar isto? perguntou-me no fim.

--Acho que nenhum; foi só para fazer mal. É um sujeito muito ruim; mas,
deixe estar que me ha de pagar. Quando eu fôr dono da casa, quem vae
para a rua é elle, você verá; não me fica um instante. Mamãe é boa de
mais; dá-lhe attenção de mais. Parece até que chorou.

--José Dias?

--Não, mamãe.

--Chorou porque?

--Não sei; ouvi só dizer que ella não chorasse, que não era cousa de
choro... Elle chegou a mostrar-se arrependido, e saiu; eu então, para
não ser apanhado, deixei o canto e corri para a varanda. Mas, deixe
estar, que elle me paga!

Disse isto fechando o punho, e proferi outras ameaças. Ao relembral-as,
não me acho ridiculo; a adolescencia e a infancia não são, neste ponto,
ridiculas; e um dos seus privilegios. Este mal ou este perigo começa
na mocidade, cresce na madurera e attinge o maior grão na velhice. Aos
quinze annos, ha até certa graça em ameaçar muito e não executar nada.

Capitú reflectia. A reflexão não era cousa rara nella, e conheciam-se
as occasiões pelo apertado dos olhos. Pediu-me algumas circumstancias
mais, as proprias palavras de uns e de outros, e o tom dellas. Como eu
não queria dizer o ponto inicial da conversa, que era ella mesma, não
lhe pude dar toda a significação. A attenção de Capitú estava agora
particularmente nas lagrimas de minha mãe; não acabava de entendel-as.
Em meio disto, confessou que certamente não era por mal que minha mãe
me queria fazer padre; era a promessa antiga, que ella, temente a Deus,
não podia deixar de cumprir. Fiquei tão satisfeito de ver que assim
espontaneamente reparava as injurias que lhe sairam do peito, pouco
antes, que peguei da mão della e apertei-a muito. Capitú deixou-se ir,
rindo; depois a conversa entrou a cochilar e dormir. Tinhamos chegado
á janella; um preto, que, desde algum tempo, vinha apregoando cocadas,
parou em frente e perguntou:

--Sinhásinha, qué cocada hoje?

--Não, respondeu Capitú.

--Cocadinha tá boa.

--Vá-se embora, replicou ella sem rispidez.

--Dê ca! disse eu descendo o braço para receber duas.

Comprei-as, mas tive de as comer sósinho; Capitú recusou. Vi que, em
meio da crise, eu conservava um canto para as cocadas, o que tanto póde
ser perfeição como imperfeição, mas o momento não é para definições
taes; fiquemos em que a minha amiga, apezar de equilibrada e lucida,
não quiz saber de doce, e gostava muito de doce. Ao contrario, o
pregão que o preto foi cantando, o prégão das velhas tardes, tão sabido
do bairro e da nossa infancia:

     Chora, menina, chora,
     Chora, porque não tem
             Vintem,

a modo que lhe deixára uma impressão aborrecida, Da toada não era;
ella a sabia de cór e de longe, usava repetil-a nos nossos jogos da
puericia, rindo, saltando, trocando os papeis commigo, ora vendendo,
ora comprando um doce ausente. Creio que a lettra, destinada a picar
a vaidade das crianças, foi que a enojou agora, porque logo depois me
disse:

--Se eu fosse rica, você fugia, mettia-se no paquete e ia para a Europa.

Dito isto, espreitou-me os olhos, mas creio que elles não lhe disseram
nada, ou só agradeceram a boa intenção. Com effeito, o sentimento era
tão amigo que eu podia excusar o extraordinario da aventura.

Como vês, Capitú, aos quatorze annos, tinha já ideias atrevidas,
muito menos que outras que lhe vieram depois; mas eram só atrevidas
em si, na pratica faziam-se habeis, sinuosas, surdas, e alcançavam o
fim proposto, não de salto, mas aos saltinhos. não sei se me explico
bem. Supponde uma concepção grande executada por meios pequenos.
Assim, para não sair do desejo vago e hypothetico de me mandar para
a Europa, Capitú, se pudesse cumpril-o, não me faria embarcar no
paquete e fugir; estenderia uma fila de canoas daqui até lá, por
onde eu, parecendo ir á fortaleza da Lage em ponte movediça, iria
realmente até Bordéos, deixando minha mãe na praia, á espera. Tal era
a feição particular do caracter da minha amiga; pelo que, não admira
que, combatendo os meus projectos de resistencia franca, fosse antes
pelos meios brandos, pela acção do empenho, da palavra, da persuasão
lenta e diuturna, e examinasse antes as pessoas com quem podiamos
contar. Rejeitou tio Cosme; era um «boa-vida»; se não approvava a
minha ordenação, não era capaz de dar um passo para suspendel-a. Prima
Justina era melhor que elle, e melhor que os dous seria o padre Cabral,
pela autoridade, mas o padre não havia de trabalhar contra a egreja; só
se eu lhe confessasse que não tinha vocação....

--Posso confessar?

--Pois, sim, mas seria apparecer francamente, e o melhor é outra cousa.
José Dias....

--Que tem José Dias?

--Póde ser um bom empenho.

--Mas se foi elle mesmo que falou....

--Não importa, continuou Capitú; dirá agora outra cousa. Elle gosta
muito de você. Não lhe fale acanhado. Tudo é que você não tenha medo,
mostre que ha de vir a ser dono da casa, mostre que quer e que póde.
Dê-lhe bem a entender que não é favor. Faça-lhe tambem elogios; elle
gosta muito de ser elogiado. D. Gloria presta-lhe attenção; mas o
principal não é isso; é que elle, tendo de servir a você, falará com
muito mais calor que outra pessoa.

--Não acho. não, Capitú.

--Então vá para o seminario.

--Isso não.

--Mas que se perde em experimentar? Experimentemos; faça o que lhe
digo. D. Gloria póde ser que mude de resolução; se não mudar, faz-se
outra cousa, mette-se então o padre Cabral. Você não se lembra como
é que foi ao theatro pela primeira vez, ha dous mezes? D. Gloria não
queria, e bastava isso para que José Dias não teimasse; mas elle queria
ir, e fez um discurso, lembra-se?

--Lembra-me; disse que o theatro era uma escola de costumes.

--Justo; tanto falou que sua mãe acabou consentindo, e pagou a entrada
aos dous.... Ande, peça, mande. Olhe; diga-lhe que está prompto a ir
estudar leis em S. Paulo.

Estremeci de prazer. S. Paulo era um fragil biombo, destinado a ser
arredado um dia, em vez da grossa parede espiritual e eterna. Prometti
falar a José Dias nos termos propostos. Capitú repetiu-os, accentuando
alguns, como principaes; e inquiria-me depois sobre elles, a ver se
entendera bem, se não trocara uns por outros. E insistia em que pedisse
com boa cara, mas assim como quem pede um copo de agua a pessoa que
tem obrigação de o trazer. Conto estas minucias para que melhor se
entenda aquella manhã da minha amiga; logo virá a tarde, e da manhã
e da tarde se fará o primeiro dia, como no Genesis, onde se fizeram
successivamente sete.




XIX

Sem falta.

Quando voltei a casa era noite. Vim depressa, não tanto, porém, que não
pensasse nos termos em que falaria ao aggregado. Formulei o pedido de
cabeça, escolhendo as palavras que diria e o tom dellas, entre secco
e benevolo. Na chacara, antes de entrar em casa, repeti-as commigo,
depois em voz alia, para ver se eram adequadas e se obedeciam ás
recommendações de Capitú: «Preciso falar-lhe, _sem falta_, amanhã;
escolha o logar e diga-me.» Proferi-as lentamente, e mais lentamente
ainda as palavras _sem falta_, como para sublinhal-as. Repeti-as ainda,
e então achei-as seccas de mais, quasi rispidas, e, francamente,
improprias de um creançola para um homem maduro. Cuidei de escolher
outras, e parei.

Afinal disse commigo que as palavras podiam servir, tudo era dizel-as
em tom que não offendesse. E a prova é que, repetindo-as novamente,
saíram-me quasi supplices. Bastava não carregar tanto, nem adoçar
muito, um meio termo. «E Capitú tem razão, pensei, a casa é minha, elle
é um simples aggregado... Geitoso é, póde muito bem trabalhar por mim,
e desfazer o plano de mamãe.»




XX

Mil padre-nossos e mil ave-marias.

Levantei os olhos ao ceu, que começava a embruscar-se, mas não foi para
vel-o coberto ou descoberto. Era ao outro ceu que eu erguia a minha
alma; era ao meu refugio, ao meu amigo. E então disse de mim para mim:

--Prometto rezar mil padre-nossos e mil ave-marias, se José Dias
arranjar que eu não vá para o seminario.

A somma era enorme. A razão é que eu andava carregado de promessas
não cumpridas. A ultima foi de duzentos padre-nossos e duzentas
ave-marias, se não chovesse em certa tarde de passeio a Santa Theresa.
Não choveu, mas eu não rezei as orações. Desde pequenino acostumara-me
a pedir ao ceu os seus favores, mediante orações que diria, se elles
viessem. Disse as primeiras, as outras foram adiadas, e á medida que
se amontoavam iam sendo esquecidas. Assim cheguei aos numeros vinte,
trinta, cincoenta. Entrei nas centenas e agora no milhar. Era um modo
de peitar a vontade divina pela quantia das orações; além disso, cada
promessa nova era feita e jurada no sentido de pagar a divida antiga.
Mas vão lá matar a preguiça de uma alma que a trazia do berço e não a
sentia attenuada pela vida! O ceu fazia-me o favor, eu adiava a paga.
Afinal perdi-me nas contas.

--Mil, mil, repeti commigo.

Realmente, a materia do beneficio era agora immensa, não menos que a
salvação ou o naufragio da minha existencia inteira. Mil, mil, mil.
Era preciso uma somma que pagasse os atrazados todos. Deus podia
muito bem, irritado com os esquecimentos, negar-se a ouvir-me sem
muito dinheiro.... Homem grave, é possivel que estas agitações de
menino te enfadem, se é que não as achas ridiculas. Sublimes não eram.
Cogitei muito no modo de resgatar a divida espiritual. Não achava
outra especie em que, mediante a intenção, tudo se cumprisse, fechando
a escripturação da minha consciencia moral sem _deficit._ Mandar
dizer cem missas, ou subir do joelhos a ladeira da Gloria para ouvir
uma, ir á Terra-Santa, tudo o que as velhas escravas me contavam de
promessas celebres, tudo me acudia sem se fixar de vez no espirito.
Era muito duro subir uma ladeira de joelhos; devia feril-os por força.
A Terra-Santa ficava muito longe. As missas eram numerosas, podiam
empenhar-mo outra vez a alma....




XXI

Prima Justina.

Na varanda achei prima Justina, passeando de um lado para outro. Veiu
ao patamar e perguntou-me onde estivera.

--Estive aqui ao pé, conversando com D. Fortunata, e distraí-me. É
tarde, não é? Mamãe perguntou por mim?

--Perguntou, mas eu disse que você já tinha vindo.

A mentira espantou-me, não menos que a franqueza da noticia. Não é que
prima Justina fosse de biocos; dizia francamente a Pedro o mal que
pensava de Paulo, e a Paulo o que pensava de Pedro; mas, confessar que
mentira é que me pareceu novidade. Era quadragenaria, magra e pallida,
bocca fina e olhos curiosos. Vivia comnosco por favor de minha mãe, e
tambem por interesse; minha mãe queria ter uma senhora intima ao pé de
si, e antes parenta que extranha.

Passeámos alguns minutos na varanda, alumiada por um lampião. Quiz
saber se eu não esquecera os projectos ecclesiasticos de minha mãe, e
dizendo-lhe eu que não, inquiriu-me sobre o gosto que eu tinha á vida
de padre. Respondi esquivo:

--Vida de padre é muito bonita.

--Sim, é bonita; mas o que pergunto é se você gostaria de ser padre,
explicou rindo.

--Eu gósto do que mamãe quizer.

--Prima Gloria deseja muito que você se ordene, mas ainda que não
desejasse, ha cá em casa quem lhe metta isso na cabeça.

--Quem é?

--Ora, quem! Quem é que hade ser? Primo Cosme não é, que não se importa
com isso; eu tambem não.

--José Dias? conclui.

--Naturalmente.

Enruguei a testa interrogativamente, como se não soubesse nada. Prima
Justina completou a noticia dizendo que ainda naquella tarde José Dias
lembrára a minha mãe a promessa antiga.

--Prima Gloria póde ser que, em passando os dias, vá esquecendo a
promessa; mas como ha de esquecer se uma pessoa estiver sempre, nos
ouvidos, zás que darás, falando do seminario? E os discursos que elle
faz, os elogios da egreja, e que a vida de padre é isto e aquillo, tudo
com aquellas palavras que só elle conhece, e aquella affectação...
Note que é só para fazer mal, porque elle é tão religioso, como este
lampião. Pois é verdade, ainda hoje. Você não se dê por achado... Hoje
de tarde falou como você não imagina.

--Mas falou á toa? perguntei, a ver se ella contava a denuncia do meu
namoro com a visinha.

Não contou; fez apenas um gesto como indicando que havia outra cousa
que não podia dizer. Novamente me recommendou que não me désse por
achado, e recapitulou todo o mal que pensava de José Dias, e não era
pouco, um intrigante, um bajulador, um especulador, e, apezar da casca
de polidez, um grosseirão. Eu, passados alguns instantes, disse:

--Prima Justina, a senhora era capaz de uma cousa?

--De quê?

--Era capaz de... Supponha que eu não gostasse de ser padre... a
senhora podia pedir a mamãe...

--Isso não, atalhou promptamente; prima Gloria tem este negocio firme
na cabeça, e não ha nada no mundo que a faça mudar de resolução; só
o tempo. Você ainda era pequenino, já ella contava isto a todas as
pessoas da nossa amizade, ou só conhecidas. Lá avivar-lhe a memoria,
não, que eu não trabalho para a desgraça dos outros; mas tambem,
pedir outra cousa, não peço. Se ella me consultasse, bem; se ella me
dissesse: «Prima Justina, você que acha?» a minha resposta era: «Prima
Gloria, eu penso que, se elle gosta de ser padre, póde ir; mas, se não
gosta, o melhor é ficar.» E o que eu diria e direi se ella me consultar
algum dia. Agora, ir falar-lhe sem ser chamada, não faço.




XXII

Sensações alheias.

Não alcancei mais nada, e para o fim arrependi-me do pedido: devia
ter seguido o conselho de Capitú. Então, como eu quizesse ir para
dentro, prima Justina reteve-me alguns minutos, falando do calor e da
proxima festa da Conceição, dos meus velhos oratorios, e finalmente de
Capitú. Não disse mal della; ao contrario insinuou-me que podia vir a
ser uma moça bonita. Eu, que já a achava lindissima, bradaria que era
a mais bella creatura do mundo, se o receio me não fizesse discreto.
Entretanto, como prima Justina se mettesse a elogiar-lhe os modos, a
gravidade, os costumes, o trabalhar para os seus, o amor que tinha a
minha mãe, tudo isto me accendeu a ponto de elogial-a tambem. Quando
não era com palavras, era com o gesto de approvação que dava a cada
uma das assersões da outra, e certamente com a felicidade que devia
illuminar-me a cara. Não adverti que assim confirmava a denuncia de
José Dias, ouvida por ella, á tarde, na sala de visitas, se é que
tambem ella não desconfiava já. Só pensei nisso na cama. Só então senti
que os olhos de prima Justina, quando eu falava, pareciam apalpar-me,
ouvir-me, cheirar-me, gostar-me, fazer o officio de todos os sentidos.
Ciumes não podiam ser; entre um pirralho da minha edade e uma viuva
quarentona não havia logar para ciumes. É certo que, após algum
tempo, modificou os elogios a Capitú, e até lhe fez algumas criticas,
disse-me que era um pouco trefega e olhava por baixo; mas ainda assim,
não creio que fossem ciumes. Creio antes... sim... sim, creio isto.
Creio que prima Justina achou no espectaculo das sensações alheias uma
resurreição vaga das proprias. Tambem se goza por influição dos labios
que narram.




XXIII

Prazo dado.

--Preciso falar-lhe amanhã, sem falta; escolha o logar e diga-me.

Creio que José Dias achou desusado este meu falar. O tom não me sairia
tão imperativo como eu receiava, mas as palavras o eram, e o não
interrogar, não pedir, não hesitar, como era proprio da creança e do
meu estylo habitual, certamente lhe deu ideia de uma pessoa nova e de
uma nova situação. Foi no corredor, quando iamos para o chá; José Dias
vinha andando cheio da leitura de Walter Scott que fizera a minha mãe
e a prima Justina. Lia cantado e compassado. Os castellos e os parques
saíam maiores da bocca delle, os lagos tinham mais agua e a «abobada
celeste» contava alguns milhares mais de estrellas centelhantes. Nos
dialogos, alternava o som das vozes, que eram levemente grossas ou
finas, conforme o sexo dos interlocutores, e reproduziam com moderação
a ternura e a colera.

Ao despedir-se de mim, na varanda, disse-me elle:

--Amanhã, na rua. Tenho umas compras que fazer, você póde ir commigo,
pedirei a mamãe. É dia de licção?

--A licção foi hoje.

--Perfeitamente. Não lhe pergunto o que é; affirmo desde já que é
materia grave e pura.

--Sim, senhor.

--Até amanhã.

Fez-se tudo o melhor possivel. Houve só uma alteração: minha mãe achou
o dia quente e não consentiu que eu fosse a pé; entrámos no omnibus, á
porta de casa.

--Não importa, disse-me José Dias; podemos apear-nos á porta do Passeio
Publico.




XXIV

De mãe e de servo.

José Dias tratava-me com extremos de mãe e attenções de servo. A
primeira cousa que conseguiu logo que comecei a andar fora, foi
dispensar-me o pagem; fez-se pagem, ia commigo á rua. Cuidava dos meus
arranjos em casa, dos meus livros, dos meus sapatos, da minha hygiene e
da minha prosodia. Aos oito annos os meus pluraes careciam, alguma vez,
da desinencia exacta, elle a corrigia, meio serio para dar autoridade
á licção, meio risonho para obter o perdão da emenda. Ajudava assim
o mestre de primeiras lettras. Mais tarde, quando o padre Cabral me
ensinava latim, doutrina e historia sagrada, elle assistia ás licções,
fazia reflexões ecclesiasticas, e, no fim, perguntava ao padre: «Não
é verdade que o nosso joven amigo caminha depressa?» Chamava-me «um
prodigio»; dizia a minha mãe ter conhecido outr'ora meninos muito
intelligentes, mas que eu excedia a todos esses, sem contar que, para a
minha edade, possuia já certo numero de qualidades moraes solidas. Eu,
posto não avaliasse todo o valor deste outro elogio, gostava do elogio;
era um elogio.




XXV

No Passeio Publico.

Entrámos no Passeio Publico. Algumas caras velhas, outras doentes ou só
vadias espalhavam-se melancolicamente no caminho que vae da porta ao
terraço. Seguimos para o terraço. Andando, para me dar animo, falei do
jardim:

--Ha muito tempo que não venho aqui, talvez um anno.

--Perdôe-me, atalhou elle, não ha tres mezes que esteve aqui com o
nosso visinho Padua; não se lembra?

--É verdade, mas foi tão de passagem...

--Elle pediu a sua mãe que o deixasse trazer comsigo, e ella, que é boa
como a mãe de Deus, consentiu; mas ouça-me, já que falamos nisto, não é
bonito que você ande com o Padua na rua.

--Mas eu andei algumas vezes...

--Quando era mais joven; em creança, era natural, elle podia passar por
creado. Mas você está ficando moco, e elle vae tomando confiança. D.
Gloria, afinal, não pode gostar disto. A gente Padua não é de todo má.
Capitú, apesar daquelles olhos que o diabo lhe deu... Você já reparou
nos olhos della? São assim de cigana obliqua e dissimulada. Pois,
apesar delles, poderia passar, se não fosse a vaidade e a adulação.
Oh! a adulação! D. Fortunata merece estima, e elle não nego que seja
honesto, tem um bom emprego, possue a casa em que móra, mas honestidade
e estima não bastam, e as outras qualidades perdem muito de valor com
as más companhias em que elle anda. Padua tem uma tendencia para gente
réles. Em lhe cheirando a homem chulo é com elle. Não digo isto por
odio, nem por que elle fale mal de mim e se ria, como se riu, ha dias,
dos meus sapatos acalcanhados...

--Perdão, interrompi suspendendo o passo, nunca ouvi que falasse mal
do senhor; pelo contrario, um dia, não ha muito tempo, disse elle a um
sujeito, em minha presença, que o senhor era «um homem de capacidade e
sabia falar corno um deputado nas camaras.»

José Dias sorriu deliciosamente, mas fez um esforço grande e fechou
outra vez o rosto; depois replicou:

--Não lhe agradeço nada. Outros, de melhor sangue, me tem feito o favor
de juizos altos. E nada disso impede que elle seja o que lhe digo.

Tinhamos outra vez andado, subimos ao terraço, e olhámos para o mar.

--Vejo que o senhor não quer senão o meu beneficio, disse eu depois de
alguns instantes.

--Pois que outra cousa, Bentinho?

--Neste caso, peço-lhe um favor.

--Um favor? Mande, ordene, que é?

--Mamãe...

Durante algum tempo não pude dizer o resto, que era pouco, e vinha de
cór. José Dias tornou a perguntar o que era, sacudia-me com brandura,
levantava-me o queixo e espetava os olhos em mim, ancioso tambem, como
a prima Justina na vespera.

--Mamãe quê? Que é que tem mamãe?

--Mamãe quer que eu seja padre, mas eu não posso ser padre, disse
finalmente.

José Dias endireitou-se pasmado.

--Não posso, continuei eu, não menos pasmado que elle, não tenho geito,
não gósto da vida de padre. Estou por tudo o que ella quizer; mamãe
sabe que eu faço tudo o que ella manda; estou prompto a ser o que fôr
do seu agrado, até cocheiro de omnibus. Padre, não; não posso ser
padre. A carreira é bonita, mas não é para mim.

Todo esse discurso não me saiu assim, de vez, enfiado naturalmente,
peremptorio, como póde parecer do texto, mas aos pedaços, mastigado,
em voz um pouco surda e timida. Não obstante, José Dias ouvira-o
espantado. Não contava certamente com a resistencia, por mais acanhada
que fosse; mas o que ainda mais o assombrou foi esta conclusão:

--Conto com o senhor para salvar-me.

Os olhos do aggregado escancararam-se, as sobrancelhas arquearam-se,
e o prazer que eu contava dar-lhe com a escolha da protecção não se
mostrou em nenhum dos musculos. Toda a cara delle era pouca para a
estupefacção. Realmente, a materia do discurso revelára em mim uma alma
nova; eu proprio não me conhecia. Mas a palavra final é que trouxe um
vigor unico. José Dias ficou aturdido. Quando os olhos tornaram ás
dimensões ordinarias:

--Mas que posso eu fazer? perguntou.

--Póde muito. O senhor sabe que, em nossa casa, todos o apreciam. Mamãe
pede muita vez os seus conselhos, não é? Tio Cosme diz que o senhor é
pessoa de talento...

--São bondades, retorquiu lisonjeado. São favores de pessoas dignas,
que merecem tudo... Ahi está! nunca ninguem me ha de ouvir dizer nada
de pessoas taes; porque? porque são illustres e virtuosas. Sua mãe
é uma santa, seu tio é um cavalheiro perfeitissimo. Tenho conhecido
familias distinctas; nenhuma poderá vencer a sua em nobreza de
sentimentos. O talento que seu tio acha em mim confesso que o tenho,
mas é só um,--é o talento de saber o que é bom e digno de admiração e
de apreço.

--Ha de ter tambem o de proteger os amigos, como eu.

--Em que lhe posso valer, anjo do ceu? Não hei de dissuadir sua mãe
de um projecto que é, além de promessa, a ambição e o sonho de longos
annos. Quando pudesse, é tarde. Ainda hontem fez-me o favor de dizer:
«José Dias, preciso metter Bentinho no seminario.»

Timidez não é tão ruim moeda, como parece. Se eu fosse destemido, é
provavel que, com a indignação que experimentei, rompesse a chamar-lhe
mentiroso, mas então seria preciso confessar-lhe que estivera á escuta,
atraz da porta, e uma acção valia outra. Contentei-me de responder que
não era tarde.

--Não é tarde, ainda é tempo, se o senhor quizer.

--Se eu quizer? Mas que outra cousa quero eu, senão servil-o? Que
desejo, senão que seja feliz, como merece?

--Pois ainda é tempo. Olhe, não é por vadiação. Estou prompto para
tudo; se ella quizer que eu estude leis, vou para S. Paulo...




XXVI

As leis são bellas.

Pela cara de José Dias passou algo parecido com o reflexo de uma
ideia,--uma ideia que o alegrou extraordinariamente. Calou-se alguns
instantes; eu tinha os olhos nelle, elle voltara os seus para o lado da
barra. Como insistisse:

--É tarde, disse elle; mas, para lhe provar que não ha falta de
vontade, irei falar a sua mãe. Não prometto vencer, mas lutar;
trabalharei com alma. Devéras, não quer ser padre? As leis são bellas,
meu querido... Póde ir a S. Paulo, a Pernambuco, ou ainda mais longe.
Ha boas universidades por esse mundo fóra. Vá para as leis, se tal é
a sua vocação. Vou falar a D. Gloria, mas não conte só commigo; fale
tambem a seu tio.

--Hei de falar.

--Pegue-se tambem com Deus,--com Deus e a Virgem Santissima, concluiu
apontando para o ceu.

O ceu estava meio enfarruscado. No ar, perto da praia, grandes passaros
negros faziam giros, avoaçando ou pairando, e desciam a roçar os pés,
na agua, e tornavam a erguer-se para descer novamente. Mas nem as
sombras do ceu, nem as dansas fantasticas dos passaros me desviavam
o espirito do meu interlocutor. Depois de lhe responder que sim,
emendei-me:

--Deus fará o que o senhor quizer.

--Não blaspheme. Deus é dono de tudo; elle é, só por si, a terra e
o ceu, o passado, o presente e o futuro. Peça-lhe a sua felicidade,
que eu não faço outra cousa... Uma vez que você não póde ser padre, e
prefere as leis... As leis são bellas, sem desfazer na theologia, que
é melhor que tudo, como a vida ecclesiastica é a mais santa... Porque
não ha de ir estudar leis fóra daqui? Melhor é ir logo para alguma
universidade, e ao mesmo tempo que estuda, viaja. Podemos ir juntos;
veremos as terras estranjeiras, ouviremos inglez, francez, italiano,
hespanhol, russo e até sueco. D. Gloria provavelmente não poderá
acompanhal-o; ainda que possa e vá, não quererá guiar os negocios,
papeis, matriculas, e cuidar de hospedarias, e andar com você de um
lado para outro... Oh! as leis são bellissimas!

--Está dito, pede a mamãe que me não metia no seminario?

--Pedir, peço, mas pedir não é alcançar. Anjo do meu coração, se
vontade de servir é poder de mandar, estamos aqui, estamos a bordo.
Ali! você não imagina o que é a Europa; oh! a Europa...

Levantou a perna e fez uma pirueta. Uma das suas ambições era tornar á
Europa, falava della muitos vezes, sem acabar de tentar minha mãe nem
tio Cosme, por mais que louvasse os ares e as bellezas... Não contava
com esta possibilidade de ir commigo, e lá ficar durante a eternidade
dos meus estudos.

--Estamos a bordo, Bentinho, estamos a bordo!




XXVII

Ao portão.

Ao portão do Passeio, um mendigo estendeu-nos a mão. José Dias passou
adiante, mas eu pensei em Capitú e no seminario, tirei dous vintens do
bolso e dei-os ao mendigo. Este beijou a moeda; eu pedi-lhe que rogasse
a Deus por mim, afim de que eu pudesse satisfazer todos os meus desejos.

--Sim, meu devoto!

--Chamo-me Bento, accrescentei para esclarecel-o.




XXVIII

Na rua.

José Dias ia tão contente que trocou o homem dos momentos graves,
como era á rua, pelo homem dobradiço e inquieto. Mexia-se todo,
falava de tudo, fazia-me parar a cada passo deante de um mostrador
ou de um cartaz de theatro. Contava-me o enredo de algumas peças,
recitava monologos em verso. Fez os recados todos, pagou contas,
recebeu alugueis de casa; para si comprou um vigesimo de loteria.
Afinal, o homem tezo rendeu o flexivel, e passou a falar pausado, com
superlativos. Não vi que a mudança era natural; temi que houvesse
mudado a resolução assentada, e entrei a tratal-o com palavras e gestos
carinhosos, até entrarmos no omnibus.




XXIX

O imperador.

Em caminho, encontrámos o imperador, que vinha da Escola de Medicina.
O omnibus em que iamos parou, como todos os vehiculos; os passageiros
desceram á rua e tiraram o chapeu, até que o coche imperial passasse.
Quanto tornei ao meu logar, trazia uma ideia fantastica, a ideia de ir
ter com o imperador, contar-lhe tudo e pedir-lhe a intervenção. Não
confiaria. esta ideia a Capitú. «Sua Majestade pedindo, mamãe cede,»
pensei commigo.

Vi então o imperador escutando-me, reflectindo e acabando por dizer que
sim, que iria falar a minha mãe; eu beijava-lhe a mão, com lagrimas. E
logo me achei cm casa, á espera, até que ouvi os batedores e o piquete
de cavallaria; é o imperador! é o imperador! toda a gente chegava ás
janellas para vel-o passar, mas não passava, o coche parava á nossa
porta, o imperador apeava-se e entrava. Grande alvoroço na visinhança:
«O imperador entrou em casa de D. Gloria! Que será? Que não será?
«A nossa familia saía a recebel-o; minha mãe era a primeira que lhe
beijava a mão. Então o imperador, todo risonho, sem entrar na sala ou
entrando,--não me lembra bem, os sonhos são muita vez confusos,--pedia
a minha mãe que me não fizesse padre,--e ella, lisongeada e obediente,
promettia que não.

--A medicina,--porque lhe não manda ensinar medicina?

Uma vez que é do agrado de Vossa Majestade...

--Mande ensinar-lhe medicina; é uma bonita carreira, e nós temos aqui
bons professores. Nunca foi á nossa Escola? É uma bella Escola. Já
temos medicos de primeira ordem, que pódem hombrear com os melhores de
outras terras. A medicina é uma grande sciencia; basta só isto de dar
a saude aos outros, conhecer as molestias, combatel-as, vencel-as... A
senhora mesma ha de ter visto milagres. Seu marido morreu, mas a doença
era fatal, e elle não tinha cuidado em si... É uma bonita carreira;
mande-o para a nossa Escola. Faça isso por mim, sim? Você quer,
Bentinho?

--Mamãe querendo.

--Quero, meu filho. Sua Majestade manda.

Então o imperador dava outra vez a mão a beijar, e saía, acompanhado de
todos nós, a rua cheia de gente, as janellas atopetadas, um silencio de
assombro; o imperador entrava no coche, inclinava-se e fazia um gesto
de adeus, dizendo ainda: «A medicina, a nossa Escola.» E o coche partia
entre invejas e agradecimentos.

Tudo isso vi e ouvi. Não, a imaginação de Ariosto não é mais fertil
que a das creanças e dos namorados, nem a visão do impossivel precisa
mais que de um recanto de omnibus. Consolei-me por instantes, digamos
minutos, até destruir-se o plano e voltar-me para as caras sem sonhos
dos meus companheiros.




XXX

O Santissimo.

Terás entendido que aquella lembrança do imperador ácerca da medicina
não era mais que a suggestão da minha pouca vontade de sair do Rio de
Janeiro. Os sonhos do accordado são como os outros sonhos, tecem-se
pelo desenho das nossas inclinações e das nossas recordações. Vá que
fosse para S. Paulo, mas a Europa... Era muito longe, muito mar e muito
tempo. Viva a medicina! Iria contar estas esperanças a Capitú.

--Parece que vae sair o Santíssimo, disse alguem no omnibus. Ouço um
sino; é, creio que é em Santo Antonio dos Pobres. Pare, Sr. recebedor!

O recebedor das passagens puxou a correia que ia ter ao braço do
cocheiro, o omnibus parou, e o homem desceu. José Dias deu duas voltas
rapidas á cabeça, pegou-me no braço e fez-me descer comsigo. Iriamos
tambem acompanhar o Santissimo. Effectivamente, o sino chamava os
fieis áquelle serviço da ultima hora. Já havia algumas pessoas na
sacristia. Era a primeira vez que me achava em momento tão grave;
obedeci, a principio constrangido, mas logo depois satisfeito, menos
pela caridade do serviço que por me dar um officio de homem. Quando o
sacristão começou a distribuir as opas, entrou um sujeito esbaforido;
era o meu visinho Padua, que tambem ia acompanhar o Santissimo. Deu
comnosco, veiu comprimentar-nos. José Dias fez um gesto de aborrecido,
e apenas lhe respondeu com uma palavra secca, olhando para o padre,
que lavava as mãos. Depois, como Padua falasse ao sacristão, baixinho,
approximou-se delles; eu fiz a mesma cousa. Padua solicitava do
sacristão uma das varas do pallio. José Dias pediu uma para si.

--Ha só uma disponível, disse o sacristão.

--Pois essa, disse José Dias.

--Mas eu tinha pedido primeiro, aventurou Padua.

--Pediu primeiro, mas entrou tarde, retorquiu José Dias; eu já cá
estava. Leve uma tocha.

Padua, apesar do medo que tinha ao outro, teimava em querer a vara,
tudo isto em voz baixa e surda. O sacristão achou meio de conciliar a
rivalidade, tomando a si obter de um dos outros seguradores do pallio
que cedesse a vara ao Padua, conhecido na parochia, como José Dias.
Assim fez; mas José Dias transtornou ainda esta combinação. Não, uma
vez que tinhamos outra vara disponivel, pedia-a para mim, «joven
seminarista», a quem esta distincção cabia mais direitamente. Padua
ficou pallido, como as tochas. Era pôr á prova o coração de um pae. O
sacristão, que me conhecia de me ver alli com minha mãe, aos domingos,
perguntou de curioso se eu era devéras seminarista.

--Ainda não, mas vae sel-o, respondeu José Dias piscando o olho
esquerdo para mim, que, apesar do aviso, fiquei zangado.

--Bem, cedo ao nosso Bentinho, suspirou o pae de Capitú.

Pela minha parte, quiz ceder-lhe a vara; lembrou-me que elle costumava
acompanhar o Santissimo Sacramento aos moribundos, levando uma tocha,
mas que a ultima vez conseguira uma vara do pallio. A distincção
especial do pallio vinha de cobrir o vigario e o sacramento; para tocha
qualquer pessoa servia. Foi elle mesmo que me contou e explicou isto,
cheio de uma gloria pia e risonha. Assim fica entendido o alvoroço
com que entrára na egreja; era a segunda vez do pallio, tanto que
cuidou logo de ir pedil-o. E nada! E tornava á tocha commum, outra
vez a interinidade interrompida; o administrador regressava ao antigo
cargo... Quiz ceder-lhe a vara; o aggregado tolheu-me esse acto de
generosidade, e pediu ao sacristão que nos puzesse, a elle e a mim, com
as duas varas da frente, rompendo a marcha do pallio.

Opas enfiadas, tochas distribuidas e accesas, padre e ciborio promptos,
o sacristão de hyssope e campainha nos mãos, saiu o prestito á
rua. Quando me vi com uma das varas, passando pelos fieis, que se
ajoelhavam, fiquei commovido. Padua roía a tocha amargamente. É uma
metaphora, não acho outra fórma mais viva de dizer a dôr e a humilhação
do meu visinho. De resto, não pude miral-o por muito tempo, nem ao
aggregado, que, parallelamente a mim, erguia a cabeça com o ar de ser
elle proprio o Deus dos exercitos. Com pouco, senti-me cançado; os
braços caíam-me, felizmente a casa era perto, na rua do Senado.

A enferma era uma senhora viuva, tisica, tinha uma filha de quinze ou
dezeseis annos, que estava chorando á porta do quarto. A moça não era
formosa, talvez nem tivesse graça; os cabellos caíam despenteados, e
as lagrimas faziam-lhe encarquilhar os olhos. Não obstante, o total
falava e captivava o coração. O vigário confessou a doente, deu-lhe a
communhão e os santos oleos. O pranto da moça redobrou tanto que senti
os meus olhos molhados e fugi. Vim para porto de uma jannela. Pobre
creatura! A dor era communicativa em si mesma; complicada da lembrança
de minha mãe, doeu-me mais, e, quando emfim pensei em Capitú, senti um
impeto de soluçar tambem, enfiei pelo corredor, e ouvi alguem dizer-me:

--Não chore assim!

A imagem de Capitú ia commigo, e a minha imaginação, assim como lhe
attribuira lagrimas, ha pouco, assim lhe encheu a bocca de riso agora;
vi-a escrever no muro, falar-me, andar á volta, com os braços no ar;
ouvi distinctamente o meu nome, de uma doçura que me embriagou, e a
voz era della. As tochas accesas, tão lugubres na occasião, tinham-me
ares de um lustre nupcial... Que era lustre nupcial? Não sei; era
alguma cousa contraria á morte, e não vejo outra mais que bodas. Esta
nova sensação me dominou tanto que José Dias veiu a mim, e me disse ao
ouvido, em voz baixa:

--Não ria assim!

Fiquei serio depressa. Era o momento da saida. Peguei da minha vara; e,
como já conhecia a distancia, e agora voltavamos para a egreja, o que
fazia a distancia menor,--o peso da vara era mui pequeno. Demais, o sol
cá fora, a animação da rua, os rapazes da minha edade que me fitavam
cheios de inveja, as devotas que chegavam ás janellas ou entravam nos
corredores e se ajoelhavam á nossa passagem, tudo me enchia a alma de
lepidez nova.

Padua, ao contrario, ia mais humilhado. Apesar de substituido por mim,
não acabava de se consolar da tocha, da miseravel tocha. E comtudo
havia outros que tambem traziam tocha, e apenas mostravam a compostura
do acto; não iam garridos, mas tambem não iam tristes. Via-se que
caminhavam com honra.




XXXI

As curiosidades de Capitú.

Capitú preferia tudo ao seminario. Em vez de ficar abatida com a
ameaça da larga separação, se vingasse a ideia da Europa, mostrou-se
satisfeita. E quando eu lhe contei o meu sonho imperial:

--Não, Bentinho, deixemos o imperador socegado, replicou; fiquemos por
ora com a promessa de José Dias. Quando é que elle disse que falaria a
sua mãe?

--Não marcou dia; prometteu que ia ver, que falaria logo que pudesse, e
que me pegasse com Deus.

Capitú quiz que lhe repetisse as respostas todas do aggregado, as
alterações do gesto e até a pirueta, que apenas lhe contára. Pedia o
som das palavras. Era minuciosa e attenta; a narração e o dialogo, tudo
parecia remoer comsigo. Tambem se póde dizer que conferia, rotulava e
pregava na memoria a minha exposição. Esta imagem é por ventura melhor
que a outra, mas a optima dellas é nenhuma. Capitú era Capitú, isto é,
uma creatura mui particular, mais mulher do que eu era homem. Se ainda
o não disse, ahi fica. Se disse, fica tambem. Ha conceitos que se devem
incutir na alma do leitor, á força de repetição.

Era tambem mais curiosa. As curiosidades de Capitú dão para um
capitulo. Eram de varia especie, explicaveis e inexplicaveis, assim
uteis como inuteis, umas graves, outras frivolas; gostava de saber
tudo. No collegio onde, desde os sete annos, apprendera a ler, escrever
e contar, francez, doutrina e obras de agulha, não apprendeu, por
exemplo, a fazer renda; por isso mesmo, quiz que prima Justtina lh'o
ensinasse. Se não estudou latim com o padre Cabral foi porque o padre,
depois de lh'o propôr gracejando, acabou dizendo que latim não era
lingua de meninas. Capitú confessou-me um dia que esta razão accendeu
nella o desejo de o saber. Em compensação, quiz apprender inglez com
um velho professor amigo do pae e parceiro deste ao sólo, mas não foi
adeante. Tio Cosme ensinou-lhe gamão.

--Anda apanhar um capotinho, Capitú, dizia-lhe elle.

Capitú obedecia e jogava com facilidade, com attenção, não sei se diga
com amor. Um dia fui achal-a desenhando a lapís um retraio; dava os
ultimos rasgos, e pediu-me que esperasse para ver se estava parecido.
Era o de meu pae, copiado da tela que minha mãe tinha na sala e que
ainda agora está commigo. Perfeição não era; ao contrario, os olhos
sairam esbogalhados, e os cabellos eram pequenos circulos uns sobre
outros. Mas, não tendo ella rudimento algum de arte, e havendo feito
aquillo de memoria em poucos minutos, achei que era obra de muito
merecimento; descontai-me a edade e a sympathia. Ainda assim, estou
que apprenderia facilmente pintura, como apprendeu musica mais tarde.
Já então namorava o piano da nossa casa, velho traste inutil, apenas
de estimação. Lia os nossos romances, folheava os nossos livros de
gravuras, querendo saber das ruinas, das pessoas, das campanhas, o
nome, a historia, o lograr. José Dias dava-lhe essas noticias com certo
orgulho de erudito. A erudição deste não avultava muito mais que a sua
homoepathia de Cantagallo.

Um dia, Capitú quiz saber o que eram as figuras da sala de visitas. O
aggregado disse-lho summariamente, demorando-se um pouco mais em Cesar,
com exclamações e latins:

--Cesar! Julio Cesar! Grande homem! _Tu quoque, Brute?_

Capitú não achava bonito o perfil de Cesar, mas as acções citadas por
José Dias davam-lhe gestos de admiração. Ficou muito tempo com a cara
virada para elle. Um homem que podia tudo! que fazia tudo! Um homem que
dava a uma senhora uma perola do valor de seis milhões de sestercios!

--E quanto valia cada sestercio?

José Dias, não tendo presente o valor do sestercio, respondeu
enthusiasmado:

--É o maior homem da historia!

A perola de Cesar accendia os olhos de Capitú. Foi nessa occasião
que ella perguntou a minha mãe porque é que já não usava as joias do
retrato; preferia-se ao que estava na sala, com o de meu pae; tinha um
grande collar, um diadema e brincos.

--São joias viuvas, como eu, Capitú.

--Quando é que botou estas?

--Foi pelas festas da Coroação.

--Oh! conte-me as festas da Coroação!

Sabia já o que os paes lhe haviam dito, mas naturalmente tinha para
si que elles pouco mais conheceriam do que o que se passou nas ruas.
Queria a noticia das tribunas da Capella Imperial e dos salões dos
bailes. Nascera muito depois daquellas festas celebres. Ouvindo falar
varias vezes da Maioridade, teimou um dia em saber o que fora este
acontecimento; disseram-lh'o, e achou que o imperador fizera muito
bem em querer subir ao throno aos quinze annos. Tudo era materia ás
curiosidades de Capitú, mobilias antigas, alfaias velhas, costumes,
noticias de Itaguahy, a infancia e a mocidade de minha mãe, um dito
daqui, uma lembrança dalli, um adagio d'acolá...




XXXII

Olhos de ressaca.

Tudo era materia ás curiosidades de Capitú. Caso houve, porém, no qual
não sei se apprendeu ou ensinou, ou se fez ambas as cousas, como eu. É
o que contarei no outro capitulo. N'este direi sómente que, passados
alguns dias do ajuste com o aggregado, fui ver a minha amiga; eram dez
horas da manhã. D. Fortunata, que estava no quintal, nem esperou que eu
lhe perguntasse pela filha.

--Está na sala penteando o cabello, disse-me; vá devagarzinho para lhe
pregar um susto.

Fui devagar, mas ou o pé ou o espelho traiu-me. Este póde ser que não
fosse; era um espelhinho de pataca (perdoai a barateza), comprado a
um mascate italiano, moldura tosca, argolinha de latão, pendente da
parede, entre as duas janellas. Se não foi elle, foi o pé. Um ou outro,
a verdade é que, apenas entrei na sala, pente, cabellos, toda ella
voou pelos ares, e só lhe ouvi esta pergunta:

--Ha alguma cousa?

--Não ha nada, respondi; vim ver você antes que o padre Cabral chegue
para a licção. Como passou a noite?

--Eu bem. José Dias ainda não falou?

--Parece que não.

--Mas então quando fala?

--Disse-me que hoje ou amanhã pretende tocar no assumpto; não vae
logo de pancada, falará assim por alto e por longe, um toque. Depois,
entrará em materia. Quer primeiro ver se mamãe tem a resolução feita...

--Que tem, tem, interrompeu Capitú. E se não fosse preciso alguem para
vencer já, e de todo, não se lhe falaria. Eu já nem sei se José Dias
poderá influir tanto; acho que fará tudo, se sentir que você realmente
não quer ser padre, mas poderá alcançar...? Elle é attendido; se,
porém... É um inferno isto! Você teime com elle, Bentinho.

--Teimo; hoje mesmo elle ha de falar.

--Você jura?

--Juro! Deixe ver os olhos, Capitú.

Tinha-me lembrado a definição que José dera delles, «olhos de cigana
obliqua e dissimulada.» Eu não sabia o que era obliqua, mas dissimulada
sabia, e queria ver se se podiam chamar assim. Capitú deixou-se fitar e
examinar. Só me perguntava o que era, se nunca os vira; eu nada achei
extraordinário; a côr e a doçura eram minhas lhe deu outra ideia
do meu intento; imaginou que era um pretexto para miral-os mais de
perto, com os meus olhos longos, constantes, enfiados nelles, e á isto
attribuo que entrassem a ficar crescidos, crescidos e sombrios, com tal
expressão que...

Rhetorica dos namorados, dá-me uma comparação exacta e poetica para
dizer o que foram aquelles olhos de Capitú. Não me acode imagem capaz
de dizer, sem quebra da dignidade do estylo, o que elles foram e me
fizeram. Olhos de ressaca? Vá, de ressaca. É o que me dá ideia daquella
feição nova. Traziam não sei que fluido mysterioso e energico, uma
força que arrastava para dentro, como a vaga que se retira da praia,
nos dias de ressaca. Para não ser arrastado, agarrei-me ás outras
partes visinhas, ás orelhas, aos braços, aos cabellos espalhados pelos
hombros; mas tão depressa buscava as pupillas, a onda que saía dellas
vinha crescendo, cava e escura, ameaçando envolver-me, puxar-me e
tragar-me. Quantos minutos gastámos naquelle jogo? Só os relogios do
ceu terão marcado esse tempo infinito e breve. A eternidade tem as suas
pendulas nem por não acabar nunca deixa de querer saber a duração das
felicidades e dos supplicios. Ha de dobrar o gozo aos bemaventurados
do ceu conhecer a somma dos tormentos que já terão padecido no inferno
os seus inimigos; assim tambem a quantidade das delicias que terão
gozado no ceu os seus desaffectos augmentará as dores aos condemnados
do inferno. Este outro supplicio escapou ao divino Dante; mas eu não
estou aqui para emendar poetas. Estou para contar que, ao cabo de um
tempo não marcado, agarrei-me definitivamente aos cabellos de Capitú,
mas então com as mãos, e disse-lhe,--para dizer alguma cousa,--que era
capaz de os pentear, se quizesse.

--Você?

--Eu mesmo.

--Vae embaraçar-me o cabello todo, isso, sim.

--Se embaraçar, você desembaraça depois.

--Vamos ver.




XXXIII

O penteado.

Capitú deu-me as costas, voltando-se para o espelhinho. Peguei-lhe dos
cabellos, colhi-os todos e entrei a alisal-os com o pente, desde a
testa até ás ultimas pontas, que lhe desciam á cintura. Em pé não dava
geito: não esquecestes que ella era um nadinha mais alta que eu, mas
ainda que fosse da mesma altura. Pedi-lhe que se sentasse.

--Senta aqui, é melhor.

Sentou-se. «Vamos ver o grande cabelleireiro», disse-me rindo.
Continuei a alisar os cabellos, com muito cuidado, e dividi-os em duas
porções eguaes, para compor as duas trancas. Não as fiz logo, nem assim
depressa, como podem suppôr os cabelleireiros de officio, mas devagar,
devagarinho, saboreando pelo tacto aquelles fios grossos, que eram
parte della. O trabalho era atrapálhado, ás vezes por desaso, outras
de proposito, para desfazer o feito e refazel-o. Os dedos roçavam na
nuca da pequena ou nas espaduas vestidas de chita, e a sensação era
um deleite. Mas, emfim, os cabellos iam acabando, por mais que eu os
quizesse interminaveis. Não pedi ao ceu que elles fossem tão longos
como os da Aurora, porque não conhecia ainda esta divindade que os
velhos poetas me apresentaram depois; mas, desejei penteal-os por
todos os seculos dos seculos, tecer duas tranças que pudessem envolver
o infinito por um numero innominavel de vezes. Se isto vos parecer
emphatico, desgraçado leitor, é que nunca penteastes uma pequena, nunca
puzestes aos mãos adolescentes na joven cabeça de uma nympha... Uma
nympha! Todo eu estou mythologico. Ainda ha pouco, falando dos seus
olhos de ressaca, cheguei a escrever Thetis; risquei Thetis, risquemos
nympha; digamos somente uma creatura amada, palavra que envolve todas
as potencias christãs e pagãs. Emfim, acabei as duas tranças. Onde
estava a fita para atar-lhes as pontas? Em cima da mesa, um triste
pedaço de fita enxovalhada. Juntei as pontas das tranças, uni-as por um
laço, retoquei a obra, alargando aqui, achatando alli, até que exclamei:

--Prompto!

--Estará bom?

--Veja no espelho.

Em vez de ir ao espelho, que pensaes que fez Capitú? Não vos esqueçaes
quo estava sentada, de costas para mim. Capitú derreou a cabeça, a tal
ponto que me foi preciso acudir com as mãos e amparal-a; o espaldar
da cadeira era baixo. Inclinei-me depois sobre ella, rosto a rosto,
mas trocados, os olhos de um na linha da bocca do outro. Pedi-lhe que
levantasse a cabeça, podia ficar tonta, machucar o pescoço. Cheguei a
dizer-lhe que estava feia; mas nem esta razão a moveu.

--Levanta, Capitú!

Não quiz, não levantou a cabeça, e ficámos assim a olhar um para o
outro, até que ella abrochou os labios, eu desci os meus, e...

Grande foi a sensação do beijo; Capitú ergueu-se, rapida, eu recuei
até á parede com uma especie de vertigem, sem fala, os olhos escuros.
Quando elles me clarearam, vi que Capitú tinha os seus no chão. Não
me atrevi a dizer nada; ainda que quizesse, faltava-me lingua. Preso,
atordoado, não achava gesto nem impeto que me descolasse da parede e me
atirasse a ella com mil palavras callidas e mimosas... Não mofes dos
meus quinze annos, leitor precoce. Com dezesete, Des Grieux (e mais era
Des Grieux) não pensava ainda na differença dos sexos.




XXXIV

Sou homem!

Ouvimos passos no corredor; era D. Fortunata. Capitú compoz-se
depressa, tão depressa que, quando a mãe apontou á porta, ella
abanava a cabeça e ria. Nenhum laivo amarello. nenhuma contracção de
acanhamento, um riso espontaneo e claro, que ella explicou por estas
palavras alegres:

--Mamãe, olhe como este senhor cabelleireiro me penteou; pediu-me para
acabar o penteado, e fez isto. Veja que tranças!

--Que tem? acudiu a mãe, transbordando de benevolencia. Está muito bem,
ninguem dirá que é de pessoa que não sabe pentear.

--O que, mamãe? Isto? redarguiu Capitú desfazendo as tranças. Ora,
mamãe!

E com um enfadamento gracioso e voluntario que ás vezes tinha, pegou
do pente e alisou os cabellos para renovar o penteado. D. Fortunata
chamou-lhe tonta, e disse-me que não fizesse caso, não era nada,
maluquices da filha. Olhava com ternura para mim e para ella. Depois,
parece-me que desconfiou. Vendo-me calado, enfiado, cosido á parede,
achou talvez que houvera entre nós algo mais que penteado, e sorriu por
dissimulação...

Como eu quizesse falar tambem para disfarçar o meu estado, chamei
algumas palavras cá de dentro, e ellas acudiram de prompto, mas de
atropello, e encheram-me a bocca sem poder sair nenhuma. O beijo de
Capitú fechava-me os labios. Uma exclamação, um simples artigo, por
mais que investissem com força, não logravam romper de dentro. E todas
as palavras recolheram-se ao coração, murmurando: «Eis aqui um que não
fará grande carreira no mundo, por menos que as emoções o dominem...»

Assim, apanhados pela mãe, éramos dous e contrarios, ella encobrindo
com a palavra o que eu publicava pelo silencio. D. Fortunata tirou-me
daquella hesitação, dizendo que minha mãe me mandára chamar para a
licção de latim; o padre Cabral estava á minha espera. Era uma saida;
despedi-me e enfiei pelo corredor. Andando, ouvi que a mãe censurava as
maneiras da filha, mas a filha não dizia nada.

Corri ao meu quarto, peguei dos livros, mas não passei a sala da
licção; sentei-me na cama, recordando o penteado e o resto. Tinha
estremeções, linha uns esquecimentos em que perdia a consciencia de
mim e das cousas que me rodeavam, para viver não sei onde nem como.
E tornava a mim, e via a cama, as paredes, os livros, o chão, ouvia
algum som de fóra, vago, proximo ou remoto, e logo perdia tudo para
sentir sómente os beiços de Capitú... Sentia-os estirados, embaixo dos
meus, egualmente esticados para os della, e unindo-se uns aos outros.
De repente, sem querer, sem pensar, saiu-me da boca esta palavra de
orgulho:

--Sou homem!

Suppuz que me tivessem ouvido, porque a palavra saiu em voz alta, e
corri á porta da alcova. Não havia ninguem fóra. Voltei para dentro,
e, baixinho, repeti que era homem. Ainda agora tenho o éco aos meus
ouvidos. O gosto que isto me deu foi enorme. Colombo não o teve maior,
descobrindo a America, e perdoai a banalidade em favor do cabimento;
com effeito, ha em cada adolescente um mundo encoberto, um almirante e
um sol de Outubro. Fiz outros achados mais tarde; nenhum me deslumbrou
tanto. A denuncia de José Dias alvoroçara-me, a licção do velho
coqueiro tambem, a vista dos nossos nomes abertos por ella no muro do
quintal deu-me grande abalo, como vistes; nada disso valeu a sensação
do beijo. Podiam ser mentira ou illusão. Sendo verdade, eram os ossos
da verdade, não eram a carne e o sangue della. As proprias mãos
tocadas, apertadas, como que fundidas, não podiam dizer tudo.

--Sou homem!

Quando repeti isto, pela terceira vez, pensei no seminario, mas como
se pensa em perigo que passou, um mal abortado, um pesadelo extincto;
todos os meus nervos me disseram que homens não são padres. O sangue
era da mesma opinião. Outra vez senti os beiços de Capitú. Talvez abuso
um pouco das reminiscencias osculares; mas a saudade é isto mesmo; é o
passar e repassar das memorias antigas. Ora, de todas as daquelle tempo
creio que a mais doce é esta, a mais nova, a mais comprehensiva, a que
inteiramente me revelou a mim mesmo. Outras tenho, vastas e numerosas,
doces tambem, de varia especie, muitas intellectuaes, egualmente
intensas. Grande homem que fosse, a recordação era menor que esta.




XXXV

O protonotario apostolico.

Enfim, peguei dos livros e corri á licção. Não corri precisamente; a
meio caminho parei, advertindo que devia ser muito tarde, e podiam
ler-me no semblante alguma cousa. Tive ideia de mentir, allegar uma
vertigem que me houvesse deitado ao chão; mas o susto que causaria
a minha mãe fez-me rejeital-a. Pensei em prometter algumas dezenas
de padre-nossos; tinha, porém, outra promessa em aberto e outro
favor pendente... Não, vamos ver; fui andando, ouvi vozes alegres,
conversavam cuidadosamente. Quando entrei na sala, ninguem ralhou
commigo.

O padre Cabral recebera na vespera um recado do internuncio; foi
ter com elle, e soube que, por decreto pontificio, acabava de ser
nomeado protonotario apostolico. Esta distincção do papa dera-lhe
grande contentamento e a todos os nossos. Tio Cosme e prima Justina
repetiam o titulo com admiração; era a primeira vez que elle soava aos
nossos ouvidos, acostumados a conegos, monsenhores, bispos, nuncios,
e internuncios; mas que era protonotario apostolico? O padre Cabral
explicou que não era propriamente o cargo da curia, mas as honras
delle. Tio Cosme viu exalçar-se no parceiro de voltarete, e repetia:

--Protonotario apostolico!

E voltando-se para mim:

--Prepara-te, Bentinho; tu pódes vir a ser protonotario apostolico.

Cabral ouvia com gosto a repetição do titulo. Estava em pé, dava alguns
passos, sorria ou tamborilava na tampa da boceta. O tamanho do titulo
como que lhe dobrava a magnificencia, posto que, para ligal-o ao nome,
era demasiado comprido; esta segunda reflexão foi tio Cosme que a fez.
Padre Cabral acudiu que não era preciso dizel-o todo, bastava que lhe
chamassem o protonotario Cabral. Subentendia-se apostolico.

--Protonotario Cabral.

--Sim, tem razão; protonotario Cabral.

--Mas, Sr. protonotario,--acudiu prima Justina para se ir acostumando
ao uso do titulo,--isto o obriga a ir a Roma?

--Não, D. Justina.

--Não, são só as honras, observou minha mãe.

--Agora, não impede,--disse Cabral, que continuava a reflectir,--não
impede que nos casos de maior formalidade, actos publicos, cartas
de cerimonia, etc., se empregue o titulo inteiro: protonotario
apostolico. No uso commum, basta protonotario.

--Justamente, assentiram todos.

José Dias, que entrou pouco depois de mim, applaudiu a distincção, e
recordou, a proposito, os primeiros actos politicos de Pio IX, grandes
esperanças da Italia; mas ninguem pegou do assumpto; o principal da
hora e do logar era o meu velho mestre de latim. Eu, voltando a mim
do receio, entendi que devia comprimental-o tambem, e este applauso
não lhe foi menos ao coração que os outros. Bateu-me na bochecha
paternalmente, e acabou dando-me férias. Era muita felicidade para uma
só hora. Um beijo e férias! Creio que o meu rosto disse isto mesmo,
porque tio Cosme, sacudindo a barriga, chamou-me peralta; mas José Dias
corrigiu a alegria:

--Não tem que festejar a vadiação; o latim sempre lhe ha de ser
preciso, _ainda que não venha a ser padre._

Conheci aqui o meu homem. Era a primeira palavra, a semente lançada á
terra, assim de passagem, como para acostumar os ouvidos da familia.
Minha mãe sorriu para mim, cheia de amor e de tristeza, mas respondeu
logo:

--Ha de ser padre, e padre bonito.

--Não esqueça, mana Gloria, e protonotario tambem. Protonotario
apostolico.

--O protonotario Santiago, accentuou Cabral.

Se a intenção tio meu mestre de latim era ir acostumando ao uso do
titulo com o nome, não sei bem; o que sei é que quando ouvi o meu
nome ligado a tal titulo, deu-me vontade de dizer um desaforo. Mas a
vontade aqui foi antes uma ideia, uma ideia sem lingua, que se deixou
ficar quieta e muda, tal como d'ahi a pouco outras ideias... Mas
essas pedem um capitulo especial. Rematemos este dizendo que o mestre
de latim falou algum tempo da minha ordenação ecclesiastica, ainda
que sem grande interesse. Elle buscava um assumpto alheio para se
mostrar esquecido da propria gloria, mas era esta que o deslumbrava na
occasião. Era um velho magro, sereno, dotado de qualidades boas. Alguns
defeitos tinha; o mais excelso delles era ser guloso, não propriamente
glotão; comia pouco, mas estimava o fino e o raro, e a nossa cosinha,
se era simples, era menos pobre que a delle. Assim, quando minha mãe
lhe disse que viesse jantar, afim de se lhe fazer uma saude, os olhos
com que acceitou seriam de protonotario, mas não eram aposlolicos. E
para agradar a minha mãe novamente pegou em mim, descrevendo o meu
futuro ecclesiastico, e queria saber se ia para o seminario agora, no
anuo proximo, e offerecia-se a falar ao «senhor bispo», tudo marchetado
do «protonotario Santiago.»




XXXVI

Ideia sem pernas e ideia sem braços.

Deixei-os, a pretexto de brincar, e fui-me outra vez a pensar na
aventura da manhã. Era o que melhor podia fazer, sem latim, e até com
latim. Ao cabo de cinco minutos, lembrou-me ir correndo á casa visinha,
agarrar Capitú, desfazer-lhe as tranças, refazel-as e concluil-as
daquella maneira particular, bocca sobre bocca. É isto, vamos, é
isto... Ideia só! ideia sem pernas! As outras pernas não queriam correr
nem andar. Muito depois é que sairam vagarosamente e levaram-me á
casa de Capitú. Quando alli cheguei, dei com ella na sala, na mesma
sala, sentada na marqueza, almofada no regaço, cosendo em paz. Não me
olhou de rosto, mas a furto e a medo, ou, se preferes a phraseologia
do aggregado, obliqua e dissimulada. As mãos pararam, depois de
encravada a agulha no panno. Eu, do lado opposto da mesa, não sabia que
fizesse; e outra vez me fugiram as palavras que trazia. Assim gastámos
alguns minutos compridos, até que ella deixou inteiramente a costura,
ergueu-se e esperou-me. Fui ter com ella, e perguntei se a mãe havia
dito alguma cousa; respondeu-me que não. A bocca com que respondeu era
tal que cuido haver-me provocado um gesto de approximação. Certo é que
Capitú recuou um pouco.

Era occasião de pegal-a, puxal-a e beijal-a... Ideia só ideia sem
braços! Os meus ficaram caidos e mortos. Não conhecia nada da
Escriptura. Se conhecesse, é provavel que o espirito de Satanaz me
fizesse dar a lingua mystica do _Cantico_ um sentido directo e natural.
Então obedeceria ao primeiro versiculo; «Applique elle os labios,
dando-me o osculo da sua bocca.» E pelo que respeita aos braços, que
tinha inertes, bastaria cumprir o vers. 6.o do cap. II:
«A sua mão esquerda se pôz já debaixo da minha cabeça, e a sua mão
direita me abraçará depois.» Vedes ahi a chronologia dos gestos. Era só
executal-a; mas ainda que eu conhecesse o texto, as attitudes de Capitú
eram agora tão retrahidas, que não sei se não continuaria parado, foi
ella entretanto, que me tirou daquella situação.




XXXVII

A alma é cheia de mysterios.

Padre Cabral eslava esperando ha muito tempo?

--Hoje não dei licção; tive férias.

Expliquei-lhe o motivo das férias. Contei-lhe tambem que o padre Cabral
falara da minha entrada no seminario, apoiando a resolução de minha
mãe, e disse delle cousas feias e duras. Capitú reflectiu algum tempo,
e acabou perguntando-me se podia ir comprimentar o padre, á tarde, em
minha casa.

--Póde, mas para que?

Papae naturalmente ha de querer ir tambem, mas é melhor que elle vá á
casa do padre; é mais bonito. Eu não, que já sou meia moça, concluiu
rindo.

O riso animou-me. As palavras pareciam ser uma troça comsigo mesma, uma
vez que, desde manhã, era mulher, como eu era homem. Achei-lhe graça,
e, para dizer tudo, quiz provar-lhe que era moça inteira. Peguei-lhe
levemente na mão direita, depois na esquerda, e fiquei assim pasmado e
tremulo. Era a ideia com mãos. Quiz puxar as de Capitú, para obrigal-a
a vir atraz dellas, mas ainda agora a acção não respondeu á intenção.
Comtudo, achei-me forte e atrevido. Não imitava ninguem; não vivia com
rapazes, que me ensinassem anecdotas de amor. Não conhecia a violação
de Lucrecia. Dos romanos apenas sabia que falavam pela artinha do
padre Pereira e eram patricios de Poncio Pilatos. Não nego que o final
do penteado da manhã era um grande passo no caminho da movimentação
amorosa, mas o gesto de então foi justamente o contrario deste. De
manhã, ella derreou a cabeça, agora fugia-me; nem é só nisso que os
lances differiam; em outro ponto, parecendo haver repetição, houve
contraste.

Penso que ameacei puxal-a a mim. Não juro, começava a estar tão
alvoroçado, que não pude ter toda a consciência dos meus actos; mas
concluo que sim, porque ella recuou e quiz tirar as mãos das minhas;
depois, talvez por não poder recuar mais, collocou um dos pés adeante
e o outro atraz, e fugiu com o busto. Foi este gesto que me obrigou
a reter-lhe as mãos com força. O busto afinal cançou e cedeu, mas a
cabeça não quiz ceder tambem, e, caida para traz, inutilisava lodos
os meus esforços, porque eu já fazia esforços, leitor amigo. Não
conhecendo a licção do _Cantico_, não me acudiu estender a mão esquerda
por baixo do cabeça della; demais, este gesto suppõe um accordo de
vontades, e Capitú, que me resistia agora, aproveitaria o gesto para
arrancar-se á outra mão e fugir-me inteiramente. Ficámos naquelle luta,
sem estrepito, porque apesar do ataque e da defesa, não perdiamos a
cautela necessaria para não sermos ouvidos lá de dentro; a alma é cheia
de mysterios. Agora sei que a puxava; a cabeça continuou a recuar, até
que cançou; mas então foi a vez da bocca. A bocca de Capitú iniciou um
movimento inverso, relativamente á minha, indo para um lado, quando
eu a buscava do lado opposto. Naquelle desencontro estivemos, sem que
ousasse um pouco mais, e bastaria um pouco mais...

Nisto ouvimos bater á porta e falar no corredor. Era o pae de Capitú,
que voltava da repartição um pouco mais cedo, como usava ás vezes.
«Abre, Nanata! Capitú, abre!» Apparentemente era o mesmo lance da
manhã, quando a mãe deu comnosco, mas só apparentemente; em verdade,
era outro. Considerai que de manhã tudo estava acabado, e o passo de D.
Fortunata foi um aviso para que nos compuzessemos. Agora lutavamos com
as mãos presas, e nada estava sequer começado.

Ouvimos o ferrolho da porta que dava para o corredor interno; era a mãe
que abria. Eu, uma vez que confesso tudo, digo aqui que não tive tempo
de soltar as mãos da minha amiga; pensei nisso, cheguei a tental-o, mas
Capitú, antes que o pae acabasse de entrar, fez um gesto inesperado,
pousou a bocca na minha bocca, e deu de vontade o que estava a recusar
á força. Repito, a alma é cheia de mysterios.




XXXVIII

Que susto, meu Deus!

Quando Padua, vindo pelo interior, entrou na sala de visitas,
Capitú, em pé, de costas para mim, inclinada sobre a costura, como a
recolhel-a, perguntava em voz alta:

--Mas, Bentinho, que ó protonotario apostolico?

--Ora, vivam! exclamou o pae.

--Que susto, meu Deus!

Agora é que o lance é o mesmo; mas se conto aqui, taes quaes, os
dous lances de ha quarenta annos, é para mostrar que Capitú não se
dominava só em presença da mãe; o pae não lhe metteu mais medo. No
meio de uma situação que me atava a lingua, usava da palavra com a
maior ingenuidade deste mundo. A minha persuasão é que o coração não
lhe batia mais mais nem menos. Allegou susto, e deu á cara um ar meio
enfiado; mas eu, que sabia tudo, vi que era mentira e fiquei com
inveja. Foi logo falar ao pae, que apertou a minha mão, e quiz saber
porque a filha falava em protonotario apostolico. Capitú repeliu-lhe
o que ouvira de mim, e opinou logo que o pae devia ir comprimentar o
padre em casa delle; ella iria á minha. E colligindo os petrechos da
costura, enfiou pelo corredor, bradando infantilmente:

--Mamãe, jantar, papae chegou!




XXXIX

A vocação.

Padre Cabral estava naquella primeira hora das honras em que as
minimas congratulações valem por odes. Tempo chega em que os
dignificados recebem os louvores como um tributo usual, cara morta,
sem agradecimentos. O alvoroço da primeira hora é melhor; esse estado
da alma que vê na inclinação do arbusto, tocado do vento, um parabém
da flora universal, traz sensações mais intimas e finas que qualquer
outro. Cabral ouviu as palavras de Capitú com infinito prazer.

--Obrigado, Capitú, muito obrigado; estimo que você goste tambem. Papae
está bom? E mamãe? A voce não se pergunta; essa cara é mesmo de quem
vende saude. E como vamos de rezas?

A todas as perguntas, Capitú ia respondendo promptamente e bem.
Trazia um vestidinho melhor e os sapatos de sair. Não entrou com a
familiaridade do costume, deteve-se um instante á porta da sala, antes
de ir beijar a mão a minha mãe e ao padre. Como désse a este, duas
vezes em cinco minutos, o titulo de protonotario, José Dias, para se
desforrar da concurrencia, fez um pequeno discurso em honra «ao coração
paternal e augustissimo de Pio IX.»

--Você é um grande _prosa_, disse tio Cosme, quando elle acabou.

José Dias sorriu sem vexame. Padre Cabral confirmou os louvores do
aggregado, sem os seus superlativos; ao que este accrescentou que
o cardeal Mastai evidentemente fôra talhado para a tiára desde o
principio dos tempos. E, piscando-me o olho, concluiu:

--A vocação é tudo. O estado ecclesiastico é perfeitissimo, comtanto
que o sacerdote venha já destinado do berço. Não havendo vocação, falo
de vocação sincera e real, um joven póde muito bem estudar as lettras
humanas, que tambem são uteis e honradas.

Padre Cabral retorquia:

--A vocação é muito, mas o poder de Deus é soberano. Um homem póde não
ter gosto á egreja e até perseguil-a, e um dia a voz de Deus lhe fala,
e elle sae apostolo; veja S. Paulo.

--Não contesto, mas o que eu digo é outra cousa. O que eu digo é que se
póde muito bem servir a Deus sem ser padre, cá fóra; póde-se ou não se
póde?

--Póde-se.

--Pois então! exclamou José Dias triumphalmente, olhando em volta de
si. Sem vocação é que não ha bom padre, e em qualquer profissão liberal
se serve a Deus, como todos devemos.

--Perfeitamente, mas vocação não é só do berço que se traz.

--Homem, é a melhor.

--Um moço sem gosto nenhum á vida ecclesiastica póde acabar por ser
muito bom padre; tudo é que Deus o determine. Não me quero dar por
modelo, mas aqui estou eu que nasci com a vocação da medicina; meu
padrinho, que era coadjutor de Santa Rita, teimou com meu pae para que
me mettesse no seminario; meu pae cedeu. Pois, senhor, tomei tal gosto
aos estudos e á companhia dos padres, que acabei ordenando-me. Mas,
supponha que não acontecia assim, e que eu não mudava de vocação, o que
é que acontecia? Tinha estudado no seminario algumas materias que é bom
saber, e são sempre melhor ensinadas naquellas casas.

Prima Justina interveiu:

--Como? Então póde-se entrar para o seminario e não sair padre?

Padre Cabral respondeu que sim, que se podia, e, voltando-se para
mim, falou da minha vocação, que era manifesta; os meus brinquedos
foram sempre de egreja, e eu adorava os officios divinos. A prova
não provava; todas as creanças do meu tempo eram devotas. Cabral
accrescentou que o reitor de S. José, a quem contara ultimamente a
promessa de minha mãe, tinha o meu nascimento por milagre; elle era
da mesma opinião. Capitú, cosida ás saias de minha mãe, não attendia
aos olhos anciosos que eu lhe mandava; tambem não parecia escutar a
conversação sobre o seminario e suas consequencias, e, aliás, decorou o
principal, como vim a saber depois. Duas vezes fui á janella, esperando
que ella fosse tambem, e ficassemos á vontade, sósinhos, até acabar o
mundo, se acabasse, mas Capitú não me appareceu. Não deixou minha mãe,
senão para ir embora. Eram ave-marias, despediu-se.

--Vae com ella, Bentinho, disse minha mãe.

--Não precisa, não, D. Gloria, acudiu ella rindo, eu sei o caminho.
Adeus, Sr. protonotario...

--Adeus, Capitú.

Tendo dado um passo no sentido de atravessar a sala, é claro que o
meu dever, o meu gosto, todos os impulsos da edade e da occasião
eram atravessal-a de todo, seguir a visinha corredor fóra, descer á
chacara, entrar no quintal, dar-lhe terceiro beijo, e despedir-me. Não
me importou a recusa, que cuidei simulada, e enfiei pelo corredor;
mas, Capitú que ia depressa, estacou e fez-me signal que voltasse. Não
obedeci; cheguei-me a ella.

--Não venha, não; amanhã falaremos.

--Mas eu queria dizer a você...

--Amanhã.

--Escuta!

--Fica!

Falava baixinho; pegou-me na mão, e poz o dedo na bocca. Uma preta,
que veiu de dentro accender o lampião do corredor, vendo-nos naquella
attitude, quasi ás escuras, riu de sympathia e murmurou em tom que
ouvissemos alguma cousa que não entendí bem nem mal. Capitú segredou-me
que a escrava desconfiara, e ia talvez contar ás outras. Novamente me
intimou que ficasse, e retirou-se; eu deixei-me estar parado, pregado,
agarrado ao chão.




XL

Uma egua.

Ficando só, reflecti algum tempo, e tive uma fantasia. Já conheceis as
minhas fantasias. Contei-vos a da visita imperial; disse-vos a desta
casa do Engenho Novo, reproduzindo a de Matacavallos... A imaginação
foi a companheira de toda a minha existencia, viva, rapida, inquieta,
alguma vez timida e amiga de empacar, as mais dellas capaz de engolir
campanhas e campanhas, correndo. Creio haver lido em Tacito que as
eguas iberas concebiam pelo vento; se não foi nelle, foi n'outro autor
antigo, que entendeu guardar essa crendice nos seus livros. Neste
particular, a minha imaginação era uma grande egua ibera; a menor brisa
lhe dava um potro, que saía logo cavallo de Alexandre; mas deixemos
metaphoras atrevidas e improprias dos meus quinze annos. Digamos o
caso simplesmente. A fantasia daquella hora foi confessar a minha mãe
os meus amores para lhe dizer que não tinha vocação ecclesiastica. A
conversa sobre vocação tornava-me agora toda inteira, e, ao passo que
me assustava, abria-me uma porta de saida. «Sim, é isto, pensei; vou
dizer a mamãe que não tenho vocação e confesso o nosso namoro; se ella
duvidar, conto-lhe o que se passou outro dia, o penteado e o resto... »




XLI

A audiencia secreta.

O resto fez-me ficar mais algum tempo, no corredor, pensando. Vi entrar
o doutor João da Costa, e preparou-se logo o voltarete do costume.
Minha mãe saiu da sala, e, dando commigo, perguntou se acompanhara
Capitú.

--Não, senhora, ella foi só.

E quasi investindo para ella:

--Mamãe, eu queria dizer-lhe uma cousa.

--Que é?

Toda assustada, quiz saber o que é que me doia, se a cabeça, se o
peito, se o estomago, e apalpava-me a testa para ver se tinha febre.

--Não tenho nada, não, senhora.

--Mas então que é?

--É uma cousa, mamãe... Mas, escute, olhe, é melhor depois do chá;
logo... Não é nada mau; mamãe assusta-se por tudo; não é cousa de
cuidado.

--Não é molestia?

--Não, senhora.

--É, isso é volta de constipação. Disfarças para não tomar suadouro,
mas tu estás constipado; conhece-se pela voz.

Tentei rir, para mostrar que não tinha nada. Nem por isso permittiu
adiar a confidencia, pegou em mim, levou-me ao quarto della, accendeu
vela, e ordenou-me que lhe dissesse tudo. Então eu perguntei-lhe, para
principiar, quando é que ia para o seminario.

--Agora só para o anno, depois das férias.

--Vou... para ficar?

--Como ficar?

--Não volto para casa?

--Voltas aos sabbados e pelas férias; é melhor. Quando te ordenares
padre, vens morar commigo.

Enxuguei os olhos e o nariz. Ella afagou-me, depois quiz
reprehender-me, mas creio que a voz lhe tremia, e pareceu-me que tinha
os olhos humidos. Disse-lhe que tambem sentia a nossa separação. Negou
que fosse separação; era só alguma ausencia, por causa dos estudos; só
os primeiros dias. Em pouco tempo eu me acostumaria aos companheiros e
aos mestres, e acabaria gostando de viver com elles.

--Eu só gosto de mamãe.

Não houve calculo nesta palavra, mas estimei dizel-a, por fazer crer
que ella era a minha unica affeição; desviava as suspeitas de cima
de Capitú. Quantas intenções viciosas ha assim que embarcam, a meio
caminho, n'uma phrase innocente e pura! Chega a fazer suspeitar que a
mentira é, muita vez, tão involuntaria como a transpiração. Por outro
lado, leitor amigo, nota que eu queria desviar as suspeitas de cima de
Capitú, quando havia chamado minha mãe justamente para confirmal-as;
mas as contradicções são deste mundo. A verdade é que minha mãe era
candida como a primeira aurora, anterior ao primeiro peccado; nem
por simples intuição era capaz de deduzir uma cousa de outra, isto
é, não concluiria da minha repentina opposição que eu andasse em
segredinhos com Capitú, como lhe dissera José Dias. Calou-se durante
alguns instantes; depois replicou-me sem imposição nem autoridade, o
que me veiu animando á resistencia. Dahi o falar-lhe na vocação que se
discutira naquella tarde, e que eu confessei não sentir em mim.

--Mas tu gostavas tanto de ser padre, disse ella; não te lembras que
até pedias para ir ver sair os seminaristas de S. José, com as suas
batinas? Em casa, quando José Dias te chamava Reverendissimo, tu rias
com tanto gosto! Como é que agora...? Não creio, não, Bentinho. E
depois... Vocação? Mas a vocação vem com o costume, continuou repetindo
as reflexões que ouvira ao meu professor de latim.

Como eu buscasse contestal-a, reprehendeu-me sem aspereza, mas com
alguma força, e eu tornei ao filho submisso que era. Depois, ainda
falou gravemente e longamente sobre a promessa que fizera; não me disse
as circumstancias, nem a occasião, nem os motivos della, cousas que só
vim a saber mais tarde. Affirmou o principal, isto é, que a havia do
cumprir, em pagamento a Deus.

--Nosso Senhor me acudiu, salvando a tua existencia, não lhe hei de
mentir nem faltar, Bentinho; são cousas que não se fazem sem peccado, e
Deus que é grande e poderoso, não me deixaria assim, não, Bentinho; eu
sei que seria castigada e bem castigada. Ser padre é bom e santo; você
conhece muitos, como o padre Cabral, que vive tao feliz com a irmã; um
tio meu tambem foi padre, e escapou de ser bispo, dizem... Deixa de
manha, Bentinho.

Creio que os olhos que lhe deitei foram tão queixosos, que ella emendou
logo a palavra; manha, não, não podia ser manha, sabia muito bem que
eu era amigo della, e não seria capaz de fingir um sentimento que não
tivesse. Molleza é o que queria dizer, que me deixasse de molleza, que
me fizesse homem e obedecesse ao que cumpria, em beneficio della e para
bem da minha alma. Todas essas cousas e outras foram ditas um pouco
atropelladamente, e a voz não lhe saia clara, mas velada e esganada.
Vi que a emoção della era outra vez grande, mas não recuava dos seus
propositos, e aventurei-me a perguntar-lhe:

--E se mamãe pedisse a Deus que a dispensasse da promessa?

--Não, não peço. Estás tonto, Bentinho? E como havia de saber que Deus
me dispensava?

--Talvez em sonho; eu sonho as vezes com anjos e santos.

--Tambem eu, num filho; mas é inútil... Vamos, é tarde; vamos para a
sala. Está entendido: no primeiro ou no segundo mez do anno que vem,
irás para o seminario. O que eu quero é que saibas bem os livros que
estás estudando; é bonito, não só para ti, como para o padre Cabral. No
seminario ha interesse em conhecer-te, porque o padre Cabral fala de ti
com enthusiasmo.

Caminhou para a porta, saimos ambos. Antes de sair, voltou-se para mim,
e quasi a vi saltar-me ao collo e dizer-me que não seria padre. Este
era já o seu desejo intimo, á proporção que se approximava o tempo.
Quizera um modo de pagar a divida contrahida, outra moeda, que valesse
tanto ou mais, e não achava nenhuma.




XLII

Capitú reflectindo.

No dia seguinte fui á casa visinha, logo que pude. Capitú despedia-se
de tres amigas que tinham ido visital-a, Paula e Sandia, companheiras
de collegio, aquella de quinze, esta de desessete annos, a primeira
filha de um medico, a segunda de um commerciante de objectos
americanos. Estava abatida, trazia um lenço atado na cabeça; a mãe
contou-me que fora excesso de leitura na vespera, antes e depois
do chá, na sala e na cama, até muito depois da meia noite, e com
lamparina...

--Se eu accendesse vela, mamãe zangava-se. Já estou boa.

E como desatasse o lenço, a mãe disse-lhe timidamente que era melhor
atal-o, mas Capitú respondeu que não era preciso, estava boa.

Ficámos sós na sala; Capitú continuou a narração da mãe, accrescentando
que passara mal por causa do que ouvira em minha casa. Tambem eu lhe
contei o que se déra commigo, a entrevista com minha mãe, as minhas
supplicas, as lagrimas della, e por fim as ultimas respostas decisivas:
dentro de dous ou tres mezes iria para o seminario. Que fariamos agora?
Capitú ouvia-me com attenção sofrega, depois sombria; quando acabei,
respirava a custo, como prestes a estalar de colera, mas conteve-se.

Ha tanto tempo que isto succedeu que não posso dizer com segurança se
chorou devéras, ou se sómente enxugou os olhos; cuido que os enxugou
sómente. Vendo-lhe o gesto, peguei-lhe na mão para animal-a, mas tambem
eu precisava ser animado. Caimos no canapé, e ficámos a olhar para o
ar. Minto; ella olhava para o chão. Fiz o mesmo, logo que a vi assim...
Mas eu creio que Capitú olhava para dentro de si mesma, emquanto que
eu fitava devéras o chão, o roido das fendas, duas moscas andando e um
pé de cadeira lascado. Era pouco, mas distraía-me da afflicção. Quando
tornei a olhar para Capitú, vi que não se mexia, e fiquei com tal medo
que a sacudi brandamente. Capitú tornou cá para fora e pediu-me que
outra vez lhe contasse o que se passára com minha mãe. Satisfil-a,
attenuando o texto desta vez, para não amofinal-a. Não me chames
dissimulado, chama-me compassivo; é certo que receiava perder Capitú,
se lhe morressem as esperanças todas, mas doia-me vel-a padecer. Agora,
a verdade ultima, a verdade das verdades, é que já me arrependia de
haver falado a minha mãe, antes de qualquer trabalho effectivo por
parte de José Dias; examinando bem, não quizera ter ouvido um desengano
que eu reputava certo, ainda que demorado. Capitú reflectia, reflectia,
reflectia...




XLIII

Você tem medo?

De repente, cessando a reflexão, fitou em mim os olhos de ressaca, e
perguntou-me se tinha medo.

--Medo?

--Sim, pergunto se você tem medo.

--Medo de que?

--Medo de apanhar, de ser preso, de brigar, do andar, de trabalhar...

Não entendi. Se ella me tem dito simplesmente: «Vamos embora!» póde
ser que eu obedecesse ou não; em todo caso, entenderia. Mas aquella
pergunta assim, vaga e solta, não pude atinar o que era.

--Mas... não entendo. De apanhar?

--Sim.

--Apanhar de quem? Quem é que me dá pancada?

Capitú fez um gesto de impaciencia. Os olhos de ressaca não se mexiam
e pareciam crescer. Sem saber de mim, e, não querendo interrogal-a
novamente, entrei a cogitar d'onde me viriam pancadas, e porque, e
tambem porque é que seria preso, e quem é que me havia de prender.
Valha-me Deus! vi de imaginação o aljube, uma casa escura e infecta.
Tambem vi a presiganga, o quartel dos Barbonos e a Casa de Correcção.
Todas essas bellas instituições sociaes me envolviam no seu mysterio,
sem que os olhos de ressaca de Capitú deixassem de crescer para mim,
a tal ponto que as fizeram esquecer de todo. O erro de Capitú foi
não deixal-os crescer infinitamente, antes diminuir até ás dimensões
normaes, e dar-lhes o movimento do costume. Capitú tornou ao que era,
disse-me que estava brincando, não precisava affligir-me, e, com um
gesto cheio de graça, bateu-me na casa sorrindo, e disse:

--Medroso!

--Eu? Mas...

--Não é nada, Bentinho. Pois quem é que ha de dar pancada ou prender
você? Desculpe que eu hoje estou meia maluca; quero brincar, e...

--Não, Capitú; você não está brincando; nesta occasião, nenhum de nós
tom vontade de brincar.

--Tem razão, foi só maluquice; até logo.

--Como até logo?

--Está-me voltando a dôr do cabeça; vou botar uma rodella de limão nas
fontes.

Fez o que disse, e atou o lenço outra vez na testa. Em seguida,
acompanhou-me ao quintal para se despedir de mim; mas, ainda ahi nos
detivemos por alguns minutos, sentados sobre a borda do poço. Ventava,
o ceu estava coberto. Capitú falou novamente da nossa separação, como
de um facto certo e definitivo, por mais que eu, receioso disso mesmo,
buscasse agora razões para animal-a. Capitú, quando não falava, riscava
no chão, com um pedaço cie taquara, narizes e perfis. Desde que se
mettera a desenhar, era uma das suas diversões; tudo lhe servia de
papel e lapis. Como me lembrassem os nossos nomes abertos por ella no
muro, quiz fazer o mesmo no chão, e pedi-lhe a taquara. Não me ouviu ou
não me attendeu.




XLIV

O primeiro filho.

--Dê cá, deixe escrever uma cousa.

Capitú olhou para mim, mas de um modo que me fez lembrar a definição
de José Dias, obliquo e dissimulado; levantou o olhar, sem levantar os
olhos. A voz, um tanto sumida, perguntou-me:

--Diga-me uma cousa, mas fale verdade, não quero disfarce; ha de
responder com o coração na mão.

--Que é? Diga.

--Se você tivesse de escolher entre mim e sua mãe, a quem é que
escolhia?

--Eu?

Fez-me signal que sim.

--Eu escolhia... mas para que escolher? Mamãe não é capaz de me
perguntar isso.

--Pois, sim, mas eu pergunto. Supponha você que está no seminario e
recebe a noticia de que eu vou morrer...

--Não diga isso!

--... Ou que me mato de saudades, se você não vier logo, e sua mãe não
quizer que você venha, diga-me, você vem?

--Venho.

--Contra a ordem de sua mãe?

--Contra a ordem de mamãe.

--Você deixa seminario, deixa sua mãe, deixa tudo, para me ver morrer?

--Não fale em morrer, Capitú!

Capitú teve um risinho descorado e incredulo, e com a taquara escreveu
uma palavra no chão; inclinei-me e li: _mentiroso._

Era tão extranho tudo aquillo, que não achei resposta. Não atinava com
a razão do escripto, como não atinava com a do falado. Se me acudisse
alli uma injuria grande ou pequena, é possivel que a escrevesse tambem,
com a mesma taquara, mas não me lembrava nada. Tinha a cabeça vazia.
Ao mesmo tempo tomei-me de receio de que alguem nos pudesse ouvir ou
ler. Quem, se eramos sós? D. Fortunata chegara uma vez á porta da casa,
mas entrou logo depois. A solidão era completa. Lembra-me que umas
andorinhas passaram por cima do quintal e foram para os lados do morro
de Santa Theresa; ninguem mais. Ao longe, vozes vagas e confusas, na
rua um tropel de bestas, do lado da casa o chilrear dos passarinhos
do Padua. Nada mais, ou sómente este phenomeno curioso, que o nome
escripto por ella, não só me espiava do chão com gesto escarninho,
mas até me pareceu que repercutia no ar. Tive então uma ideia ruim;
disse-lhe que, afinal de contas, a vida de padre não era má, e eu podia
acceital-a sem grande pena. Como desforço, era pueril; mas eu sentia a
secreta esperança de vel-a atirar-se a mim lavada em lagrimas. Capitú
limitou-se a arregalar muito os olhos, e acabou por dizer:

--Padre é bom, não ha duvida; melhor que padre só conego, por causa das
meias roxas. O roxo é côr muito bonita. Pensando bem, é melhor conego.

--Mas não se póde ser conego sem ser primeiramente padre, disse-lhe eu
mordendo os beiços.

--Bem; comece pelas meias pretas, depois virão as roxas. O que eu não
quero perder é a sua missa nova; avise-me a tempo para fazer um vestido
á moda, saia balão e babados grandes... Mas talvez nesse tempo a moda
seja outra. A egreja ha de ser grande, Carmo ou S. Francisco.

--Ou Candelaria.

EOT;

    /*
    End of the Project Gutenberg EBook of Dom Casmurro, by Machado de Assis

    *** END OF THIS PROJECT GUTENBERG EBOOK DOM CASMURRO ***

    ***** This file should be named 55752-8.txt or 55752-8.zip *****
    This and all associated files of various formats will be found in:
            http://www.gutenberg.org/5/5/7/5/55752/

    Produced by Laura Natal Rodriguez & Marc D'Hooghe at Free
    Literature (online soon in an extended version,also linking
    to free sources for education worldwide ... MOOC's,
    educational materials,...) (Images generously made available
    by the Bibliotheca Nacional Digital Brasil.)

    Updated editions will replace the previous one--the old editions will
    be renamed.

    Creating the works from print editions not protected by U.S. copyright
    law means that no one owns a United States copyright in these works,
    so the Foundation (and you!) can copy and distribute it in the United
    States without permission and without paying copyright
    royalties. Special rules, set forth in the General Terms of Use part
    of this license, apply to copying and distributing Project
    Gutenberg-tm electronic works to protect the PROJECT GUTENBERG-tm
    concept and trademark. Project Gutenberg is a registered trademark,
    and may not be used if you charge for the eBooks, unless you receive
    specific permission. If you do not charge anything for copies of this
    eBook, complying with the rules is very easy. You may use this eBook
    for nearly any purpose such as creation of derivative works, reports,
    performances and research. They may be modified and printed and given
    away--you may do practically ANYTHING in the United States with eBooks
    not protected by U.S. copyright law. Redistribution is subject to the
    trademark license, especially commercial redistribution.

    START: FULL LICENSE

    THE FULL PROJECT GUTENBERG LICENSE
    PLEASE READ THIS BEFORE YOU DISTRIBUTE OR USE THIS WORK

    To protect the Project Gutenberg-tm mission of promoting the free
    distribution of electronic works, by using or distributing this work
    (or any other work associated in any way with the phrase "Project
    Gutenberg"), you agree to comply with all the terms of the Full
    Project Gutenberg-tm License available with this file or online at
    www.gutenberg.org/license.

    Section 1. General Terms of Use and Redistributing Project
    Gutenberg-tm electronic works

    1.A. By reading or using any part of this Project Gutenberg-tm
    electronic work, you indicate that you have read, understand, agree to
    and accept all the terms of this license and intellectual property
    (trademark/copyright) agreement. If you do not agree to abide by all
    the terms of this agreement, you must cease using and return or
    destroy all copies of Project Gutenberg-tm electronic works in your
    possession. If you paid a fee for obtaining a copy of or access to a
    Project Gutenberg-tm electronic work and you do not agree to be bound
    by the terms of this agreement, you may obtain a refund from the
    person or entity to whom you paid the fee as set forth in paragraph
    1.E.8.

    1.B. "Project Gutenberg" is a registered trademark. It may only be
    used on or associated in any way with an electronic work by people who
    agree to be bound by the terms of this agreement. There are a few
    things that you can do with most Project Gutenberg-tm electronic works
    even without complying with the full terms of this agreement. See
    paragraph 1.C below. There are a lot of things you can do with Project
    Gutenberg-tm electronic works if you follow the terms of this
    agreement and help preserve free future access to Project Gutenberg-tm
    electronic works. See paragraph 1.E below.

    1.C. The Project Gutenberg Literary Archive Foundation ("the
    Foundation" or PGLAF), owns a compilation copyright in the collection
    of Project Gutenberg-tm electronic works. Nearly all the individual
    works in the collection are in the public domain in the United
    States. If an individual work is unprotected by copyright law in the
    United States and you are located in the United States, we do not
    claim a right to prevent you from copying, distributing, performing,
    displaying or creating derivative works based on the work as long as
    all references to Project Gutenberg are removed. Of course, we hope
    that you will support the Project Gutenberg-tm mission of promoting
    free access to electronic works by freely sharing Project Gutenberg-tm
    works in compliance with the terms of this agreement for keeping the
    Project Gutenberg-tm name associated with the work. You can easily
    comply with the terms of this agreement by keeping this work in the
    same format with its attached full Project Gutenberg-tm License when
    you share it without charge with others.

    1.D. The copyright laws of the place where you are located also govern
    what you can do with this work. Copyright laws in most countries are
    in a constant state of change. If you are outside the United States,
    check the laws of your country in addition to the terms of this
    agreement before downloading, copying, displaying, performing,
    distributing or creating derivative works based on this work or any
    other Project Gutenberg-tm work. The Foundation makes no
    representations concerning the copyright status of any work in any
    country outside the United States.

    1.E. Unless you have removed all references to Project Gutenberg:

    1.E.1. The following sentence, with active links to, or other
    immediate access to, the full Project Gutenberg-tm License must appear
    prominently whenever any copy of a Project Gutenberg-tm work (any work
    on which the phrase "Project Gutenberg" appears, or with which the
    phrase "Project Gutenberg" is associated) is accessed, displayed,
    performed, viewed, copied or distributed:

      This eBook is for the use of anyone anywhere in the United States and
      most other parts of the world at no cost and with almost no
      restrictions whatsoever. You may copy it, give it away or re-use it
      under the terms of the Project Gutenberg License included with this
      eBook or online at www.gutenberg.org. If you are not located in the
      United States, you'll have to check the laws of the country where you
      are located before using this ebook.

    1.E.2. If an individual Project Gutenberg-tm electronic work is
    derived from texts not protected by U.S. copyright law (does not
    contain a notice indicating that it is posted with permission of the
    copyright holder), the work can be copied and distributed to anyone in
    the United States without paying any fees or charges. If you are
    redistributing or providing access to a work with the phrase "Project
    Gutenberg" associated with or appearing on the work, you must comply
    either with the requirements of paragraphs 1.E.1 through 1.E.7 or
    obtain permission for the use of the work and the Project Gutenberg-tm
    trademark as set forth in paragraphs 1.E.8 or 1.E.9.

    1.E.3. If an individual Project Gutenberg-tm electronic work is posted
    with the permission of the copyright holder, your use and distribution
    must comply with both paragraphs 1.E.1 through 1.E.7 and any
    additional terms imposed by the copyright holder. Additional terms
    will be linked to the Project Gutenberg-tm License for all works
    posted with the permission of the copyright holder found at the
    beginning of this work.

    1.E.4. Do not unlink or detach or remove the full Project Gutenberg-tm
    License terms from this work, or any files containing a part of this
    work or any other work associated with Project Gutenberg-tm.

    1.E.5. Do not copy, display, perform, distribute or redistribute this
    electronic work, or any part of this electronic work, without
    prominently displaying the sentence set forth in paragraph 1.E.1 with
    active links or immediate access to the full terms of the Project
    Gutenberg-tm License.

    1.E.6. You may convert to and distribute this work in any binary,
    compressed, marked up, nonproprietary or proprietary form, including
    any word processing or hypertext form. However, if you provide access
    to or distribute copies of a Project Gutenberg-tm work in a format
    other than "Plain Vanilla ASCII" or other format used in the official
    version posted on the official Project Gutenberg-tm web site
    (www.gutenberg.org), you must, at no additional cost, fee or expense
    to the user, provide a copy, a means of exporting a copy, or a means
    of obtaining a copy upon request, of the work in its original "Plain
    Vanilla ASCII" or other form. Any alternate format must include the
    full Project Gutenberg-tm License as specified in paragraph 1.E.1.

    1.E.7. Do not charge a fee for access to, viewing, displaying,
    performing, copying or distributing any Project Gutenberg-tm works
    unless you comply with paragraph 1.E.8 or 1.E.9.

    1.E.8. You may charge a reasonable fee for copies of or providing
    access to or distributing Project Gutenberg-tm electronic works
    provided that

    * You pay a royalty fee of 20% of the gross profits you derive from
      the use of Project Gutenberg-tm works calculated using the method
      you already use to calculate your applicable taxes. The fee is owed
      to the owner of the Project Gutenberg-tm trademark, but he has
      agreed to donate royalties under this paragraph to the Project
      Gutenberg Literary Archive Foundation. Royalty payments must be paid
      within 60 days following each date on which you prepare (or are
      legally required to prepare) your periodic tax returns. Royalty
      payments should be clearly marked as such and sent to the Project
      Gutenberg Literary Archive Foundation at the address specified in
      Section 4, "Information about donations to the Project Gutenberg
      Literary Archive Foundation."

    * You provide a full refund of any money paid by a user who notifies
      you in writing (or by e-mail) within 30 days of receipt that s/he
      does not agree to the terms of the full Project Gutenberg-tm
      License. You must require such a user to return or destroy all
      copies of the works possessed in a physical medium and discontinue
      all use of and all access to other copies of Project Gutenberg-tm
      works.

    * You provide, in accordance with paragraph 1.F.3, a full refund of
      any money paid for a work or a replacement copy, if a defect in the
      electronic work is discovered and reported to you within 90 days of
      receipt of the work.

    * You comply with all other terms of this agreement for free
      distribution of Project Gutenberg-tm works.

    1.E.9. If you wish to charge a fee or distribute a Project
    Gutenberg-tm electronic work or group of works on different terms than
    are set forth in this agreement, you must obtain permission in writing
    from both the Project Gutenberg Literary Archive Foundation and The
    Project Gutenberg Trademark LLC, the owner of the Project Gutenberg-tm
    trademark. Contact the Foundation as set forth in Section 3 below.

    1.F.

    1.F.1. Project Gutenberg volunteers and employees expend considerable
    effort to identify, do copyright research on, transcribe and proofread
    works not protected by U.S. copyright law in creating the Project
    Gutenberg-tm collection. Despite these efforts, Project Gutenberg-tm
    electronic works, and the medium on which they may be stored, may
    contain "Defects," such as, but not limited to, incomplete, inaccurate
    or corrupt data, transcription errors, a copyright or other
    intellectual property infringement, a defective or damaged disk or
    other medium, a computer virus, or computer codes that damage or
    cannot be read by your equipment.

    1.F.2. LIMITED WARRANTY, DISCLAIMER OF DAMAGES - Except for the "Right
    of Replacement or Refund" described in paragraph 1.F.3, the Project
    Gutenberg Literary Archive Foundation, the owner of the Project
    Gutenberg-tm trademark, and any other party distributing a Project
    Gutenberg-tm electronic work under this agreement, disclaim all
    liability to you for damages, costs and expenses, including legal
    fees. YOU AGREE THAT YOU HAVE NO REMEDIES FOR NEGLIGENCE, STRICT
    LIABILITY, BREACH OF WARRANTY OR BREACH OF CONTRACT EXCEPT THOSE
    PROVIDED IN PARAGRAPH 1.F.3. YOU AGREE THAT THE FOUNDATION, THE
    TRADEMARK OWNER, AND ANY DISTRIBUTOR UNDER THIS AGREEMENT WILL NOT BE
    LIABLE TO YOU FOR ACTUAL, DIRECT, INDIRECT, CONSEQUENTIAL, PUNITIVE OR
    INCIDENTAL DAMAGES EVEN IF YOU GIVE NOTICE OF THE POSSIBILITY OF SUCH
    DAMAGE.

    1.F.3. LIMITED RIGHT OF REPLACEMENT OR REFUND - If you discover a
    defect in this electronic work within 90 days of receiving it, you can
    receive a refund of the money (if any) you paid for it by sending a
    written explanation to the person you received the work from. If you
    received the work on a physical medium, you must return the medium
    with your written explanation. The person or entity that provided you
    with the defective work may elect to provide a replacement copy in
    lieu of a refund. If you received the work electronically, the person
    or entity providing it to you may choose to give you a second
    opportunity to receive the work electronically in lieu of a refund. If
    the second copy is also defective, you may demand a refund in writing
    without further opportunities to fix the problem.

    1.F.4. Except for the limited right of replacement or refund set forth
    in paragraph 1.F.3, this work is provided to you 'AS-IS', WITH NO
    OTHER WARRANTIES OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT
    LIMITED TO WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PURPOSE.

    1.F.5. Some states do not allow disclaimers of certain implied
    warranties or the exclusion or limitation of certain types of
    damages. If any disclaimer or limitation set forth in this agreement
    violates the law of the state applicable to this agreement, the
    agreement shall be interpreted to make the maximum disclaimer or
    limitation permitted by the applicable state law. The invalidity or
    unenforceability of any provision of this agreement shall not void the
    remaining provisions.

    1.F.6. INDEMNITY - You agree to indemnify and hold the Foundation, the
    trademark owner, any agent or employee of the Foundation, anyone
    providing copies of Project Gutenberg-tm electronic works in
    accordance with this agreement, and any volunteers associated with the
    production, promotion and distribution of Project Gutenberg-tm
    electronic works, harmless from all liability, costs and expenses,
    including legal fees, that arise directly or indirectly from any of
    the following which you do or cause to occur: (a) distribution of this
    or any Project Gutenberg-tm work, (b) alteration, modification, or
    additions or deletions to any Project Gutenberg-tm work, and (c) any
    Defect you cause.

    Section 2. Information about the Mission of Project Gutenberg-tm

    Project Gutenberg-tm is synonymous with the free distribution of
    electronic works in formats readable by the widest variety of
    computers including obsolete, old, middle-aged and new computers. It
    exists because of the efforts of hundreds of volunteers and donations
    from people in all walks of life.

    Volunteers and financial support to provide volunteers with the
    assistance they need are critical to reaching Project Gutenberg-tm's
    goals and ensuring that the Project Gutenberg-tm collection will
    remain freely available for generations to come. In 2001, the Project
    Gutenberg Literary Archive Foundation was created to provide a secure
    and permanent future for Project Gutenberg-tm and future
    generations. To learn more about the Project Gutenberg Literary
    Archive Foundation and how your efforts and donations can help, see
    Sections 3 and 4 and the Foundation information page at
    www.gutenberg.org



    Section 3. Information about the Project Gutenberg Literary Archive Foundation

    The Project Gutenberg Literary Archive Foundation is a non profit
    501(c)(3) educational corporation organized under the laws of the
    state of Mississippi and granted tax exempt status by the Internal
    Revenue Service. The Foundation's EIN or federal tax identification
    number is 64-6221541. Contributions to the Project Gutenberg Literary
    Archive Foundation are tax deductible to the full extent permitted by
    U.S. federal laws and your state's laws.

    The Foundation's principal office is in Fairbanks, Alaska, with the
    mailing address: PO Box 750175, Fairbanks, AK 99775, but its
    volunteers and employees are scattered throughout numerous
    locations. Its business office is located at 809 North 1500 West, Salt
    Lake City, UT 84116, (801) 596-1887. Email contact links and up to
    date contact information can be found at the Foundation's web site and
    official page at www.gutenberg.org/contact

    For additional contact information:

        Dr. Gregory B. Newby
        Chief Executive and Director
        gbnewby@pglaf.org

    Section 4. Information about Donations to the Project Gutenberg
    Literary Archive Foundation

    Project Gutenberg-tm depends upon and cannot survive without wide
    spread public support and donations to carry out its mission of
    increasing the number of public domain and licensed works that can be
    freely distributed in machine readable form accessible by the widest
    array of equipment including outdated equipment. Many small donations
    ($1 to $5,000) are particularly important to maintaining tax exempt
    status with the IRS.

    The Foundation is committed to complying with the laws regulating
    charities and charitable donations in all 50 states of the United
    States. Compliance requirements are not uniform and it takes a
    considerable effort, much paperwork and many fees to meet and keep up
    with these requirements. We do not solicit donations in locations
    where we have not received written confirmation of compliance. To SEND
    DONATIONS or determine the status of compliance for any particular
    state visit www.gutenberg.org/donate

    While we cannot and do not solicit contributions from states where we
    have not met the solicitation requirements, we know of no prohibition
    against accepting unsolicited donations from donors in such states who
    approach us with offers to donate.

    International donations are gratefully accepted, but we cannot make
    any statements concerning tax treatment of donations received from
    outside the United States. U.S. laws alone swamp our small staff.

    Please check the Project Gutenberg Web pages for current donation
    methods and addresses. Donations are accepted in a number of other
    ways including checks, online payments and credit card donations. To
    donate, please visit: www.gutenberg.org/donate

    Section 5. General Information About Project Gutenberg-tm electronic works.

    Professor Michael S. Hart was the originator of the Project
    Gutenberg-tm concept of a library of electronic works that could be
    freely shared with anyone. For forty years, he produced and
    distributed Project Gutenberg-tm eBooks with only a loose network of
    volunteer support.

    Project Gutenberg-tm eBooks are often created from several printed
    editions, all of which are confirmed as not protected by copyright in
    the U.S. unless a copyright notice is included. Thus, we do not
    necessarily keep eBooks in compliance with any particular paper
    edition.

    Most people start at our Web site which has the main PG search
    facility: www.gutenberg.org

    This Web site includes information about Project Gutenberg-tm,
    including how to make donations to the Project Gutenberg Literary
    Archive Foundation, how to help produce our new eBooks, and how to
    subscribe to our email newsletter to hear about new eBooks.
    */
}
