<?php

namespace FakerPress\ThirdParty\Faker\Provider\ar_JO;

class Text extends \FakerPress\ThirdParty\Faker\Provider\Text
{
    protected static function validStart($word)
    {
        return preg_match('/^\p{Arabic}/u', $word);
    }

    /**
     * License: Attribution-ShareAlike 3.0 Unported (CC BY-SA 3.0)
     *
     * Title: حي بن يقظان
     * Author: ابن الطفيل
     * Language: Arabic
     *
     * @see https://ar.wikisource.org/wiki/%D8%A7%D8%A8%D9%86_%D8%A7%D9%84%D8%B7%D9%81%D9%8A%D9%84_-_%D8%AD%D9%8A_%D8%A8%D9%86_%D9%8A%D9%82%D8%B8%D8%A7%D9%86
     *
     * @var string
     */
    protected static $baseText = <<<'EOT'
ذكر سلفنا الصالح - رضي الله عنهم - أن جزيرة من جزائر الهند التي تحت خط الاستواء، وهي الجزيرة التي يتولد بها الإنسان من غير أم ولا أب، وبها شجر يثمر نساء، وهي التي ذكر المسعودي أنها جزيرة الوقواق لان تلك الجزيرة اعدل بقاع الأرض هواء؛ أتممها لشروق النور الأعلى عليها استعدادً، وان كان ذلك خلاف ما يراه جمهور الفلاسفة وكبار الأطباء، فانهم يرون إن اعدل ما في المعمورة الإقليم الرابع، فان كانوا قالوا ذلك لأنه صح عندهم انه ليس على خط الاستواء عمارة لمانع من الموانع الأرضية، فلقولهم: أن الإقليم الرابع اعدل بقاع الأرض وجه، وان كانوا إنما أرادوا بذلك إن ما على خط الاستواء شديد الحرارة، كالذي يصرح به أكثرهم فهو خطأ يقوم البرهان على خلافه.

وذلك أنه قد تبرهن في العلوم الطبيعية أنه لا سبب لتكون الحرارة إلا الحركة أو ملاقاة الأجسام الحارة والإضاءة؛ وتبين فيها أيضاً إن الشمس بذاتها غير حارة ولا متكيفة بشيء من هذه الكيفيات المزاجية؛ وقد تبين فيها أيضاً إن الأجسام التي تقبل الإضاءة أتم القبول، هي الأجسام الصقيلة غير الشفافة، ويليها في قبول ذلك الأجسام الكثيفة غير الصقيلة، فأما الأجسام الشفافة التي لاشيء فيها من الكثافة فلا تقبل الضوء بوجه.

وهذا وحده مما برهنه الشيخ أبو علي خاصة، ولم يذكره من تقدمه، فإذا صحت هذه المقدمات، فاللازم عنها أن الشمس لا تسخن الأرض كما تسخن الأجسام الحارة أجسام أخر تماسها، لان الشمس في ذاتها غير حارة ولا الأرض أيضاً تسخن بالحركة لأنها ساكنة وعلى حالة واحدة في شروق الشمس عليها وفي وقت مغيبها عنها وأحوالها في التسخين والتبريد، ظاهرة الاختلاف للحس في هذين الوقتين.

ولا الشمس أيضاً تسخن الهواء أولاً ثم تسخن بعد ذلك الأرض بتوسط سخونة الهواء، وكيف يكون ذلك ونحن نجد أن ما قرب من الهواء من الأرض في وقت الحر، أسخن كثيراً من الهواء الذي يبعد منه علواً؟ فبقي أن تسخين الشمس للأرض إنما هو على سبيل الإضاءة لا غير، فان الحرارة تتبع الضوء أبداً: حتى إن الضوء إذا افرط في المرأة المقعرة، أشعل ما حاذاها.

وقد ثبت في علوم التعاليم بالبراهين القطعية، أن الشمس كروية الشكل، وأن الأرض كذلك، وأن الشمس أعظم من الأرض كثيراً، وأن الذي يستضيء من الشمس أبداً هو أعظم من نصفها، وأن هذا النصف المضيء من الأرض في كل وقت أشد ما يكون الضوء في وسطه، لأنه أبعد المواضع من المظلمة، ولأنه يقابل من الشمس أجزاءاً أكثر، وما قرب من المحيط كان أقل ضوءاً حتى ينتهي إلى الظلمة عند محيط الدائرة الذي ما أضاء موقعه من الأرض قط، وإنما يكون الموضع وسط دائرة الضياء إذا كانت الشمس على سمت رؤوس الساكنين فيه، وحينئذ تكون الحرارة في ذلك الموضع أشد ما يكون فان كان الموضع مما تبعد الشمس عن مسامتة رؤوس أهله، كان شديد البرودة جداً، وان كان مما تدوم فيه المسامتة كان شديد الحرارة، وقد ثبت في علم الهيئة أن بقاع الأرض التي على خط الاستواء لا تسامت الشمس رؤوس أهلها سوى مرتين في العام: عند حلولها برأس الحمل؛ وعند حلولها برأس الميزان.

وهي في سائر العام ستة أشهر جنوباً منهم، وستة أشهر شمالاً منهم: فليس عندهم حر مفرط، ولا برد مفرط. وأحوالهم بسبب ذلك متشابهة.

وهذا القول يحتاج إلى بيان أكثر من هذا، لا يليق بما نحن بسبيله؛ وإنما نبهناك عليه، لأنه من الأمور التي تشهد بصحة ما ذكر من تجويز تولد الإنسان بتلك البقعة من غير أم ولا أب.

فمنهم من بت الحكم وجزم القضية بأن حي بن يقظان من جملة من تكون في تلك البقعة من غير أم ولا أب، ومنهم من أنكر ذلك وروى من أمره خبراً نقصه عليك، فقال: انه كان بازاء تلك الجزيرة، جزيرة عظيمة متسعة الأكتاف، كثيرة الفوائد، عامرة بالناس، يملكها رجل منهم شديد الأنفة والغيرة، وكانت له أخت ذات جمال وحسن باهر فعضلها ومنعها الأزواج إذا لم يجد لها كفواً. وكان له قريب يسمى يقظان فتزوجها سراً على وجه جائز في مذهبهم المشهور في زمنهم.

ثم إنها حملت منه ووضعت طفلاً. فلما خافت أن يفتضح أمرها وينكشف سرها، وضعته في تابوت أحكمت زمه بعد أن أروته من الرضاع؛ وخرجت به في أول الليل في جملة من خدمها وثقاتها إلى ساحل البحر، وقلبها يحترق صبابةً به، وخوفاً عليه، ثم إنها ودعته وقالت: "اللهم انك خلقت هذا الطفل ولم يكن شيئاً مذكوراً، ورزقته في ظلمات الأحشاء، وتكفلت به حتى تم واستوى. وأنا قد سلمته إلى لطفك، ورجوت له فضلك، خوفاً من هذا الملك الغشوم الجبار العنيد.

فكن له، ولا تسلمه، يا أرحم الراحمين" ثم قذفت به في اليم. فصادف ذلك جري الماء بقوة المد، فاحتمله من ليلته إلى ساحل الجزيرة الأخرى المتقدم ذكرها. وكان المد يصل في ذلك الوقت إلى موضع لا يصل إليه بعد علم. فأدخله الماء بقوته إلى أجمة ملتفة الشجر عذبة التربة، مستورة عن الرياح والمطر، محجوبة عن الشمس تزاور عنها إذا طلعت، وتميل إذا غربت. ثم أخذ الماء في الجزر.

وبقي التابوت في ذلك الموضع، وعلت الرمال بهبوب الرياح، وتراكمت بعد ذلك حتى سدت مدخل الماء إلى تلك الأجمة. فكان المد لا ينتهي إليها، وكانت مسامير التابوت قد فلقت، وألواحه قد اضطربت عند رمي الماء في تلك الأجمة. فلما أشتد الجوع بذلك الطفل، بكى واستغاث وعالج الحركة، فوقع صوته في أذن ظبية فقدت طلاها، خرج من كناسه فحمله العقاب، فلما سمعت الصوت ظنته ولدها.

فتتبعت الصوت وهي تتخيل طلاها حتى وصلت إلى التابوت، ففحصت عنه بأظلافها وهو ينوء ويئن من داخله، حتى طار عن التابوت لوح من أعلاه. فحنت الظبية وحنت عليه ورئفت به، وألقمه حلمتها وأروته لبناً سائغاً. ومازالت تتعهده وتربيه وتدفع عنه الأذى. هذا ما كان من ابتداء أمره عند من ينكره التولد. ونحن نصف هنا كيف تربى وكيف أنتقل في أحواله حتى يبلغ المبلغ العظيم. وأما الذين زعموا أنه تولد من الأرض فانهم قالوا إن بطناً من أرض تلك الجزيرة تخمرت فيه طينه على مر السنين والأعوام، حتى امتزج فيها الحار بالبارد، والرطب باليابس، امتزاج تكافؤ وتعادل في القوى. وكانت هذه الطينة المتخمرة كبيرة جداً وكان بعضها يفضل بعضاً في اعتدال المزاج والتهيؤ لتكون الأمشاج.

وكان الوسط منها أعدل ما فيها وأتمه مشابهة بمزاج الإنسان: فتمخضت تلك الطينة، وحدث فيها شبه نفاخات الغليان لشدة لزوجتها: وحدث في الوسط منها لزوجة ونفاخة صغيرة جداً، منقسمة بقسمين، بينها حجاب رقيق، ممتلئة بجسم لطيف هوائي في غاية من الاعتدال اللائق به، فتعلق به عند ذلك الروح الذي هو من أمر الله تعالى وتشبث به تشبثاً يعسر انفصاله عنه عند الحس وعند العقل؛ إذ قد تبين أن هذا الروح دائم الفيضان من عند الله عز وجل، وأنه بمنزلة نور الشمس الذي هو دائم الفيضان على العالم.

فمن الأجسام ما لا يستضيء به، وهو الهواء الشفاف جداً؛ ومنها ما يستضيء به بعض الاستضاءة، وهي الأجسام الكثيفة غير الصقيلة وهذه تختلف في قبول الضياء، وتختلف بحسب ذلك ألوانها، ومنها ما يستضيء به غاية الاستضاءة وهي الأجسام الصقيلة كالمرأة ونحوها.

فإذا كانت هذه المرأة مقعرة على شكل مخصوص، حدث فيها النار لإفراط الضياء. الذي هو الروح، الذي هو من أمر الله تعالى، فياض أبداً على جميع الموجودات؛ فمنها ما لا يظهر أثره فيه اعدم الأستعداد، وهي الجمادات التي لا حياة لها، وهذه بمنزلة الهواء في المثال المتقدم، ومنها ما يظهر أثره فيه، وهي أنواع النبات بحسب استعداداتها وهذه بمنزلة الأجسام الكثيفة في المثال المتقدم؛ ومنها ما يظهر أثره فيه ظهوراً كثيراً، وهي الأجسام الصقيلة في المثال المتقدم.

ومن هذه الأجسام الصقيلة ما يزيد على شدة قبوله لضياء الشمس أنه يحكي صورة الشمس، ومثالها. وكذلك أيضاً من الحيوان ما يزيد على شدة قبوله للروح أنه يحكي الروح ويتصور بصورته وهو الإنسان خاصة.

واليه الإشارة بقوله صلى الله عليه وسلم: "إن الله خلق أدم على صورته". فان قويت في هذه الصورة حتى تتلاشى جميع الصور في حقها، وتبقى هي وحدها، وتحرق سبحات نورها كل ما أدركته، كانت حينئذ بمنزلة المرأة المنعكسة على نفسها المحرقة لسوها وهذا لا يكون إلا للأنبياء صلوات الله عليهم أجمعين. وهذا كله مبين في مواضعه اللائقة به، فليرجع إلى تمام ما حكوه من وصف ذلك التخلق.

قالوا: فلما تعلق هذا الروح بتلك القرارة، خضعت له جميع القوى وسجدت له وسخرت بأمر الله تعالى في كمالها، فتكون بازاء تلك القرارة نفاخة أخرى منقسمة إلى ثلاث قرارت بينهما حجب لطيفة، ومسالك نافذة، وامتلأت بمثل ذلك الهوائي الذي امتلأت منه القرارة الأولى؛ إلا أنه ألطف منه. وفي هذه البطون الثلاثة المنقسمة من واحد، طائفة من تلك القوى التي خضعت له وتوكلت بحراستها والقيام عليها، وإنهاء ما يطرأ فيها من دقيق الأشياء وجليلها إلى الروح الأول المتعلق بالقرارة الأولى.

وتكون بازاء هذه القرارة من الجهة المقابلة للقراءة الثانية، نفاخة ثالثة مملوءة جسماً هوائياً، إلا أنه أغلظ من الأولين وسكن في هذه القرارة فريق من تلك القوى الخاضعة، وتوكلت بحفظها و القيام عليها؛ فكانت هذه القرارة الأولى والثانية والثالثة، أول ما تخلق من تلك الطينة المتحمرة على الترتيب الذي ذكرناه. واحتاج بعضها إلى بعض: فالأولى منها حاجتها إلى الآخرين، حاجة استخدام وتسخير.

والأخريان حاجتهما إلى الأولى حاجة المرؤوس إلى الرئيس، والمدبر إلى المدبر؛ وكلاهما لما يتخلق بعدهما من الأعضاء رئيس لا مرؤوس. وأحدهما، وهو الثاني، أتمم رئاسة من الثالث فالأول منهما لما تعلق به الروح، واشتعلت حرارته تشكل بشكل النار لصنوبري وتشكل أيضاً الجسم الغليظ المحدق به على شكله، وتكون لحماً صلباً، وصار عليه غلاف صفيق يحفظه وسمي العضو كله قلباً واحتاج لما يتبع الحرارة من التحليل وافناء الرطوبات إلى شيء يمده ويغذوه، ويخلف ما تحلل منه على الدوام، وإلا لم يطل بقاؤه، واحتاج أيضاً إلى تحسس بما يلائمه فيجذبه، وبما يخالفه فيدفعه. فتكفل له العضو الواحد بما فيه من القوى التي أصلها منه بحاجته الواحدة، وتكفل له العضو الآخر بحاجته الأخرى.

وكان المتكفل بالحس هو الدماغو المتكفل بالغذاء هو الكبد؛ واحتاج كل واحد من هذين إليه في أن يمدها بحرارته، وبالقوى المخصوصة بهما التي أصلها منه ، فانتسجت بينهما لذلك كله مسالك وطرق: بعضها أوسع من بعض بحسب ما تدعواليه الضرورة، فكانت الشرايين و العروق. وصفه الطبيعيون في خلقة الجنين في الرحم، لم يغادروا من ذلك شيئاً، إلى أن كمل خلقه، وتمت أعضاؤه، وحصل في حد خروج الجنين من البطن، واستعانوا في وصف كمال ذلك بتلك الطينة الكبيرة المتخمرة، وأنها كانت قد تهيأت لان يتخلق منها كل ما يحتاج إليه في خلق الإنسان من الأغشية المجللة لجملة بدنه وغيرها فلما كمل انشقت عنه تلك الأغشية، بشبه المخاض، وتصدع باقي الطينة إذ كان قد لحقه الجفاف.

ثم استغاث ذلك الطفل عند فناء مادة غذائه واشتداد جوعه، فلبته ظبية فقدت طلاها. ثم استوى عبد ما وصفه هؤلاء بعد هذا الموضع، وما وصفه الطائفة الأولى في معنى التربية؛ فقالوا جميعاً: إن الظبية التي تكفلت به وافقت خصباً ومرعى أثيثاً، فكثر لحمها وكثر لبنها، حتى قام بغذاء ذلك الطفل أحسن قيام. وكانت معه لا تبعد عنه إلا لضرورة الرعي. وألف الطفل تلك الظبية حتى كان بحيث إذا هي أبطأت عنه اشتد بكاؤه فطارت إليه.

ولم يكن بتلك الجزيرة شيء من السباع العادية، فتربى الطفل ونما واغتذى بلبن تلك الظبية إلى أن تم له حولان، وتدرج في المشي وأثغر فكان يتبع تلك الظبية، وكانت هي ترفق به و ترحمه وتحمله إلى مواضع فيها شجر مثمر فكانت تطعمه ما تساقط من ثمراتها الحلوة النضيجة؛ وما كان منها صلب القشر كسرته له بطواحنها؛ ومتى عاد إلى اللبن أروته، ومتى ظمئ إلى الماء أرودته، متى ضحا ظللته؛ ومتى خصر أدفأته.

وإذا جن الليل صرفته إلى مكان الأول وجللته بنفسها وبريش كان هناك؛ مما ملئ به التابوت أولاً في وقت وضع الطفل فيه. وكان في غدوهما ورواحهما قد ألفهما ربرب يسرح ويبيت معهما حيث مبيتهما. فما زال الطفل مع الظباء على تلك الحال: يحكي نغمتها بصوته حتى لا يكاد يفرق بينهما؛ وكذلك كان يحكي جميع ما يسمعه من أصوات الطير وأنواع سائر الحيوان محاكاة شديدة لقوة انفعاله لما يريده ما كانت محاكاته لأصوات الظباء في الاستصراخ والاستئلاف والاستدعاء والاستدفاع. إذ للحيوانات في هذه الأحوال المختلفة أصوات مختلفة فألفته الوحوش وألفها؛ ولم تنكره ولا أنكرها.

فلما ثبت في نفسه أمثلة الأشياء بعد مغيبها عن مشاهدته، حدث له نزوغ إلى بعضها؛ وكراهية لبعض. وكان في ذلك كله ينظر إلى جميع الحيوانات فيراها كاسية بالاوبار و الأشعار و أنواع الريش، وكان يرى ما لها من العدو وقوة البطش، وما لها من الأسلحة المعدة لمدافعة من ينازعها، مثل القرون و الأنياب و الحوافر و الصياصي و المخالب. ثم يرجع إلى نفسه، فيرى ما به من العري وعدم السلاح، وضعف العدو، وقلة البطش، عندما كانت تنازعه الوحوش أكل الثمرات، وتستبد بها دونه، وتغلبه عليها، فلا يستطيع المدافعة عن نفسه، ولا الفرار عن شيء منها. وكان يرى أترابه من أولاد الظباء، قد تبتت لها قرون، بعد أن لم تكن، وصارت قوية بعد ضعفها في العدو.

ولم ير لنفسه شيئاً من ذلك فكان يفكر في ذلك ولا يدري ما سببه. وكان ينظر إلى ذوي العاهات والخلق الناقص فلا يجد لنفسه شبيهاً فيهم. وكان أيضاً ينظر إلى مخارج الفضول من سائر الحيوانات، فيراها مستورة: أما مخرج أغلظ الفضلتين فبالاذناب، وأما مخرج وأما مخرج أرقهما فبالاوبار وما أشبههما. ولأنها كانت أيضاً اخفى قضباناً منه. فكان ذلك ما يكربه ويسؤه.

فلما طال همه في ذلك كله، وهو قد قارب سبعة اعوام، ويئس من أن يكمل له ما قد أضر به نقصه، اتخذ من أوراق الشجر العريضة شيئاً جعل بعضه خلفه و بعضه قدمه، وعمل من الخوض والحلفاء شبه حزام على وسطه، علق به تلك الأوراق فلم يلبث إلا يسيراً حتى ذوى ذلك الورق وجف وتساقط. فما زال يتخذ غيره ويخصف بعضه ببعض طاقات مضاعفة، وربما كان ذلك أطول لبقائه إلا انه على كل حال قصير المدة.

واتخذ من أغصان الشجر عصياً وسوى أطرافها وعدل متنها. وكان بها على الوحوش المنازعة له، فيحمل على الضعيف منها، ويقاوم القوي منها، فنبل بذلك قدره عند نفسه بعض نباله، ورأى أن ليده فضلاً كثيراً على أيديها: إذ أمكن له بها ستر عورته واتخاذ العصي التي يدافع بها عن حوزته، ما استغنى به عما أراده من الذنب والعذاب الطبيعي. وفي خلال ذلك ترعرع واربى على السبع سنين، وطال به العناء في تجديد الأوراق التي كان يستتر بها.

فكانت نفسه عند ذلك تنازعه إلى اتخاذ ذنب من ذنوب الوحوش الميتة ليعلقه على نفسه، إلا أنه كان يرى أحياء الوحوش تتحامى ميتها وتفر عنه فلا يتأتى له الأقدام على ذلك الفعل، إلى أن صادف في الأيام نسراً ميتاً فهدي إلى نيل أمله منه، واغتنم الفرصة في، إذ لم ير للوحوش عنه نفرةً فأقدم عليه، وقطع جناحيه وذنبه صحاحاً كما هي، وفتح ريشها وسواها، وسلخ عنه سائر جلده، وفصله على قطعتين: ربط إحداهما على ظهره، وأخرى على سرته وما تحتها، وعلق الذنب من خلفه، وعلق الجناحين على عضديه، فأكسبه ذلك ستراً ودفئاً ومهابة في نفوس جميع الوحوش، حتى كانت لا تنازعه ولا تعارضه. فصار لايدنو إليه شيء منها سوى الظبية التي كانت أرضعته وربته: فانها لم تفارقه ولا فارقها، إلى أن اسنت وضعغت، فكان يرتاد بها المراعي الخصبة ويجتني لها الثمرات الحلوة، ويطعمها.

ومازل الهزل والضعف يستولي عليها ويتوالى، إلى أن أدركها الموت، فسكنت حركاتها بالجملة، وتعطلت جميع أفعالها. فلما رأها الصبي على تلك الحالة، جزع جزعاً شديداً، وكادت نفسه تفيض أسفاً عليها. فكان يناديها بالصوت الذي كانت عادتها أن تجيبه عند سماعه، ويصيح بأشد ما يقدر عليه، فلا لها عند ذلك حركة ولا تغييراً. فكان ينظر إلى أذنيها والى عينيها فلا يرى بها آفة ظاهرة، وكذلك كان ينظر إلى جميع أعضائها فلا يرى بشيء منها آفة.

فكان يطمع إن يعثر على موضع الآفة فيزيلها عنها، فترجع إلى ما كانت عليه فلم ياتت له شيء من ذلك ولا استطاعة. وكان الذي أرشده لهذا الرأي ما كان قد اعتبره في نفسه قبل ذلك: لانه كان يرى انه إذا غمض عينيه أو حجبهما بشيء لا يبصر حتى نزول ذلك العائق، وكذلك كان يرى انه اذا ادخل إصبعه في أذنيه وسدها لا يسمع شيئاً حتى يزول ذلك العارض، وإذا امسك أنفه بيده لا يشم شيئاً من الروائح حتى يفتح أنفه. فاعتقد من اجل ذلك إن جميع ماله من الادراكات و الأفعال قد تكون لها عوائق تعوقها، فإذا أزيلت العوائق عادت الأفعال.

فلما نظر إلى جميع أعضاء الظاهرة ولم ير فيها آفة ظاهرة - وكان يرى مع ذلك العطلة قد اشتملها ولم يختص بها عضو دون عضو - وقع في خاطرة أن الآفة التي نزلت بها، إنما هي العضو غائب عن العيان مستكن في باطن الجسد، وان ذلك العضو لا يغني عنه في فعله شيء من هذه الأعضاء الظاهرة. فلما نزلت به الآفة عمت المضرة، وشملت العطلة، وطمع لو أنه عثر على ذلك العضو وأزال عنه ما يزال به لاستقامت أحواله وفاض على سائر البدن نفعه، وعادت الأفعال إلى ما كانت عليه.

وكان قد شاهد قبل ذلك في الأشباح الميتة من الوحوش وسواها أن جميع أعضائها مصمتة لا تجويف فيها إلا القحف، والصدر، والبطن. فوقع في نفسه أن العضو الذي بتلك الصفة لن يعدو أحد هذه المواضع الثلاثة، وكان يغلب على ظنه غلبة قوية أنه إنما هو في الموضع المتوسط من هذه المواضع الثلاثة، إذ استقر في نفسه أن جميع الأعضاء محتاجة إليه، وأن الواجب بحسب ذلك أن يكون مسكنه في الوسط.

وكان أيضاً إذا رجع إلى ذاته، شعر بمثل هذا العضو في صدره لانه كان يعترض سائراً اعضائه كاليد، والرجل، والأذن، والانف، والعين، ويقدر مفارقتها، فيتاى له أنه كان يستغني عنها، وكان يقدر في رأسه مثل ذلك ويظن أنه يستغني عنه، فإذا فكر في الشيء الذي يجده في صدره، لم يتأت له الاستغناء عنه طرفة عين.

وكذلك كان عند محاربته للوحوش أكثر ما كان يتقي من صياصيهم على صدره، لشعوره بالشيء الذي فيه. فلما جزم الحكم بان العضو الذي نزلت به الآفة إنما هو في صدورها، اجمع على البحث عليه والتنقير عنه، لعله يظفر به، ويرى آفته فيزيلها ثم انه خاف أنه يكون نفس فعله هذا أعظم من الآفة التي نزلت بها أولاً فيكون سعيه عليها. ثم أنه تفكر: هل رأى من الوحوش وسواها، من ضار في مثل تلك الحال، ثم عاد إلى مثل حاله الأول؟ فلم يجد شيئاً! فحصل له من ذلك، اليأس من رجوعها إلى حالها الأولى إن هو تركها، وبقي له بعض الرجاء في رجوعها إلى تلك الحال إن هو وجد ذلك العضو وأزال الآفة عنه. فعزم على شق صدرها وتفتيش ما فيه، فاتخذ من كسور الأحجار الصلدة وشقوق القصب اليابسة، أشباه السكاكين، وشق بها بين أضلاعها حتى قطع اللحم الذي بين الأضلاع، وأفضى إلى الحجاب المستبطن للأضلاع فراه قوياً، فقوي ظنه مثل ذلك الحجاب لا يكون إلا لمثل ذلك العضو وطمع بأنه إذا تجاوزه ألفى مطلوبه فحاول شقه، فصعب عليه، لعدم الآلات، ولأنها لم تكن إلا من الحجارة والقصب، فاستجدها ثانية واستحدها وتلطف في خرق الحجاب حتى انخرق له، فأفضى إلى الرئة فظن أنها مطلوبه، فما زال يقلبها ويطلب موضع الآفة بها.

وكان أولاً نصفها الذي هو في الجانب الواحد. فلما راها مائلة إلى جهة واحدة، وكان قد اعتقد أن ذلك العضو لا يكون إلا في الوسط في عرض البدن، كما في الوسط في طوله. فمازال يفتش في وسط الصدر حتى ألفى القلب وهو مجلل بغشاء في غاية القوة مربوط بعلائق في غاية الوثاقة، والرثة مطيفة به من الجهة التي بدأ بالشق منها، فقال في نفسه: إن كان لهذا العضو من الجهة الأخرى مثل ما له من الجهة فهو في حقيقة الوسط، ولا محالة أنه مطلوبي. لا سيما مع ما أرى له حسن الوضع، وجمال الشكل، وقلة التشتت، وقوة اللحم، وأنه محجوب بمثل هذا الحجاب الذي لم أر مثله لشيء من الأعضاء. فبحث عن الجانب الآخر من الصدر، فوجد فيه الحجاب المستبطن للأضلاع، ووجد الرئة كمثل ما وجد من هذه الجهة.

فحكم بان ذلك العضو هو مطلوبه، فحاول هتك حجابه، وشق شغافه، فبكد واستكراه ما، قدر على ذلك، بعد استفراغ مجهوده. وجرد القلب فراه مصمتاً من كل جهة، فنظر هل يرى فيه آفة ظاهرة؟ فلم ير فيه شيئاً! فشد على يده، فتبين له أن فيه تجويفاً، فقال: لعل مطلوبي الأقصى إنما هو في داخل هذا العضو، وأنا حتى الآن لم أصل إليه. فشق عليه، فألقى فيه تجويفين اثنين احدهما من الجهة اليمنى والآخر من الجهة اليسرى، والذي من الجهة اليمنى مملوء بعقد منعقد، والذي من الجهة اليسرى خال لا شيء به.

فقال: لن يعدو مطلوبي أن يكون مسكنه أحد هذين البيتين. ثم قال: أما هذا البيت الأيمن، فلا أرى فيه إلا هذا الدم المنعقد. ولا شك أنه لم ينعقد حتى صار الجسد كله إلى هذا الحال - إذ كان قد شاهد الدماء متى سالت وخرجت انعقدت وجمدت ولم يكن هذا إلا دماً كسائر الدماء - وأنا أرى أن هذا الدم موجود في سائر الأعضاء لا يختص به عضو دون أخر، وأنا ليس مطلوبي شيئاً بهذه الصفة إنما مطلوبي الشيء الذي يختص به هذا الموضع الذي أجدني لا أستغني عنه طرفة العين، واليه كان انبعاثي من أول. واما هذا الدم فكم مرة جرحتني الوحوش في المحاربة فسال مني كثير منه فما ضرني ذلك ولا افقدني شيئاً من أفعالي، فهذا بيت ليس فيه مطلوبي. وأما هذا البيت الأيسر فأراه خالياً لاشيء فيه، وما أرى ذلك لباطل، فاني رأيت كل عضو من الأعضاء إنما لفعل يختص به، فكيف يكون هذا البيت على ما شاهدت من شرفه باطلاً؟ ما أرى إلا أن مطلوبي كان فيه! فارتحل عنه وأخلاه. وعند ذلك، طرأ على هذا الجسد من العطلة ما طرأ، ففقد الإدراك وعدم الحراك. فلما رأى أن الساكن في ذلك البيت قد ارتحل قبل انهدامه وتركه وهو بحاله، تحقق أنه أحرى أن لا يعود إليه بعد أن حدث فيه من الخراب والتخريق ما حدث. فصار عنده الجسد كله خسيساً لا قدر له بالإضافة إلى ذلك الشيء الذي اعتقد في نفسه أنه يسكنه مدة ويرحل عنه بعد ذلك.

فاقتصر على الفكرة في ذلك الشيء ما هو؟ وكيف هو؟ وما الذي ربطه بهذا الجسد؟ والى اين صار؟ ومن أي الأبواب خرج عند خروجه من الجسد؟ وما السبب الذي أزعجه إن كان خرج كارهاً؟ وما السبب الذي كره إليه الجسد، حتى فارقه إن كان خرج مختاراً؟ وتشتت فكره في ذلك كله، وسلا عن الجسد وطرحه، وعلم أن أمه التي عطفت عليه وأرضعته، إنما كانت ذلك الشيء المرتحل، وعنه كانت تصدر تلك الأفعال كلها، لا هذا الجسد العاطل وأن هذا الجسد بجملته، إنما هو كالآلة وبمنزلة العصي التي اتخذها هو لقتال الوحوش. فانتقلت علاقته عن الجسد إلى صاحب الجسد ومحركه، ولم يبق له شوق إلا إليه. وفي خلال ذلك نتن ذلك الجسد، وقامت منه روائح كريهة، فزادت نفرته عنه، وود أن لا يراه ثم انه سنح لنظره غرابان يقتتلان حتى صرع أحدهما الآخر ميتاً. ثم جعل الحي يبحث في الأرض حتى حفر حفرة فوارى فيها ذلك الميت بالتراب فقال في نفسه: ما أحسن ما صنع هذا الغراب في مواراة جيفة صاحبه وان كان قد أساء في قتله اياه! وأنا كنت أحق بالاهتداء إلى هذا الفعل بآمي! فحفر حفرة وألقى فيها جسد أمه، وحثا عليها التراب.

وبقي يتفكر في ذلك الشيء المصرف للجسد لا يدري ما هو! غير أنه كان ينظر إلى أشخاص الظباء كلها، فيراها على شكل أمه، وعلى صورتها فكان يغلب على ظنه، أن كل واحد منها إنما يحركه ويصرفه شيء هو مثل الشيء الذي كان يحرك أمه ويصرفها، فكان يألف الظباء ويحن إليها لمكان ذلك الشبه. وبقي على ذلك برهة من الزمن، يتصفح أنواع الحيوان والنبات ويطوف بساحل تلك الجزيرة، ويتطلب هل يرى أو يجد لنفسه شبيهاً حسبما يرى لكل واحد من أشخاص الحيوان والنبات أشباهاً كثيرة، فلا يجد شيئاً من ذلك. وكان يرى البحر قد أحدق بالجزيرة من كل جهة، فيعتقد أنه ليس في الوجود أرض سوى جزيرته تلك.

واتفق في بعض الاحيان أن انقدحت نار في أجمة قلخ على سبيل المحاكة. فلما بصر بها رأى منظراً هاله، وخلقاً لم يعهده قبل، فوقف يتعجب منها ملياً، ومازال يدنو منها شيئاً فشيئاً، فرأى ما للنار من الضوء الثاقب والفعل الغالب حتى لا تعلق بشيء إلا أتت عليه وأحالته إلى نفسها، فحمله، العجب بها، وبما ركب الله تعالى في طباعه من الجراءة و القوة، على أن يده إليها، وأراد أن يأخذ منها شيئاً فلما باشرها أحرقت يده فلم يستطع القبض عليها فاهتدى إلى أن يأخذ قبساً لم تستول النار على جميعه، فأخذ بطرفه السليم والنار في طرفه الآخر، فتاتي له ذلك وحمله إلى موضعه الذي كان يأوي إليه - وكان قد خلا في جحر استحسنه للسكنى قبل ذلك. ثم مازال يمد تلك النار بالحشيش والحطب الجزل، ويتعهدهاً ليلاً ونهاراً استحساناً منه وتعجباً منها.

وكان يزيد انسه بها ليلاً، لأنها كانت تقوم له مقام الشمس في الضياء و الدفء، فعظم بها ولوعه، واعتقد أنها أفضل الأشياء التي لديه: وكان دائماً يراها تتحرك إلى جهة فوق وتطلب العلو، فغلب على ظنه أنها من جملة الجواهر السماوية التي كان يشاهدها. وكان يختبر قوتها في جميع الأشياء بأن يلقيها فيها، فيراها مستولية عليه أما بسرعة واما ببطء بحسب قوة استعداد الجسم الذي كان يلقيه للاحتراق أو ضعفه. وكان من جملة ما القى فيها على سبيل الاختبار لقوتها، شيء من أصناف الحيوانات البحرية - كان قد ألقاه البحر إلى ساحله - فلما أنضجت ذلك الحيوان وسطع قتاره تحركت شهوته إليه، فأكل منه شيئاً فاستطابه، فاعتاد بذلك أكل اللحم، فصرف الحيلة في صيد البر والبحر، حتى مهر في ذلك. وزادت محبته للنار، إذ تأتي له بها من وجوه الاغتذاء الطيب شيء لم يتأت له قبل ذلك.

فلما اشتد شغفه بها لما رأى من أحسن آثارها وقوة اقتدارها، وقع في نفسه أن الشيء الذي ارتحل من قلب أمه الظبية التي أنشأته، كان من جوهر هذا الوجود أو من شيء يجانسه، وأكد ذلك في ظنه، ما كان يراه من حرارة الحيوان طول مدة حياته، وبرودته من بعد موته، وكل هذا دائم لا يختل، وما كان يجده في نفسه من شدة الحرارة عند صدره، بازاء الموضع الذي كان قد شق عليه من الظبية، فوقع في نفسه أنه لو أخذ حيواناً حياً وشق قلبه ونظر إلى ذلك التجويف الذي صادفه خالياً عندما شق عليه في أمه الظبية، لرأه في الحيوان الحي وهو مملوء بذلك الشيء الساكن فيه وتحقق هل هو من جوهر النار؟ وهل فيه شيء من الضوء والحرارة، آم لا؟ فعمد إلى بعد الوحوش واستوثق منه كتافاً وشقه على الصفة التي شق بها الظبية حتى وصل القلب. فقصد أولاً إلى الجهة اليسرى منه وشقها، فرأى ذلك الفراغ مملوءاً بهواء بخاري، يشبه الضباب الابيض، فأدخل إصبعه فيه، فوجده من الحرارة في حد كاد يحرقه، ومات ذلك الحيوان على الفور.

فصح عنده أن ذلك البخار الحار هو الذي كان يحرك هذا الحيوان، وأن في كل شخص من أشخاص الحيوانات مثل ذلك، ومتى انفصل عن الحيوان مات. ثم تحركت في نفسه الشهوة للبحث عن سائر أعضاء الحيوان وترتيبها وأوضاعها وكميتها وكيفية ارتباط بعضها ببعض، وكيف تستمد من هذا البخار الحار حتى تستمر لها الحياة به، وكيف بقاء هذا البخار المدة التي يبقى، ومن أين يستمد، وكيف لا تنفذ حرارته؟ فتتبع ذلك كله بتشريح الحيوانات الأحياء و الاموات، ولم يزل ينعم النظر فيها ويجيد الفكرة، حتى بلغ في ذلك كله مبلغ كبار الطبيعيين، فتبين له أن كل شخص من أشخاص الحيوان، وان كان كثيراً بأعضائه وتفنن حواسه وحركاته فانه واحد بذلك الروح الذي مبدؤه من قرار واحد، وانقسامه وانقسامه في سائر الأعضاء منبعث منه. وأن جميع الأعضاء إنما هي خادمة له، أو مؤدية عنه، وأن منزلة ذلك الروح في تصريف الجسد، كمنزلة من يحارب الأعداء بالسلاح التام، ويصيد جميع صيد البر والبحر، فيمد لكل جنس آلة يصيده بها والتي يحارب بها تنقسم: إلى ما يدفع به نكيلة غيره، والى ما ينكي بها غيره.

وكذلك آلات الصيد تنقسم: إلى ما يصلح لحيوان البحر، والى ما يصلح لحيوان البر، وكذلك الأشياء التي يشرح بها تنقسم: إلى ما يصلح للشق، والى ما يصلح للكسر، والى ما يصلح للثقب، والبدن الواحد، وهو يصرف ذلك أنحاء من التصريف بحسب ما تصلح له كل آلة، وبحسب الغايات التي تلتمس بذلك التصرف. كذلك؛ ذلك الروح الحيواني واحد، وإذا عمل بالة العين كان فعله أبصاراً، وإذا عمل بآلة الآذن كان فعله سمعاً، وإذا عمل بآلة الآنف كان فعله شماً، وإذا عمل بآلة اللسان كان فعله ذوقاً، وإذا عمل بالجلد واللحم كان فعله لمساً، وإذا عمل بالعضد كان فعله حركه، وإذا عمل بالكبد كان فعله غذاء واغتذاء.

ولكل واحد من هذه، أعضاء تخدمه. ولا يتم لشيء من هذه فعل إلا بما يصل إليها من ذلك الروح، على الطريق التي تسمى عصباً. ومتى انقطعت تلك الطرق أو انسدت، تعطل فعل ذلك العضو. وهذه الأعصاب إنما تستمد الروح من بطون الدماغ يستمد الروح من القلب، والدماغ فيه أرواح كثير، لانه موضع تتوزع فيه أقسام كثيرة: فآي عضو عدم هذا الروح بسبب من الأسباب تعطل فعله وصار بمنزلة الآلة المطرحة، التي يصرفها الفاعل ولا ينتفع بها. فان خرج هذا الروح بجملته عن الجسد، أو فني، أو تحلل بوجه من الوجوه، تعطل الجسد كله، وصار إلى حالة الموت، فانتهى به إلى هذا من منشئه، وذلك أحد وعشرون عاماً.

وفي خلال هذه المدة المذكورة تفنن في وجوه حيله، واكتسى بجلود الحيوانات التي كان يشرحها، واحتذى بها، واتخذ الخيوط من الأشعار ولحا قصب الخطمية والخباري والقنب، وكل نبات ذي خيط. وكان أصل اهتدائه إلى ذلك، أنه أخذ من الحلفاء وعمل خطاطيف من الشوك القوي والقصب المحدد على الحجارة.

واهتدى إلى البناء بما رأى من فعل الخطاطيف فاتخذ مخزناً وبيتاً لفضلة غذائه، وحصن عليه بباب من القصب المربوط بعضه إلى بعض، لئلا يصل إليه شيء من الحيوانات عند مغيبه عن تلك الجهة في بعض شؤونه. واستألف جوانح الطير ليستعين بها في الصيد، واتخذ الدواجن ببيضها وفراخها، واتخذ من الصياصي البقر الوحشية شبه الاسنة، وركبها في القصب القوي، وفي عصي الزان وغيرها، واستعان في ذلك بالنار وبحروف الحجارة، حتى صارت شبه الرماح، واتخذ ترسه من جلود مضاعة: كل ذلك لما رأى من عدمه السلاح الطبيعي. ولما رأى أن يده تفي له بكل ما فاته من ذلك، وكان لا يقاومه شيء من الحيوانات على اختلاف أنواعها، إلا أنها كانت عنه فتعجزه هرباً، فكر في وجه الحيلة في ذلك، فلم ير شيئاً أنجع له من أن يتالف بعض الحيوانات الشديدة العدو، ويحسن إليها بأعداد الغذاء الذي يصلح لها، حتى يتأتى له الركوب عليها ومطاردة سائر الأصناف بها.

وكان بتلك الجزيرة خيل البرية وحمر وحشية، فاتخذ منها ما يصلح له، وراضها حتى كمل بها غرضه، وعمل عليها من الشرك والجلود أمثال الشكائم والسروج فتاتي له بذلك ما امله من طرد الحيوانات التي صعبت عليه الحيلة في أخذها. وانما تفنن في هذه الأمور كلها ف وقت اشتغاله التشريح، وشهوته في وقوفه على خصائص أعضاء الحيوان، وبماذا تختلف، وذلك في المدة التي حددنا منتهاها بأحد وعشرين عاماً. ثم انه بعد ذلك أخذ في مآخذ أخر من النظر، فتصفح جميع الأجسام التي في عالم الكون والفساد: من الحيوانات على اختلاف أنواعها، والنبات والمعادن وأصناف الحجارة والتراب والماء والبخار والثلج والبرد، والدخان واللهيب والجمر، فرأى لها أصوافاً كثيرة وأفعالاً مختلفة، وحركات متفقة ومضادة، وأنعم النظر في ذلك والتثبت، فرأى أنها تتفق ببعض الصفات وتختلف ببعض، وأنها من الجهة التي تتفق بها واحدة، ومن الجهة التي تختلف فيها متغايرة ومتكثرة فكان تارة ينظر خصائص الأشياء وما يتفرد به بعضها عن بعض، فتكثر عنده كثرة تخرج عن الحصر، وينتشر له الوجود انتشار لا يضبط. كل عضو منها فيرى أنه يحتمل القسمة إلى أجزاء كثيرة جداً، فيحكم على ذاته بالكثرة، وكذلك على ذات كل شيء.

ثم كان يرجع إلى نظر آخر من طريق ثان، فيرى أن أعضاءه، وان كانت كثيرة فهي متصلة كلها بعضها ببعض، لا انفصال بينها بوجه، فهي في الحكم الواحد، وأنها لا تختلف إلا بحسب اختلاف أفعالها، أن ذلك الاختلاف إنما هو بسبب ما يصل إليها من قوة الروح الحيواني، الذي انتهى إليه نظره أولاً، وأن ذلك الروح واحد ذاته، وهو حقيقة الذات، وسائر الأعضاء كلها كالآلات، فكانت تتحد عنده ذاته بهذا الطريق.

ثم أنه كان ينتقل إلى جميع أنواع الحيوانات، فيرى كل شخص منها واحداً بهذا النوع من النظر. ثم كان ينظر إلى نوع منها: كالظباء والخيل وأصناف الطير صنفاً صنفاً، فكان يرى أشخاص كل نوع يشبه بعضه بعضاً في الأعضاء الظاهرة والباطنة الادراكات والحركات والمنازع، ولا يرى بينها اختلافاً إلا في أشياء يسيرة بالإضافة إلى ما اتفقت فيه.

وكان يحكم بان الروح الذي لجميع ذلك النوع شيء واحد، وأنه لم يختلف إلا أنه انقسم على قلوب كثيرة، وأنه لو أمكن أن يجمع جميع الذي افترق في تلك القلوب منه ويجعل في وعاء واحد، لكان كله شيئاً واحداً، بمنزلة ماء واحد، أو شراب واحد، يفرق على أوان كثيرة، ثم يجمع بعد ذلك. فهو في حالتي تفريقه وجمعه شيء واحد، إنما الغرض له التكثر بوجه ما، فكان يرى النوع بهذا النظر واحداً، ويجعل كثرة أشخاصه بمنزلة كثيرة أعضاء الشخص الواحد، التي لم تكن كثرة في الحقيقة.

ثم كان يحضر أنواع الحيوانات كلها في نفسه ويتأملها فيراها تتفق في أنها تحس، وتغتذي، وتتحرك بالإرادة إلى أي جهة شاءت، وكان قد علم أن هذه الأفعال هي أخص أفعال الروح الحيواني، وأن سائر الأشياء التي تختلف بها بعد هذا الاتفاق، ليست شديدة الاختصاص بالروح الحيواني. فظهر له بهذا التأمل، أن الروح الحيواني الذي لجميع جنس الحيوان واحد بالحقيقة، وان كان فيه اختلاف يسير، اختص به نوع دون نوع: بمنزلة ماء واحد مقسوم على أوان كثيرة، بعضه أبرد من بعض.

وهو في أصله واحد وكل ما كان في طبقة واحدة من البرودة، فهو بمنزلة اختصاص ذلك الروح الحيواني بنوع واحد، وان عرض له التكثر بوجه ما. فكان يرى جنس الحيوان كله واحداً بهذا النوع من النظر. ثم كان يرجع إلى أنواع النبات على اختلافها. فيرى كل نوع منها تشبه أشخاصه بعضها بعضاً في الأغصان، والورق، والزهر والثمر، والأفعال فكان يقيسها بالحيوان، ويعلم أن لها شيئاً واحداً فيه: هو لها بمنزلة الروح الحيواني وأنها بذلك الشيء واحد. وكذلك كان ينظر إلى جنس النبات كله، فيحكم باتحاده بحسب ما يراه من اتفاق فعله في أنه يتغذى وينمو.

ثم كان يجمع في نفسه جنس الحيوان وجنس النبات، فيراهما جميعاً متفقين في الاغتذاء والنمو، ألا أن الحيوان يزيد على النبات، بفضل الحس والادراك والتحرك؛ وربما ظهر في النبات شيء شبيه به، مثل تحول وجوه الزهر إلى جهة الشمس، وتحرك عروقه إلى الغذاء، بسبب شيء واحد مشترك بينهما، هو في أحدهما أتمم وأكمل، وفي الآخر قد عاقه عائق ما، وأن ذلك بمنزلة ماء واحد قسم بقسمين، أحدهما جامد والآخر سيال، فيتحد عنده النبات والحيوان. ثم ينظر إلى الأجسام التي لا تحس ولا تغتذي ولا تنمو، من الحجارة، والتراب، والماء، والهواء، واللهب، فيرى أنها أجسام مقدر لها الطول وعرض وعمق وأنها لاتختلف، إلا أن بعضها ذو لون وبعضها لا لون له وبعضها حار والآخر بارد، ونحو ذلك من الاختلافات وكان يرى أن الحار منها يصير بارداً، والبارد يصير حار وكان يرى الماء يصير بخاراً والبخار ماء، والأشياء المحترقة تصير جمراً، ورماداً، ولهيباً، ودخاناً، والدخان إذا وافق في صعوده قبة حجر انعقد فيه وصار بمنزلة سائر الأشياء الأرضية، فيظهر له بهذا التأمل، أن جميعها شيء واحد في الحقيقة، وان لحقتها الكثرة بوجه ما، فذلك مثل ما لحقت الكثرة للحيوان والنبات.

ثم ينظر إلى الشيء الذي اتحد به عند النبات والحيوان، فيرى أنه جسم ما مثل هذه الأجسام: له طول وعرض وعمق، وهو إما حار واما بارد، كواحد من هذه الأجسام التي لا تحس ولا تتغذى، وانما خالفها بأفعاله التي تظهر عنه بالآلات الحيوانية والنباتية لا غير، ولعل تلك الأفعال ليست ذاتية، وانما تسري إليه من شيء آخر ولو سرت إلى هذه الأجسام الآخر، لكانت مثله فكان ينظر إليه بذاته مجرداً عن هذه الأفعال، التي تظهر ببادئ الرأي، أنها صادرة عنه، فكان يرى أنه ليس إلا جسماً من هذه الأجسام، فيظهر له بهذا التأمل، أن الأجسام كلها شيء واحد: حيها وجمادها، متحركها وساكنها، إلا أنه يظهر أن لبعضها أفعالاً بالات، ولا يدري هل تلك الأفعال ذاتية لها، أو سارية أليها من غيرها. وكان في هذه الحال لا يرى شيئاً غير الأجسام فكان بهذا الطريق يرى الوجود كله شيئاً واحداً، وبالنظر الأول كثرة لا تنحصر ولا تتناهى. وبقي بحكم هذه الحالة مدة.

ثم انه تأمل جميع الأجسام حيها وجامدها. وهي التي هي عنده تارةً شيء واحد وتارةً كثيرة كثرة لا نهاية لها، فرأى إن كل واحد منها، لا يخلو من أحد أمرين: إما أن يتحرك إلى جهة العلو مثل الدخان واللهيب والهواء، إذا حصل تحت الماء واما أن يتحرك إلى الجهة المضادة لتلك الجهة، وهي جهة السفل، مثل الماء، وأجزاء الحيوان و النبات، وأن كل جسم من هذه الأجسام لن يعرى عن إحدى هاتين الحركتين وأنه لا يسكن إلا إذا منعه مانع يعوقه عن طريقه، مثل الحجر النازل يصادف وجه الأرض صلباً، فلا يمكن أن يخرقه، ولو أمكنه ذلك لما انثنى عن حركته فيما يظهر، ولذلك إذا رفعته، وجدته يتحامل عليك بميله إلى جهة السفل، طالباً للنزول. وكذلك الدخان في صعوده، لا ينثني إلا أن يصادف قبة صلبة تحبسه، فحينئذً ينعطف يميناً وشمالاً ثم إذا تخلص من تلك القبة، خرق الهواء صاعداً لأن الهواء لا يمكنه أن يحبسه.

وكان يرى إن الهواء إذا ملئ به زق جلد، وربط ثم غوص تحت الماء طلب الصعود وتحامل على من يمسكه تحت الماء، ولا يزال يفعل ذلك حتى يوافي موضع الهواء، وذلك بخروجه من تحت الماء فحينئذً يسكن ويزول عنه ذلك التحامل والميل إلى جهة العلو الذي كان يوجد منه قبل ذلك. ونظر هل يجد جسماً يعرى عن إحدى هاتين الحركتين أو الميل إلى إحداهما في الوقت ما؟ فلم يجد ذلك في الأجسام التي لديه، وانما طلب ذلك، لانه طمع أن يجده، فيرى طبيعة الجسم من حيث هو جسم، دون أن تقترن به وصف من الأوصاف، التي هي منشأ التكثر. فلما أعياه ذلك ونظر إلى الأجسام التي هي أقل الأجسام حملاً للأوصاف فلم يرها تعرى عن أحد هذين الوصفين بوجه، وهما اللذان يعبر عنهما بالثقل والخفة فنظر إلى الثقل والخفة، هل هما للجسم من حيث هو جسم؟ أو هما لمعنى زائد على الجسمية؟ فظهر له أنهما لمعنى زائد على الجسمية لانهما لو كانا للجسم من حيث هو جسم، لما وجد إلا وهما له.

ونحن نجد الثقيل لا توجد فيه الخفة، والخفيف لا يوجد فيه الثقل، وهما لا محالة جسمان ولكل واحد منهما معنى منفرد به عن الأخر زائد على جسميته. وذلك المعنى، الذي به غاير كل واحد منهما الآخر، ولولا ذلك لكانا شيئاً واحداً من جميع الوجوه.

فتبين له أن حقيقة كل واحد من الثقيل والخفيف، مركبة من معنيين: أحدهما ما يقع فيه الاشتراك منهما جميعاً، وهو معنى الجسمية؛ والآخر ما تنفرد به حقيقة كل واحد منهما على الاخر، وهما أما الثقل في احدهما واما الخفة في الاخر، المقترنان بمعنى الجسمية، أي المعنى الذي يحرك أحدهما الأخر علواً والأخر سفلاً. وكذلك نظر إلى سائر الأجسام من الجمادات والأحياء، فرأى أن حقيقة وجود كل واحد منهما مركبة من معنى الجسمية، ومن شيء أخر زائد على الجسمية: أما واحد، واما أكثر من واحد؛ فلاحت له صور الأجسام على اختلافها وهو أول ما لاح له من العالم الروحاني، اذ هي صور لا تدرك بالحس، وانما تدرك بضرب ما من النظر العقلي.

ولاح له في جملة ما لاح من ذلك، أن الروح الحيواني الذي مسكنه القلب - وهو الذي تقدم شرحه أولاً - لابد له أيضاً من معنى زائد على جسميته يصلح بذلك المعنى لأن يعمل هذه الأعمال الغريبة، التي تختص به من ضروب الاحساسات، وفنون الادراكات وأصناف الحركات، وذلك المعنى هو صورته وفضله الذي انفصل به عن سائر الأجسام، وهو الذي يعبر عنه النظار بالنفس الحيوانية. وكذلك ايضاً للشيء الذي يقوم للنبات مقام الحار الغريزي للحيوان، شيء يخصه هو صورته، وهو الذي يعبر عنه النظار بالنفس النباتية. وكذلك لجميع الأجسام الجمادات: وهي ما عدا الحيوان والنبات مما في عالم الكون والفساد شيء يخصها به، يفعل كل واحد منها فعله الذي يختص به مثل صنوف الحركات وضروب الكيفيات المحسوسة عنها، وذلك الشيء هو صورة كل واحد منها، وهو الذي يعبر النظار عنه بالطبيعة.

فلما وقف بهذا النظر على ان حقيقة الروح الحيواني، الذي كان تشوقه اليه ابداً، مركبة من معنى الجسمية، ومن معنى أخر زائد على الجسمية، وان معنى الجسمية مشترك، ولسائر الأجسام، والمعنى الأخر المقترن به هو وحده، هان عنده معنى الجسمية فاطرحه، وتعلق فكره بالمعنى الثاني، وهو الذي يعبر عنه النفس؛ فتشوق إلى التحقق به فالتزم الفكرة فيه، وجعل مبدأ النظر في ذلك تصفح الأجسام كلها، لا من جهة ما هي أجسام، بل من وجهة ما هي ذوات صور تلزم عنها خواص، ينفصل بها بعضها ببعض. فتتبع ذلك وحصره في نفسه، فرأى جملة من الأجسام، تشترك في صورة ما يصدر عنها فعل ما، أو أفعال ما، ورأى فريقاً من تلك الجملة، مع أنه يشارك الجملة بتلك الصورة، يزيد عليها بصورة أخرى، يصدر عنها ما، ورأى طائفة من ذلك الفريق، مع أنها تشارك الفريق في الصورة الأولى والثانية، تزيد عليه بصوره ثالثة، تصدر عنها أفعال ما خاصة بها. مثال ذلك: إن الأجسام الأرضية، مثل التراب والحجارة والمعادن والنبات والحيوان، وسائر الأجسام الثقيلة، وهي جملة واحدة تشترك في صورة واحدة تصدر عنها الحركة إلى الأسفل، ما لم يعقها عائق عن النزول: ومتى تحركت إلى جهة العلو بالقسر ثم تركت، تحركت بصورتها إلى الأسفل. وفريق من هذه الجملة، وهو النبات والحيوان، مع مشاركة الجملة المتقدمة في تلك الصورة، يزيد عليها صورة أخرى، يصدر عنها التغذي والنمو. والتغذي: هو أن يخلف المتغذي، بدل ما تحلل منه، بان يحيل إلى ما التشبه بجوهره مادة قريبة منه، يجتذبها إلى نفسه.

والنمو: هو الحركة في الأقطار الثلاثة، على نسبة محفوظة في الطول والعرض والعمق.

فهذان الفعلان عامان للنبات والحيوان، وهما لا محالة صادران عن صورة مشتركة لهما، وهي المعبر عنها بالنفس النباتية. وطائفة من هذا الفريق، وهو الحيوان خاصة، مع مشاركته الفريق المتقدم في الصورة الأولى والثانية، تزيد عليه بصورة ثالثة، يصدر عنها الحس والتنقل من حين إلى أخر. ورأى أيضاً كل نوع من أنواع الحيوان، له خاصية ينحاز بها عن سائر الأنواع، وينفصل بها متميزاً عنها. فعلم إن ذلك صادر عن صورة له تخصه هي زائدة عن معنى الصورة المشتركة له ولسائر الحيوان، وكذلك لكل واحد من أنواع النبات مثل ذلك. فتبين له إن الأجسام المحسوسة التي في عالم الكون والفساد، بعضها تلتئم حقيقته من معان كثيرة، زائدة على معنى الجسمية، وبعضها من معان اقل؛ وعلم إن معرفة الأقل أسهل من معرفة الأكثر؛ فطلب أولاً الوقوف على الحقيقة لشيء الذي تلتئم حقيقته من اقل الأشياء، ورأى إن الحيوان والنبات، لا تلتئم حقائقها إلا من معان كثيرة، لتفنن أفعالها؛ فأخر التفكير في صورهما. وكذلك رأى إن أجزاء الأرض بعضها ابسط من بعض، فقصد منها إلى ابسط ما قدر عليه وكذلك رأى إن الماء شيء قليل التركيب، لقلة ما يصدر عن صورته من أفعال، وكذلك راى النار والهواء. وكان قد سبق إلى ظنه أولاً، أن هذه الأربعة يستحيل بعضها إلى بعض، وان لها شيئاً واحداً تشترك فيه، وهو معنى الجسمية، وان ذلك الشيء ينبغي إن يكون خلواً من المعاني التي تميز بها كل واحد من هذه الأربعة عن الأخر، فلا يمكن أن يتحرك إلى فوق ولا إلى اسفل، ولا إن يكون حاراً ولا يكون بارداً، ولا يكون رطباً، ولا يابساً، لان كل واحد من هذه الاوصاف، لا يعم جميع الأجسام، فليست إذن للجسم بما هو جسم.

فإذا أمكن وجود جسم لا صورة فيه زائدة على الجسمية، فليس تكون فيه صفة من هذه الصفات، ولا يمكن إن تكون فيه صفة إلا وهي تعم سائر الأجسام المتصورة، بضروب الصور. فنظر هل يجد وصفاً واحداً يعم جميع الأجسام: حيها وجمادها، فلم يجد شيئاً يعم الأجسام كلها. إلا معنى الامتداد الموجود في جميعها في الأقطار الثلاثة، التي يعبر عنها بالطول، والعرض، والعمق، فعلم هذا المعنى هو للجسم من حيث هو جسم، لكنه لم يتأت له بالحس وجود جسم بهذه الصفة وحدها، حتى لا يكون فيه معنى زائد على الامتداد المذكور ويكون بالجملة خلواً من سائر الصور. ثم تفكر في هذا الامتداد إلى الأقطار الثلاثة، هل هو معنى الجسم بعينه، وليس ثم معنى أخر أو ليس الأمر كذلك، فرأى أن وراء هذا الامتداد معنى أخر، هو الذي يوجد فيه هذا الامتداد، وان الامتداد وحده لا يمكن إن يقوم بنفسه كما إن ذلك الشيء الممتد، لا يمكن أن تقوم دون امتداد. واعتبر ذلك ببعض هذه الأجسام المحسوسة ذوات الصور، كالطين مثلاً، كان له طول وعرض وعمق على قدر ما.

ثم إن تلك الكرة بعينها لو أخذت وردت إلى شكل مكعب أو بيض، لتبدل ذلك الطول وذلك العرض وذلك العمق، وصارت على قدر أخر. غير الذي كانت عليه، والطين واحد بعينه لم يتبدل، غير أنه لا بد له من طول وعرض وعمق على أي قدر كان، ولا يمكن إن يعرى عنها؛ غير أنها لتعاقبها عليه، تبين له أنها معنى على حياله؛ ولكونه لا يعرى بالجملة عنها، تبين له أنها من حقيقة. فلاح له بهذا الاعتبار، إن الجسم، بما هو جسم، مركب على الحقيقة من معنين: أحدهما يقوم منه مقام الطين للكرة في هذا المثال. والأخر: يقوم مقام طول الكرة وعرضها وعمقها، أو المكعب، أو أي شكل كان له. وانه لا يفهم الجسم إلا مركباً من هذين المعنين، وان احدهما لا يستغني عن الأخر. ولكن الذي يمكن أن يتبدل ويتعاقب على أوجه كثيرة، وهو معنى الامتداد يشبه الصورة التي لسائر الأجسام ذوات الصور، والذي يثبت على حال واحدة، وهو الذي ينزل منزلة الطين في المثال المتقدم، يشبه معنى الجسمية التي لسائر الأجسام ذوات الصور.

وهذا الشيء الذي هو بمنزلة الطين في هذا المثال هو الذي يسميه النظار المادة والهيولى وهي عارية عن الصورة جملة. فلما نظره إلى هذا الحد، وفارق المحسوس بعض مفارقة، وأشرف على تخوم العالم العقلي، استوحش وحن إلى ما ألفه من عالم الحس، فتقهقر قليلاً وترك الجسم على الإطلاق، إذ هو أمر لا يدركه الحس، ولا يقدر على تناوله. فاخذ أبسط الأجسام المحسوسة التي شاهدها، وهي تلك الأربعة التي كان قد وقف نظره عليها.

فأول ما نظر إلى الماء فرأى انه إذا خلي وما تقتضيه صورته، ظهر منه برد محسوس، وطلب النزول إلى اسفل فإذا سخن أما بالنار واما بحرارة الشمس، زال عنه البرد أولاً وبقي فيه طلب النزول، فإذا أفرط عليه بالتسخين، زال عنه طلب النزول إلى اسفل. وصار يطلب الصعود إلى فوق. فزال عنه بالجملة الوصفان اللذان كانا أبداً يصدران عن صورته، ولم يعرف من صورته أكثر من صدور هذين الفعلين عنها. فلما زال هذان الفعلان بطل حكم الصورة، فزالت الصورة المائية عن ذلك الجسم عندما ظهرت منه أفعال من شأنها أن تصدر عن صورة أخرى، وحدثت له صورة أخرى، بعد أن لم تكن، وصدر عنه بها أفعال لم يكن من شأنها أن تصدر عنه وهو بصورته الأولى. فعلم بالضرورة أن كل حادث لا بد له من محدث. فارتسم في نفسه بهذا الاعتبار، فاعل للصورة، ارتساماً على العموم دون تفصيل. ثم أنه تتبع الصور التي كان قد عاينها قبل ذلك، صورة صورة، فرأى أنها كلها حادثة، وأنها لا بد لها من فاعل. ثم نظر إلى ذوات، الصور، فلم ير أنها شيء أكثر من استعداد الجسم لان يصدر عنه ذلك الفعل، مثل الماء، فانه إذا افرط عليه التسخين، استعد للحركة إلى فوق وصلح لها.

فذلك الاستعداد هو صورته، إذ ليس ها هنا إلا جسم وأشياء تحس عنه، بعد أن لم تكن؛ فصلوح الجسم لبعض الحركات دون بعض، واستعداده بصورته، ولاح له مثل ذلك في جميع الصور، فتبين له أن الأفعال الصادرة عنها، ليست في الحقيقة لها، وانما هي لفاعل يفعل بها الأفعال المنسوبة إليها؛ وهذا المعنى الذي لاح له، هو قول الرسول الله عليه الصلاة والسلام: "كنت سمعه الذي يسمع به وبصره الذي يبصر به" وفي محكم التنزيل: "بسم الله الرحمن الرحيم" فان تقتلوهم ولكن الله قتلهم؛ وما رميت إذا رميت، ولكن الله رمى! صدق الله العظيم. فلما لاح له من أمر هذا الفاعل، ما لاح على الإجمال دون تفصيل، حدث له شوق حثيث إلى معرفته على التفصيل، ولانه لم يكن بعد فارق عالم الحس، جعل يطلب هذا الفاعل على جهة المحسوسات، وهو لا يعلم بعد هل هو واحد أو كثير؟ فتصفح جميع الأجسام التي لديه، وهي التي كانت فكرته أبداً فيها، فرأها كلها تتكون تارة وتفسد أخرى، وما لم يقف على فساد جملته، وقف على الفساد أجزائه مثل الماء والأرض، فانه راى أجزاءهما تفسد بالنار، وكذلك الهواء رآه يفسد بشدة البرد، حتى بتكون منه الثلج فيسيل ماء. وكذلك سائر الأجسام التي كانت لديه، ولم ير منها شيئاً بريئاً عن الحدوث والافتقار إلى الفاعل المختار، فاطرحها كلها وانتقلت فكرته إلى الأجسام السماوية.

وانتهى إلى هذا النظر على رأس أربعة أسابيع من منشئه، وذلك ثمانية وعشرون عاماً. فعلم إن السماء وما فيها من كواكب الأجسام، لأنها ممتدة في الأقطار الثلاثة: الطول، والعرض، والعمق؛ لا ينفك شيء منها عن هذه الصفة، وكل ما لا ينفك عن هذه الصفة، فهو جسم؛ فهي إذن كلها أجسام. ثم تفكر هل هي ممتدة إلى ما لا نهاية، وذاهبة أبداً في الطول والعرض والعمق إلى ما لا نهاية، أو هي متناهية محدودة بحدود تنقطع عندها، ولا يمكن أن يكون وراءها شيء من الامتداد؟ فتحير بعد ذلك بعض الحيرة. ثم انه بقوة فطرته، وذكاء خاطره، راى أن جسماً لا نهاية له أمر باطل، وشيء لا يمكن، ومعنى لا يعقل، وتقوى هذا الحكم عنده بحجج كثيرة، سنحت له بينه وبين نفسه وذلك أنه قال: أما الجسم السماوي فهو متناه من الجهة التي تليني والناحية التي وقع عليها حسي، فهذا لا شك فيه لأنني أدركه ببصر، وأما الجهة التي تقابل هذه الجهة، وهي التي يداخلني فيها الشك، فاني أيضاً أعلم من المحال أن تمتد إلى غير نهاية، لأني إن تخيلت أن خطين اثنين، يبتدئان من هذه الجهة المتناهية، ويمران في سمك الجسم إلى غير نهاية حسب امتداد الجسم، ثم تخيلت أن أحد هذين الخطين، قطع منه جزء كبير من ناحية طرفه المتناهي، ثم أخذ ما بقي منه شيء واطبق الخط المقطوع منه على الخط الذي لم يقطع منه شيء، وذهب الذهن كذلك معهما إلى الجهة التي يقال إنها غير متناهية، فأما أن نجد خطين أبداً يمتدان إلى غير نهاية ولا ينقص أحدهما عن الأخر، فيكون الذي قطع منه جزء مساوياً للذي لم يقطع منه شيء وهو محال، كما أن الكل مثل الجزء المحال؛ واما أن لا يمتد الناقص معه ابداً، بل ينقطع دون مذهبه ويقف عن الامتدادمعه، فيكون متناهياً، فإذا رد عليه القدر الذي قطع منه أولاً، وقد كان متناهياً، صار كله أيضاً متناهياً، وحينئذ لا يقصر عن الخط الأخر الذي يقطع منه شيء، ولا يفضل عليه فيكون إذن مثله وهو متناه، فذلك أيضاً متناه، فالجسم الذي تفرض فيه هذه الخطوط متناه، وكل جسم يمكن أن تفرض فيه هذه الخطوط، فكل جسم متناه.

فإذا فرضنا أن جسماً غير متناه، فقد فرضنا باطلاً ومحالاً. فلما صح عنده بفطرته الفائقة التي لمثل هذه الجهة، أن جسم السماء متناه، أراد أن يعرف على أي شكل هو، وكيفية انقطاعه بالسطوح التي تحده. فنظر أولاً إلى الشمس والقمر وسائر الكواكب، فرأها كلها تطلع من جهة المشرق، وتغرب من جهة المغرب، فما كان يمر على سمت رأسه، رأه يقطع دائرة عظمى، وما مال عن سمت رأسه إلى الشمال أو إلى الجنوب، رأه يقطع دائرة أصغر من تلك. وما كان أبعد عن سمت الرأس إلى أحد الجانبين، كانت دائرته أصغر من دائرة ما هو أقرب. حتى كانت أصغر الدوائر التي تتحرك عليها الكواكب، دائرتين اثنتين: إحداهما حول القطب الجنوبي، وهي مدار سهيل، والاخرى حول القطب الشمالي، وهي المدار الفرقدين. ولما كان مسكنه على خط الاستواء الذي وصفناه أولاً، كانت هذه الدوائر كلها على سطح آفة. ومتشابهة في الجنوب والشمال وكان القطبان معاً ظاهرين له، وكان يترقب إذا طلع كوكب من الكواكب على دائرة كبيرة، وطلع كوكب آخر على دائرة صغيرة، وكان طلوعهما معاً، فكان يرى غروبهما معاً. واطرد له في ذلك جميع الكواكب وفي جميع الأوقات، فتبين له بذلك أن الفلك على شكل الكرة، وقوى ذلك في اعتقاده، ما رآه من رجوع الشمس والقمر وسائر الكواكب إلى المشرق، بعد مغيبها بالمغرب، وما رآه أيضاً من أنها تظهر لبصره على قدر واحد من العظم في حال طلوعها وتوسطها وغروبها، وأنها لو كانت حركتها على غير شكل الكرة لكانت لا محالة في بعض الأوقات، أقرب إلى بصره منها في وقت آخر، ولو كانت كذلك، لكانت مقاديرها واعظامها تختلف عند بصره فيراها في حال القرب أعظم مما يراها في حال البعد، لاختلاف أبعادها عن مركزه حينئذ بخلافها على الأول.

فلما لم يكن شيء من ذلك؛ تحقق عنده كروية الشكل. وما زال يتصفح حركة القمر، فيراها آخذه من المغرب إلى المشرق وحركات الكواكب السيارة كذلك، حتى تبين له قدر كبير من علم الهيئة، وظهر له أن حركتها لا تكون إلا بأفلاك كثيرة، كلها مضمنة في فلك واحد، هو أعلاها. وهو الذي يحرك الكل من المشرق إلى المغرب في اليوم والليلة. وشرح كيفية انتقاله. ومعرفة ذلك يطول؛ وهو مثبت في الكتب، ولا يحتاج منه في غرضنا إلا للقدر الذي أردناه. فلما انتهى إلى هذه المعرفة، ووقف على أن الفلك بجملته وما يحتوي عليه، كشيء واحد متصل بعضه ببعض، وأن جميع الأجسام التي كان ينظر فيها أولاً: كالأرض والماء والهواء والنبات والحيوان وما شاكلها، هي كلها في ضمنه وغير خارجة عنه، وأنه كله أشبه شيء بشخص من أشخاص الحيوان؛ وما فيه من الكواكب المنيرة هي بمنزلة حواس الحيوان؛ وما فيه من ضروب الأفلاك، المتصل بعضها ببعض، هي بمنزلة أعضاء الحيوان؛ وما في داخله من الكون والفساد هي بمنزلة ما في جوف الحيوان من أصناف الفضول والرطوبات، التي كثيراً ما يتكون فيها أيضاً حيوان، كما يتكون في العالم الأكبر. فلما تبين له أنه كله كشخص واحد في الحقيقة، واتحدت عنده أجزاؤه الكثيرة بنوع من النظر الذي اتحدت به عنده الأجسام التي في عالم الكون والفساد، تفكر في العالم بجملته، هل هو شيء حدث بعد إن لم يكن، وخرج إلى الوجود بعد العدم؟ أو هو أمر كان موجوداً فيما سلف، ولم يسبقه العدم بوجه من الوجوه؟ فتشك في ذلك ولم يترجح عنده أحد الحكمين على الآخر. وذلك أنه كان إذا أزمع على اعتقاد القدم، اعترضه عوارض كثيرة، من استحالة وجود ما لا نهاية له، بمثل الذي استحال عنده به وجود جسم لا نهاية وكذلك أيضاً كان يرى أن هذا الوجود لا يخلو من الحوادث، فهو لا يمكن تقدمه عليها، وما لا يمكن أن يتقدم على الحوادث، فهو أيضاً محدث. وإذا أزمع على اعتقاد الحدوث، اعترضته عوارض أخرى، وذلك أنه كان يرى أن معنى حدوثه، بعد أن لم يكن لا يفهم إلا على أن الزمان تقدمه، والزمان من جملة العالم وغير منفك عنه، فإذن لا يفهم تأخر العالم عن الزمان. وكذلك أيضاً كان يقول: إذا كان حادثاً، فلا بد له من محدث؛ وهذا المحدث الذي أحدثه، لم أحدثه الآن ولم يحدثه قبل ذلك، الطارئ طرأ عليه ولا شيء هناك غيره، أم لتغير حدث في ذاته؟ فان كان فما الذي احدث ذلك التغيير؟ وما زال يتفكر في ذلك عدة سنين.

فتتعارض عنده الحجج، ولا يترجح عنده أحد الاعتقادين على الآخر. فلما أعياه ذلك، جعل يتفكر ما الذي يلزم عن كل واحد من الاعتقادين، فلعل اللازم عنهما يكون شيئاً واحداً. فرأى انه إن اعتقد حدوث العالم خروجه إلى الوجود بعد العدم، فاللازم عن ذلك ضرورة، انه لا يمكن أن يخرج إلى الوجود بنفسه، وانه لا بد له من فاعل يخرجه إلى الوجود، وان ذلك الفاعل لا يمكن إن يدرك بشيء من الحواس، لانه لو أدرك بشيء من الحواس لكان جسماً من الأجسام، ولو كان جسماً من الأجسام لكان من جملة العالم، وكان حادثاً واحتاج إلى محدث، ولو كان ذلك المحدث الثاني أيضاً جسماً، لحتاج إلى محدث ثالث، والثالث إلى رابع، ويتسلسل ذلك إلى غير نهايةً وهو باطل. فإذن لابد للعالم من فاعل ليس بجسم، وإذا لم يكن جسماً فليس إلى إدراكه لشيء من الحواس سبيل، الآن الحواس الخمس لا تدرك إلا الأجسام، وإذا لا يمكن أن يحس فلا يمكن أن يتخيل، لان التخيل ليس شيئاً إلا إحضار صور المحسوسات بعد غيبتها، وإذا لم يكن جسماً فصفات الأجسام كلها تستحيل عليه، وأول صفات الأجسام هو الامتداد في الطول والعرض والعمق، وهو منزه عن ذلك، وعن جميع ما يتبع هذا الوصف من صفات الأجسام. وإذا كان فاعلاً للعالم فهو لا محالة قادر عليه وعالم به "بسم الله الرحمن الرحيم" إلا يعلم من خلق، وهو اللطيف الخبير؟ صدق الله العظيم. وراى أيضاً انه إن اعتقد قدم العالم، وان العدم لم يسبقه، وانه لم يزل كما هو، فان اللازم عن ذلك أن حركته قديمة لا نهاية لها من جهة الابتداء، إذ لم يسبقها سكون يكون مبدؤها منه، وكل حركة فلابد لها من محرك ضرورة، والمحرك أما أن يكون قوة سارية في جسم من الأجسام - أما جسم المتحرك نفسه، واما جسم أخر خارج عنه - واما أن تكون قوة ليست سارية ولا شائعة قي جسم. وكل قوى سارية في جسم وشائعه فيه، فانها تنقسم بانقسامه، وتتضاعف بتضاعفه، مثل الثقل بالحجر مثلاً. المحرك إلى الأسفل.

فانه إن قسم الحجر نصفين. وان زيد عليه أخر مثله، زاد في الثقل أخر مثله، فان أمكن أن يتزايد الحجر إلى غير نهاية، كتزايد هذا الثقل إلى غير نهاية، وان وصل الحجر إلى حد ما من العظم ووقف، وصل الثقل إلى ذلك الحد ووقف، لكنه قد تبرهن أن كل جسم فانه لا محالة متناه، فإذن كل قوة في الجسم فهي لا محالة متناهية. فان وجدناها قوة تفعل فعلاً لا نهاية له، فهي قوة ليست في جسم، وقد وجدنا الفلك يتحرك أبداً حركة لانهاية لها ولا انقطاع إذ فرضناه قديماً لا ابتداء له فالواجب على ذلك أن تكون القوة التي تحرك ليست في جسمه، ولا في جسم خارج عنه. فهي إذا لشيء بريء عن الأجسام، وغير موصوف بشيء من أوصاف الجسمية، وقد كان لاح له في نظره الأول في عالم الكون والفساد إن حقيقة وجود كل جسم، إنما هي من جهة صورته التي هي استعداده لضروب الحركات، وان وجوده الذي له من جهة مادته وجود ضعيف لا يكاد يدرك؛ فان وجود العالم كله إنما هو من جهة استعداده لتحريك هذا المحرك البريء عن المادة، وعن صفات الأجسام، المنزه عن أن يدركه حس، أو يتطرق إليه خيال، سبحانه، وإذا كان فاعلاً لحركات الفلك على اختلاف أنواعها، فعلاً لا تفاوت فيه ولا فتور فيه ولا قصور، فهو لا محالة قادر عليها وعالم بها.

فانتهى نظره بهذا الطريق إلى ما انتهى إليه بالطريق الأول، ولم يضره في ذلك تشككه في قدم العالم أو حدوثه، وصح له على الوجهين جميعاً وجود فاعل غير الجسم، ولا متصل بجسم ولا منفصل عنه، ولا داخل فيه، ولا خارج عنه، إذ: الاتصال، والانفصال، والدخول، هي كلمات من صفات الأجسام، وهو منزه عنها. ولما كانت المادة في كل جسم مفتقرة إلى الصورة، إذ لا تقوم إلا بها ولا تثبت لها حقيقة دونها، وكانت الصورة لا يصح وجودها إلا من فعل هذا الفاعل تبين له افتقار جميع الموجودات في وجودها إلى هذا الفاعل وأنه لا قيام لشيء منها إلا به فهو إذن علة لها، وهي معلومة له، سواء كانت محدثة الوجود، بعد أن سبقها العدم، أو كانت الابتداء لها من جهة الزمان، ولم يسبقها العدم قط، فانها على كلا الحالتين معلولة، ومفتقرة إلى الفاعل، متعلقة الوجود به، ولولا دوامه لم تدم، ولولا وجوده لم توجد، ولولا قدمه لم تكن قديمة، وهو في ذاته غني عنها وبريء منها! وكيف لا يكون كذلك وقد تبرهن أن قدرته غير متناهية، وأن جميع الأجسام وما يتصل بها أو يتعلق بها، ولو بعض التعلق، هو متناه منقطع. فإذن العالم كله بما في السماوات والأرض والكواكب، وما بينها، وما فوقها، وما تحتها، فعله وخلقه؛ ومتأخر عليه بالذات، وان كانت غير ماخرة عليها بالزمان. كما انك إذا أخذت في قبضتك جسماً من الأجسام، ثم حركت يدك، فان ذلك الجسم لا محالة يتحرك تابعاً لحركة يدك، حركة متأخرة عن حركة يدك، تأخراً بالذات؛ وان كانت لم تتأخر بالزمان عنها، بل كان ابتداؤهما معاً، فكذلك العالم كله، معلول ومخلوق لهذا الفاعل بغير زمان "بسم الله الرحمن الرحيم" إنما أمره إذا أراد شيئاً أن يقول له كن فيكون صدق الله العظيم. فلما راى إن جميع الموجودات فعله، تصفحها من بعد ذا تصفحاً على طريق الاعتبار في قدرة فاعلها؛ والتعجب من غريب صنعته، ولطيف حكمته، ودقيق علمه فتبين له في اقل الأشياء الموجودة، فضلاً عن أكثرها من أثار الحكمة، وبدائع الصنعة، ما قضى منه كل العجب، وتحقق عنده إن ذلك لا يصدر إلا عن فاعل مختار في غاية الكمال وفوق الكمال "بسم الله الرحمن الرحيم" لا يغرب عنه مثقال ذرة في السموات ولا في الأرض ولا اصغر من ذلك ولا أكبر صدق الله العظيم.

ثمتأمل في جميع أصناف الحيوان، كيف "بسم الله الرحمن الرحيم" أعطى كل شيء خلقه، ثم هداه صدق الله العظيم لاستعماله، فلولا أنه هداه لاستعمال تلك الأعضاء التي خلقت له في وجوه المنافع المقصود بها، لما انتفع بها الحيوان، وكانت كلاً عليه، فعلم بذلك أنه أكرم الكرماء، وارحم الرحماء. من فيض ذلك الفاعل المختار - جل جلاله - ومن وجوده، ومن فعله، فعلم أن الذي هو في ذاته أعظم منها، وأكمل، واتمم وأحسن، وأبهى وأجمل وأدوم، وأنه لا نسبة لهذه إلى تلك. فما زال يتتبع صفات الكمال كلها، فيراها له وصادرة عنه، ويرى أنه أحق بها من كل ما يوصف بها دونه. وتتبع صفات النقص كلها فرآه بريئاً منها، ومنزهاً عنها؛ وكيف لا يكون بريئاً منها وليس معنى النقص إلا العدم المحض، أو ما يتعلق بالعدم؟ وكيف يكون العدم تعلق أو تلبس، بمن هو الموجود المحض، الواجب الوجود بذاته، المعطي لكل ذي وجود وجوده، فلا وجود إلا هو: فهو الوجود، وهو الكمال، وهو التمام، وهو الحسن، وهو البهاء، وهو القدرة، وهو العلم، وهو هو، و "بسم الله الرحمن الرحيم" كل شيء هالك إلا وجهه صدق الله العظيم. فانتهت به المعرفة إلى هذا الحد، على رأس خمسة أسابيع من منشئه، وذلك خمسة وثلاثون عاماً، وقد رسخ في قلبه من هذا الفاعل، ما شغله عن الفكرة في كل شيء إلا فيه، وذهل عما كان فيه تصفح الموجودات والبحث عنها، حتى صار بحيث لا يقع بصره على شيء من الأشياء، إلا ويرى فيه أثر الصنعة، ومن حينه، فينتقل بفكره على الفور إلى الصانع ويترك المصنوع، حتى اشتد شوقه إليه، وانزعج قلبه بالكلية عن العالم الأدنى المحسوس، وتعلق بالعالم الأرفع المعقول. فلما حصل له العلم بهذا الموجود الرفيع الثابت الوجود الذي لا سبب لوجود جميع الأشياء، أراد أن يعلم بأي شيء حصل له هذا العالم، وبأي قوة أدرك هذا الموجود: فتصفح حواسه كلها وهي: السمع، والبصر، والشم، والذوق، واللمس، فرأى أنها لا تدرك شيئاً إلا جسماً، أو ما هو في الجسم، وذلك أن السمع لا يدرك المسموعات، وهي ما يحدث من تموج الهواء عند تصادم الأجسام، والبصر إنما يدرك الألوان، والشم يدرك الروائح، والذوق يدرك الطعوم، واللمس يدرك الأمزجة والصلابة واللين، والخشونة والملاسة، وكذلك القوة الخيالية لا تدرك شيئاً إلا أن يكون له طول وعرض وعمق؛ وهذه المدركات كلها من صفات الأجسام، وليس لهذه الحواس أدراك شيء سواها، وذلك لأنها قوى شائعة في الأجسام، ومنقسمة بانقسامها، فهي لذلك لا تدرك إلا جسماً منقسماً، لان هذه القوة إذا كانت شائعة في شيء منقسم، فلا محالة أنها إذا أدركت شيئاً من الأشياء، فانه ينقسم بانقسامها؛ فإذن كل قوة في جسم، فانها لا محالة لا تدرك إلا جسماً أو ما هو جسم.

وقد تبين إن هذا الموجود الواجب الوجود، بريء من صفات الأجسام من جميع الاتجاهات، فإذن لا سبيل إلى إدراكه إلا بشيء ليس بجسم، ولا هو قوة في جسم، ولا تعلق له وجه من الوجوه بالأجسام، ولا هو داخل فيها ولا خارج عنها، ولا متصل بها ولا منفصل عنها. وقد كان تبين له أن أدركه بذاته، ورسخت المعرفة به عنده، فتبين له بذلك أن ذاته التي أدركه بها أمر غير جسماني، ولا يجوز عليه شيء من صفات الأجسام، وان كل ما يدركه من ظاهر ذاته من الجسمانية فانها ليست حقيقة ذاته، وانما حقيقة ذاته ذلك الشيء الذي أدرك به الموجود المطلق الواجب الوجود. فلما علم أن ذاته ليست هذه المتجسمة التي يدركها بحواسه، ويحيط بها أديمه، هان عنده بالجملة جسمه، وجعل يتفكر في تلك الذات الشريفة، التي أدرك بها ذلك الموجود الشريف الواجب الوجود، ونظر في ذاته تلك الشريفة، هل يمكن أن تبيد أو تفسد وتضمحل، أو هي دائمة البقاء؟ فرأى إن الفساد والاضمحلال إنما هو من صفات الأجسام بأن تخلع صورة وتلبس صورة أخرى، مثل الماء إذا صار هواء، والهواء إذا صار ماء، والنبات إذا صار تراباً، والتراب إذا صار نباتاً، هذا هو معنى الفساد.

وأما الشيء الذي ليس بجسم، ولا يحتاج في قوامه إلى جسم، وهو منزه بالجملة عن الجسمانية، فلا يتصور فساده البتة. فلما ثبت له أن ذاته الحقيقة لا يمكن فسادها، أراد إن يعلم كيف يكون حالها إذا اطرح البدن وتخلت عنه، وقد كان تبين له أنها لا تطرحه إلا إذا لم يصلح آلة لها، فتصفح جميع القوى المدركة، فرأى أن كل واحدة منها تارةً تكون مدركة بالقوة، وتارةً تكون مدرة بالفعل: مثل العين في حال تغميضها أو أعراضها عن البصر، فانها تكون مدركة بالقوة - ومعنى مدركه بالقوة أنها لا تدرك الآن وتدرك في المستقبل - وفي حال فتحها واستقبالها للمبصر، تكون مدركه بالفعل - ومعنى مدركة بالفعل أنها الآن تدرك - وكذلك كل واحدة من هذه القوى تكون مدركة بالقوة وتكون مدركة بالفعل، وكل واحدة من هذه القوى إن كانت لم تدرك قط بالفعل، فهي ما دامت بالقوة لا تتشوق إلى إدراك الشيء المخصوص بها لأنها لم تتعرف به بعد، مثل من خلق مكفوف البصر؛ وان كانت قد أدركت بالفعل تارةً، ثم صارت بالقوة، فانها ما دامت بالقوة تشتاق إلى الإدراك بالفعل لأنها قد تعرفت إلى المدرك، وتعلقت به، وحنت إليه، مثل من كان يصيراً ثم عمي فانه لا يزال يشتاق إلى المبصرات. وبحسب ما يكون الشيء المدرك أتم وأبهى وأحسن، يكون الشوق أكثر؛ والتألم لفقده اعظم، ولذلك كان تألم من يفقد بصره بعد الرؤية أعظم من تألم من يفقد شمه، إذ الأشياء التي يدركها البصر أتم وأحسن من التي يدركها الشم، فان كان في الأشياء شيء لا نهاية لكماله، ولا غاية لحسنه وجماله وبهائه، وهو فوق الكمال والبهاء والجمال، وليس في الوجود كمال، ولا حسن، ولا بهاء، ولا جمال إلا صادر من جهته، وفائض من قبله، فمن فقد إدراك ذلك الشيء بعد إن تعرف به، فلا محالة أنهما ما دام فاقد له، يكون في ألام لا نهاية لها، كما أن من كان مدركاً له على الدوام، فانه يكون في لذة لا انفصام لها، وغبطة لا غاية لها ورائها، وبهجة وسرور لا نهاية لهما. وقد تبين له أن الموجود الواجب الوجود.

متصف بأوصاف الكمال كلها، ومنزه عن الصفات النقص وبريء منها. وتبين له أن الشيء الذي به يتوصل إلى أدركه أمر لا يشبه الأجسام، ولا يفسد لفسادها؛ فظهر له بذلك أن من كانت له مثل هذه الذات، المعدة لمثل هذا الإدراك؛ فانه إذا أطرح البدن بالموت؛ فإما أن يكون قبل ذلك - في مدة تصريفه للبدن - لم يتعرف قط بهذا الموجود الواجب الوجود؛ ولا اتصل به؛ ولا سمع عنه؛ فهذا إذا فارق البدن لا يشتاق إلى ذلك الموجود ولا يتألم لفقده. واما جميع القوى الجسمانية، فانها تبطل ببطلان الجسم؛ فلا تشتاق أيضاً إلى مقتضيات تلك القوى، ولا تحن إليها، ولا تتألم لفقدها. وهذه حال البهائم غير الناطقة كلها: سواء كانت من صورة الإنسان أو لم تكن. واما إن يكون قبل ذلك - في مدة تصريفه للبدن - قد تعرف بهذا الموجود، وعلم ما هو عليه من الكمال والعظمة والسلطان والحسن إلا انه أعرض عنه واتبع هواه، حتى وافته منيته وهو على تلك الحال، فيحرم المشاهدة، وعنده الشوق إليها فيبقى في عذاب طويل، وألام لا نهاية لها. فأما من يتخلص من تلك الآلام بعد جهد طويل، ويشاهد ما تشوق إليه قبل ذلك، واما أن يبقى في آلامه بقاءً سرمدياً، بحسب استعداده لكل واحد من الوجهين لحياته الجسمانية.

واما من تعرف بهذا الموجود الواجب الوجود، قبل أن يفارق البدن، واقبل بكليته عليه والتزم الفكرة في جلاله وحسن بهائه، ولم يعرض عنه حتى وافته منيته، وهذا على حال من الإقبال والمشاهدة بالفعل. فهذا إذا فارق البدن بقي في لذة لا نهاية لها، وغبطة وسرور وفرح دائم، لاتصال مشاهدته لذلك الموجود الواجب الوجود، وسلامة تلك المشاهدة من الكدر والشوائب؛ ويزول عنه ما تقتضيه هذه القوى الجسمانية من الأمور الحسية التي هي - بالإضافة إلى تلك الحال - ألام وشرور وعوائق. فلما تبين له أن كمال ذاته ولذتها إنما هو بمشاهدة ذلك الموجود الواجب الوجود على الدوام، مشاهدة بالفعل أبداً، حتى لا يعرض عنه طرفة عين لكي توافيه منيته، وهو في حال المشاهدة بالفعل، فتتصل لذته دون أن يتخللها ألم. ثم جعل يتفكر كيف يتأتى له دوام هذه المشاهدة بالفعل، حتى لا يقع منه أعراض فكان يلازم الفكرة في ذلك الموجود كل ساعة، فما هو إلا يسنح لبصره محسوس ما من المحسوسات، أو يخرق سمعه صوت بعض الحيوان، أو يتعرضه خيال من الخيالات، أو يناله ألم في أحد اعضائه، أو يصيبه الجوع أو العطش أو البرد أو الحر، أو يحتاج القيام لدفع فضوله؛ فتختل فكرته، ويزول عما كان فيه، ويتعذر عليه الرجوع إلى ما كان عليه من حال المشاهدة، إلا بعد جهد. وكان يخاف أن تفاجأه منيته وهو في حال الأعراض، فيفضي إلى الشقاء الدائم، وألم الحجاب.

فساءه حاله ذلك، وأعياء الدواء. فجعل يتصفح أنواع الحيوانات كلها، وينظر أفعالها وما تسعى فيه، لعله يتفطن في بعضها أنها شعرت بهذا الموجود، وجعلت تسعى نحوه، فيتعلم منها ما يكون في سبب نجاته. فرآها كلها إنما تسعى في تحصيل غذائها، ومقتضى شهواتها من المطعوم والمشروب والمنكوح، والاستظلال والاستدفاء، وتجد في ذلك ليلها ونهارها إلى حين مماتها وانقضاء مدتها. ولم ير شيئاً منها ينحرف عن هذا الرأي، ولا يسعى لغيره في وقت من الأوقات، فبان له بذلك أنها لم تشعر بذلك الموجود ولا اشتاقت إليه، ولا تعرفت إليه بوجه من الوجوه، وأنها كلها صائرة إلى العدم، أو إلى حال شبيه بالعدم. فلما حكم على ذلك بالحيوان، علم أن الحكم على النبات أولى، إذ ليس للنبات من الادراكات إلا بعض ما للحيوان. وإذا كان الأكمل إدراكاً لم يصل إلى هذه المعرفة، فالأنقص إدراكاً أحرى أن لا يصل، مع انه رأى أيضاً أن أفعال النبات كلها لا تتعدى الغذاء والتوليد. ثم انه بعد ذلك نظر إلى الكواكب والأفلاك فرآها كلها منتظمة الحركات، جارية على نسق؛ ورآها شفافة ومضيئة بعيدة عن قبول التغيير والفساد، فحدس حدساً قوياً أن لها ذوات سوى أجسامها، تعرف ذلك الموجود الواجب الوجود، وأن تلك الذوات العارفة ليست بأجسام، ولا منطبعة في أجسام مثل ذاته، هو، العارفة، وكيف لا يكون لها مثل تلك الذوات البريئة عن الجسمانية، ويكون لمثله على ما به من الضعف وشدة الاحتياج إلى الأمور المحسوسة، وأنه من جملة الأجسام الفاسدة؟ ومع ما به من النقص، فلم يعقه ذلك عن أن تكون ذاته بريئة عن الأجسام لا تفسد، فتبين له بذلك أن الأجسام السماوية أولى بذلك، وعلم أنها تعرف ذلك الموجود الواجب الوجود وتشاهد على الدوام بالفعل، لأن العوائق التي قطعت به هو عن الدوام المشاهدة من العوارض المحسوسة، لا يوجد مثلها للأجسام السماوية.

ثم انه تفكر: لم اختص هو من بين سائر أنواع الحيوانات بهذه الذات التي أشبه بها الأجسام السماوية. وقد كان تبين له أولاً من آمر العناصر واستحالة بعضها إلى بعض، وأن جميع ما على وجه الأرض لا يبقى على صورته؛ بل الكون والفساد متعاقبان عليه أبداً، وأن أكثر هذه الأجسام مختلطة مركبة من أشياء متضادة، ولذلك تؤول إلى الفساد، وانه لا يوجد منه شيء صرفاً، وما كان منها قريباً من أن يكون صرفاً خالصاً لا شائبة فيه، فهو بعيد عن الفساد جداً مثل الذهب والياقوت، وأن الأجسام البسيطة صرفة، ولذلك هي بعيدة عن الفساد، والصور لا تتعاقب عليها. وتبين له هنالك أن جميع الأجسام التي في عالم الكون والفساد، منها ما تتقوم حقيقتها بصورة واحدة زائدة على معنى الجسمية - وهذه هي الاسطقسات الأربع - ومنها ما تتقوم حقيقتها أكثر من ذلك كالحيوان والنبات. فما كان قوام حقيقته بصور أقل، كانت أفعاله أقل، وبعده عن الحياة أكثر، فان عدم الصورة جملة لم يكن فيه إلى الحياة طريق، وصار في حال شبيه بالعدم، وما كان قوام حقيقته بصور أكثر، كانت أفعاله أكثر، ودخوله في حال الحياة أبلغ؛ وان كانت تلك الصورة بحيث لا سبيل إلى مفارقتها لمادتها التي اختصت بها كانت الحياة حينئذ كامل الظهور والكمال والقوة. فالشيء العديم للصورة جملة هو الهيولى والمادة، ولا شيء من الحياة فيها وهي شبيهة بالعدم، والشيء المتقوم بصورة واحدة هي الاسطقسات الأربع وهي في أول مراتب الوجود في عالم الكون والفساد ومنها تتركب الأشياء ذوات الصور الكثيرة. وهذه الاسطقسات ضعيفة الحياة جداً، إذ ليست تتحرك إلا حركة واحدة، وانما كانت ضعيفة الحياة لان لكل واحد منها ضداً ظاهر العناد يخالفه في مقتضى طبيعته، ويطلب أن يغير صورته.

فوجوده لذلك غير متمكن، وحياته ضعيف، والبات أقوى حياة منه والحيوان أظهر حياة منه. وذلك أن ما كان من هذه المركبات تغلب عليه طبيعة أسطقس واحد، فلقوته فيه يغلب طبائع الاسطقسات الباقية، ويبطل قواها، ويصير ذلك المركب في حكم الاسطقس الغالب، فلا يستأهل لاجل ذلك من الحياة آل شيئا يسيراً، كما إن ذلك الاسطقس لا يستأهل من الحياة إلا يسيراً ضعيفاً وما كان من هذه المركبات لا تغلب عليه طبيعة أسطقس واحد منها، فان الاسطقسات تكون فيه متعادلة متكافئة، فإذن لا يبطل لأحدهما الآخر قوة الآخر بأكثر مما يبطل ذلك الآخر قوته، بل يفعل بعضها في بعض فعلاً متساوياً، فلا يكون فعل أحد الاسطقسات أظهر فيه، ولا يستولي عليه أحدها، فيكون بعيد الشبه من كل واحد من الاسطقسات، فكأنه لا مضادة لصورته، فيستأهل الحياة بذلك. ومتى زاد هذا الاعتدال وكان أتم وأبعد من الانحراف، كان بعده عن أن يوجد له ضد أكثر، وكانت حياته أكمل. ولما كان الروح الحيواني الذي مسكنه القلب، شديد الاعتدال، لانه ألطف من الأرض والماء وأغلظ من النار والهواء، صار في حكم الوسط ولم يضاده شيء من الاسطقسات مضادة بينه.

فاستعد بذلك الصورة الحيوانية، فرأى أن الواجب إلى ذلك أن يكون أعدل ما في هذه الأرواح الحيوانية مستعداً لاتمم ما يكون من الحياة في عالم الكون والفساد، وأن يكون ذلك الروح قريباً من أن يقال أنه لا ضد لصورته، فيشبه لذلك هذه الأجسام السماوية التي لا ضد لصورها؛ ويكون روح ذلك الحيوان، وكأنه وسط بالحقيقة بين الاسطقسات التي لا تتحرك إلى جهة العلو على الإطلاق، ولا إلى جهة السفل، بل لو أمكن أن يجعل في وسط المسافة بين المراكز وأعلى ما تنتهي إليه النار في جهة العلو ولم يطرأ عليه الفساد، لثبت هناك ولم يطلب الصعود ولا نزول. ولو تحرك في المكان، لتحرك حول الوسط كما تتحرك الأجسام السماوية، ولو تحرك في الوضع، لتحرك على نفسه، وكان كروي الشكل إذ لا يمكن غير ذلك، فإذن هو شديد الشبه بالأجسام السماوية. ولما كان قد اعتقد أن أحوال الحيوان، ولم ير فيها ما يظن به انه شعر بالموجود الواجب الوجود، وقد كان علم من ذاتها قد شعرت به، قطع ذلك على أنه هو الحيوان المعتدل الروح، الشيبة بالأجسام السماوية وتبين لو انه نوع مباين لسائر الحيوان، وانه إنما خلق لغاية أخرى، وأعد لامر عظيم، لم يعد له شيء من أنواع الحيوان، وكفى به شرفاً أن يكون أحس جزأيه - وهو الجسماني - أشبه الأشياء بالجواهر السماوية الخارجة عن عالم الكون والفساد، المنزهة عن الحوادث النقص والاستحالة والتغيير. وأما أشرف جزأيه، فهو الشيء الذي به عرف الموجود الواجب الوجود، وهذا الشيء العارف، أمر رباني الهي يستحيل ولا يلحقه الفساد، ولا يوصف بشيء مما توصف به الأجسام، ولا يدرك بشيء من الحواس، ولا يتخيل، ولا يتوصل إلى معرفته بآلة سواه، بل يتوصل إليه به؛ فهو العارف والمعروف، والمعرفة؛ وهو العالم، والمعلوم، والعلم؛ لا يتباين في شيء من ذلك، إذ التباين والانفصال من صفات الأجسام ولواحقها، ولا جسم هنالك ولا صفة جسم ولا لاحق بجسم! فلما تبين له الوجه الذي اختص به من بين سائر أصناف الحيوان بمشابهة الأجسام السماوية، رأى إن الواجب عليه أن يتقبلها ويحاكي أفعالها ويتشبه بها جهده. وكذلك رأى أنه بجزئه الاشرف الذي به عرف الموجود الواجب الوجود، فيه شبه ما منه من حيث هو منزه عن صفات الأجسام، وكما أن الواجب الوجود منزه عنها، فرأى ايضاً انه يجب عليه أن يسعى في تحصيل صفاته لنفسه من أي وجه أمكن، وان يتخلق بأخلاقه ويقتدي بأفعاله، ويجد في تنفيذ إرادته، ويسلم الآمر له، ويرضى بجميع حكمه، رضى من قلبه ظاهراً وباطناً، بحيث يسر به وان كان مؤلماً لجسمه وضاراً به ومتلفتاً لبدنه بالجملة. وكذلك رأى فيه شبهاً من سائر أنواع الحيوان بجزئه الخسيس الذي هو من عالم الكون والفساد، وهو البدن المظلم والكثيف، الذي يطالبه بأنواع المحسوسات من المطعوم والمشروب والمنكوح، ورأى أيضاً أن ذلك البدن لم يخلق له عبثاً ولا قرن به لامر باطل، ويجب عليه أن يتفقده ويصلح من شأنه. هذا التفقد لا يكون منه إلا بفعل يشبه أفعال سائر الحيوان. فاتجهت عنده الأعمال التي يجب عليه أن يفعلها نحو ثلاثة أغراض: أما عمل يتشبه بالحيوان الغير الناطق.

واما عمل يتشبه به بالأجسام السماوية. واما عمل يتشبه به بالموجود الواجب الوجود. فالتشبه الأول: يجب عليه من حيث البدن المظلم ذو الأعضاء المنقسمة، والقوى المختلفة، والمنازع المتفننة. والتشبه الثاني: يجب عليه من حيث له الروح الحيواني الذي مسكنه القلب، وهو مبدأ لسائر البدن، ولما فيه من القوى. والتشبه الثالث: يجب عليه من حيث هو، أي: من حيث هو الذات التي بها عرف ذلك الموجود الواجب الوجود. وكان أولاً قد وقف على أن سعادته وفوزه من الشقاء، إنما هي في دوام المشاهدة لهذا الموجود الواجب الوجود، حتى يكون بحيث لا يعرض بطرفة عين. ثم أنه نظر بالوجه الذي يتأتى له به هذا الدوام، فأخر له النظر أنه يجب عليه الاعتمال في هذه الأقسام الثلاثة من التشبيهات: آما التشبه الأول، فلا يحصل له به شيء من هذه المشاهدة، بل هو صارف عنها وعائق دونها، إذ هو تصرف في الأمور المحسوسة، والأمور المحسوسة كلها حجب معترضة دون تلك المشاهدة؛ وانما احتيج إلى هذا التشبه لاستدامة هذا الروح الحيواني الذي يحصل به التشبه الثاني بالأجسام السماوية.

فالضرورة تدعو إليه من هذا الطريق،ولو كان لا يخلو من تلك المضرة. واما التشبه الثاني، فيحصل له به حظ عظيم من المشاهدة على الدوام، لكنها مشاهدة يخالطها شوب؛ اذ من يشاهد ذلك النحو من المشاهدة على الدوام فهو مع تلك المشاهدة يعقل ذاته ويلتفت إليه حسبما يتبين بعد هذا. واما التشبه الثالث، فتحصل به المشاهدة الصرفة، والاستغراق المحض الذي لا التفات فيه بوجه من الوجوه الا إلى الموجود الواجب الوجود، والذي يشاهد هذه المشاهدة قد غابت عنه ذات نفسه وفنيت وتلاشت. وكذلك سائر الذوات، كثيرة كانت أو قليلة، إلا ذات الواحد الحق الواجب الوجود - جل وتعالى وعز. فلما تبين له أن مطلوبه الأقصى هو هذا التشبه الثالث، وأنه لا يحصل له إلا بعد التمرن والاعتمال مدة طويلة في التشبه الثاني، وان هذه المدة لا تدوم له بالتشبه الأول، وعلم أن التشبه الأول - وان كان ضرورياً، فانه عائق بذاته وان كان معيناً بالعرض لا بالذات لكنه ضروري- فألزم نفسه أن لا يجعل لها حظاً من هذا التشبه الأول، إلا بقدر الضرورة، وهي الكفاية التي لا بقاء للروح الحيواني بأقل منها. ووجد ما تدعو إليه الضرورة في بقاء هذا الروح أمرين: أحدهما: ما يمده من الداخل، ويخلف عليه بدل ما يتخلل منه وهو الغذاء. والأخر: ما يقيه من الخارج، ويدفع عنه وجوه الأذى: من البرد والحر والمطر ولفح الشمس والحيوانات المؤذية ونحو ذلك. ورأى أنه إن تناول ضرورية من هذه جزافاً كيفما اتفق، ربما وقع في السرف واخذ فوق الكفاية. فكان سعيه على نفسه من حيث لا يشعر، فرأى أن الحزم له أن يفرض لنفسه فيها حدوداً لا يتعداها، ومقادير لا يتجاوزها، وبأن له الفرض يجب أن يكون في جنس ما يتغذى به. وأي شيء يكون وفي مقداره وفي المدة التي تكون بين العبادات إليه. فنظر أولاً إلى أجناس ما به يتغذى، فرآها ثلاثة أضرب: أولاً: أما نبات لم يكمل بعد نضجه ولم ينته إلى غاية تمامه، وهي أصناف البقول الرطبة التي يمكن الاغتذاء بها.

ثانياً: واما ثمرات النبات الذي تم وانتهى وأخرج بذرة ليتكون منه أخر من نوعه حفظاً له، وهي أصناف الفواكه رطبها ويابسها. ثالثاً: واما حيوان من الحيوانات التي يتغذى بها: أما البرية واما البحرية. وكان قد صح عنده أن هذه الأجناس كلها، من فعل ذلك الموجود الواجب الوجود الذي تبين له أن سعادته في القرب منه، وطلب التشبه به، ولا محالة أن الاغتذاء بها مما يقطعها عن كمالها ويحول بينها وبين الغاية القصوى المقصودة بها. فكان ذلك اعتراض على فعل الفاعل. وهذا الاعتراض مضاد لما يطلبه من القرب منه والتشبه به. فرأى أن الصواب كان له لو أمكن أن يمتنع عن الغذاء جملة واحدة، لكنه لما لم يمكنه ذلك، لانه أن امتنع عنه أل ذلك إلى فساد جسمه، فيكون ذلك اعتراضاً على فاعله أشد من الأول، إذ هو أشرف من تلك الأشياء الآخر التي يكون فسادها سبباً لبقائه.

فاستهل أيسر الضررين، وتسامح في اخف الاعتراضين، ورأى إن يأخذ من هذه الأجناس إذا عدمت آيها تيسر له، بالقدر الذي يتبين له بعد هذا. فأما إن كانت كلها موجودة فينبغي له حينئذ إن يتثبت ويتخير منها ما لم يكن في أخذه كبير اعتراض على فعل فاعل، وذلك مثل لحوم الفواكه التي قد تناهت في الطيب، وصلح ما فيها لتوليد البزر على الشرط التحفظ على ذلك البزر، بان لا يأكله ولا يفسده ولا يلقيه في موضع لا يصلح للنبات، مثل الصفاة والسبخة ونحوهما. فان تعذر عليه وجود مثل هذه الثمرات ذات الطعم الغاذي، كالتفاح والكمثرى والأجاص ونحوها، كان له عند ذلك إن يأكل آما الثمرات التي لا يغذو منها إلا نفس البزر، كالجوز والقسطل، واما من البقول التي لم تصل بعد حد كمالها. والشرط عليه في هذين لأن يقصد أكثرها وجوداً وأقواها توليداً، وان لا يستأصل أصولها ولا يفني بزرها. فان عدم هذه، فله أن يأخذ من الحيوان آو من بيضه، والشرط عليه من الحيوان إن يأخذ من أكثره وجوداً، ويستأصل منه نوعاً بأسره. هذا ما رأى في جنس ما يتغذى به. واما المقدر فرأى أن يكون بحسب ما يسد خلة الجوع ولا يزيد عليها. واما الزمان الذي بين كل عودتين، فرأى انه إذا اخذ حاجته من الغذاء، أن يقيم عليه ولا يتعرض لسواه، حتى يلحقه ضعف يقطع به بعض الأعمال التي تجب عليه في التشبه الثاني، وهي التي يأتي ذكرها بعد هذا. فأما ما تدعو إليه الضرورة في بقاء الروح الحيواني مما يقيه من خارج، فكان الخطب فيه يسيراً: إذ كان مكتسياً بالجلود، وقد كان له مسكن يقيه مما يرد عليه من خارج، فاكتفى بذلك ولم يرى الاشتغال به، والتزم في غذائه القوانين التي رسمها لنفسه، وهي التي تقدم شرحها. ثم اخذ في العمل الثاني، وهو التشبه بالأجسام السماوية والاقتداء بها، والتقبل أوصافها، فانحصرت عنده في ثلاثة أضرب: الضرب الأول: أوصاف لها بالإضافة إلى ما تحتها من عالم الكون والفساد، وهي ما تعطيه إياه من التسخين بالذات، آو التبريد بالعرض، والإضاءة والتلطيف والتكثيف، إلى سائر ما تفعل فيه من الأمور التي بها يستعد لفيضان الصور الروحانية عليه من عند الفاعل الواجب الوجود. والضرب الثاني: أوصاف لها في ذاتها، مثل كونها شفافة وناصعة وطاهرة منزهة عن الكدر وضروب الرجس، ومتحركة بالاستدارة بعضها على مركز نفسها، وبعضها على مركز غيرها.

والضرب الثالث: أوصاف لها بالإضافة إلى الموجود الواجب الوجود، مثل كونها تشاهد مشاهدة دائمة، وتعرض عنه، وتتشوق إليه، وتتصرف بحكمه، وتتسخر في تتميم إرادته، ولا تتحرك إلا بمشيئته وفي قبضته. فجعل يتشبه بها جهده في كل من هذه الاضرب الثلاثة. آما الضرب الأول: فكان تشبه بها فيه: إن ألزم نفسه إن لا يرى ذا حاجة آو عاهة آو مضرة، أو ذا عائق من الحيوان أو النبات، وهو يقدر على أزالتها عنه إلا ويزيلها. فمتى وقع بصره على نبات قد حجبه عن الشمس حاجب آو تعلق به نبات آخر يؤذيه، أو عطش عطشاً يكاد يفسده، أزال عنه ذلك الحاجب إن كان ما يزال، وفصل بينه وبين ذلك المؤذي بفاصل لا يضر المؤذي، وتهده بالسقي ما أمكنه. ومتى وقع بصره على حيوان قد أرهقه سبع آو نشب به ناشب، آو تعلق به شوك، آو سقط على عينيه آو آذنيه شيء يؤذيه، آو مسه ظمأ آو جوع، تكفل بإزالة ذلك كله عنه جهده واطعمه وسقاه. ومتى وقع بصره على ماء يسيل إلى سقي نبات أو حيوان وقد عاقه عن ممره ذلك عائق، من حجر سقط فيه، آو جرف انهار عليه، ازال ذلك كله عنه. وما زال يمعن في هذا النوع من ضروب التشبه حتى بلغ فيه الغاية. واما الضرب الثاني: فكان تشبهه بها فيه إن الزم نفسه دوام الطهارة وإزالة الدنس والرجس عن جسمه والاغتسال بالماء في أكثر الأوقات، وتنظيف ما كان من أظافره واسنانه ومغابن بدنه، وتطيبها بما أمكن من طيبات النبات وصنوف الدهون العطرة، وتعهد لباسه بالتنظيف والتطييب حتى كان يتلألأ حسناً وجمالاً ونظافة وطيباً. والتزم مع ذلك ضروب الحركة على الاستدارة: فتارةً كان يطوف بالجزيرة، ويدور على ساحلها ويسيح باكنافها، وتارةً كان يطوف ببيته، او ببعض الكدى أدوارا معدوده: آما مشياً، آما هرولة؛ وتارة يدور على نفسه حتى يغشه عليه.

وأما الضرب الثالث: فكان تشبهه بها فيه، إن كان يلازم الفكرة في تلك الموجود الواجب الوجود، ثم يقطع علائق المحسوسات. ويغمض عينيه، ويسد أذنيه، ويضرب جهده عن تتبع الخيال، ويروم بمبلغ طاقته إن لا يفكر في شيء سواه، ولا يشترك به احداً ويستعين على ذلك بالاستدارة على نفسه والاستحثاث فيها.

فكان اذا اشتد في الاستدارة، غابت عنه جميع المحسوسات، وضعف الخيال وسائر القوى التي إلى الألأت الجسمانية، وقوي فعل ذاته - التي هي بريئة من الجسم - فكانت في بعض الأوقات فكرته قد تخلص عن الشوب ويشاهد بها الموجود الواجب الوجود، ثم تكر عليه القوى الجسمانية فتفسد عليه حاله، وترده إلى اسفل السافلين. ويعود من ذي قبل، فان لحقه ضعف يقطع به عن غرضه تناول بعض الأغذية عن الشرائط المذكورة. ثم انتقل إلى شأنه من التشبه بالأجسام السماوية بالأضرب الثلاثة المذكورة. ودأب على ذلك مدة وهو يجاهد قواه الجسمانية وتجاهده، وينازعها وتنازعه في الأوقات التي يكون له عليها الظهور، وتتخلص فكرته عن الشوب، يلوح له شيء من أحوال أهل التشبه الثالث.

ثم جعل يطلب التشبه الثالث، ويسعى في تحصيله، فينظر في صفات الموجود الواجب الوجود. وقد كان تبين له أثناء نظره العلمي قبل الشروع في العمل، إنها على ضربين: آما صفة ثبوت: كالعلم والقدرة والحكمة.

وأما صففة سلب: كتنزه عن الجسمانية وعن صفات الأجسام ولواحقها، وما يتعلق بها، ولو على بعد.

وأن صفات الثبوت يشترط فيها هذا التنزيه حتى لا يكون فيها شيء من صفات الأجسام التي من جملتها الكثرة، فلا تتكثر ذاته بهذه الصفات الثبوتية، ثم ترجع كلها إلى معنى واحد هي حقيقة ذاته. فجعل يطلب كيف يتشبه به في كل واحد من هذين الضربين. آما صفات الاجاب، فلما علم انها كلها راجعة إلى حقيقة ذاته، وانه لا كثرة فيها بوجه من الوجوه، إذ الكثرة من صفات الأجسام؛ وعلم إن علمه بذاته؛ ليس معنى زائداً على ذاته، بل ذاته هي علمه لذاته؛ وعلمه بذاته هو ذاته، تبين له انه إن أمكنه هو إن يعلم ذاته، فليس ذلك العلم الذي علم به ذاته معنى زائداً على ذاته، بل هو هو! فرأى إن التشبه به من صفات الاجاب، هو ان يعلمه فقط دون إن يشرك به شيئاً من صفات الأجسام؛ فاخذ نفسه بذلك. واما صقات السلب، فانها كلها راجعة إلى التنزه عن الجسمية. فجعل يطرح اوصاف الجسمية عن ذاته. وكان قد طرح منها كثيراً في رياضته المتقدمة التي كان ينحو بها بالتشبه بالأجسام السماوية. إلا انه أبقى منها بقايا كثيرة: كحركة الاستدارة - والحركة من أخص صفات الأجسام - وكل الاعتناء بأمر الحيوان والنبات والرحمة لها، والاهتمام بإزالة عوائقها. فان هذه أيضاً من صفات الأجسام، إذ لا يراها أولاً إلا بقوة جسمانية، ثم يكدح بأمرها بقوة جسمانية أيضاً. فاخذ في طرح ذلك كله عن نفسه، إذ هي بجملتها مما لا يليق بهذه الحالة التي يطلبها الآن.

وما زال يقتصر على السكون في قصر مغارته مطرقاً، غاضاً بصره، معرضاً عن جميع المحسوسات والقوى الجسمانية، مجتمع الهم والفكرة في الموجود الواجب الوجود وحده دون شركه؛ فمتى سنح بخياله سانح سواه، طرده عن خياله جهده، ودافعه وراض نفسه على ذلك، ودأب فيه مدة طويلة، بحيث تمر عليه عدة أيام لا يتغذى فيها ولا يتحرك. وفي خلال شدة مجاهدته هذه ربما كانت تغيب عن ذكره وفكره جميع الأشياء إلا ذاته، فانها كانت لا تغيب عنه في وقت استغراقه بمشاهدة الموجود الأول الحق الواجب الوجود.

فكان يسوءه ذلك، ويعلم انه شوب في المشاهدة المحضة، وشركه في الملاحظة. ومازال يطلب الفناء عن نفسه والإخلاص في مشاهدة الحق حتى تأتى له ذلك، وغابت عن ذكره وفكره السموات والأرض وما بينهما، وجميع الصور الروحانية والقوى الجسمانية، وجميع القوى المفارقة للمواد، والتي هي الذوات العارفه بالموجود الحق؛ وغابت ذاته في جملة تلك الذوات، وتلاشى الكل واضمحل، وصار هباءً منثوراً، ولم يبقى إلا الواحد الحق الموجود الثابت الوجود.

وهو يقول بقوله الذي ليس معنى زائداً على ذاته: "بسم الله الرحمن الرحيم" لمن الملك اليوم لله الواحد القهار صدق الله العظيم ففهم كلامه وسمع ندائه ولم يمنعه عن فهمه كونه لا يعرف الكلام، ولا يتكلم.

واستغرق في حالته هذه وشاهد ما لا عين رأت ولا إذن سمعت! ولا خطر على قلب بشر. فلا تعلق قلبك بوصف آمر لم يخطر على قلب بشر، فان كثيراً من الأمور التي تخطر على قلوب البشر قد يتعذر وصفه، فكيف بأمر لا سبيل إلى خطورة على القلب، ولا هو من عالمه ولا من طوره!؟ ولست أعني بالقلب جسم القلب، ولا الروح التي في تجويفه بل أعني صورة تلك الروح الفائضة بقواها على بدن الإنسان، فان كل واحد من هذه الثلاثة قد يقال له قلب ولكن لا سبيل لخطور ذلك الآمر على واحد من هذه الثلاثة، ولا يتأتى التعبير إلا عما الخطر علها.

ومن رام التعبير عن تلك الحال، فقد رام مستحيلاً وهو بمنزلة من يريد أن يذوق الألوان من حيث هي الألوان، ويطلب أن يكون السواد مثلاً حلواً أو حامضاً.

لكنا، مع ذلك، لا نخيلك عن إشارات نومئ بها إلى ما شاهده من عجائب ذلك المقام، على سبيل ضرب المثل، لا على سبيل قرع باب الحقيقية. إذ لا سبيل إلى التحقق بما في ذلك المقام إلا بالوصول إليه.

فأصغ الآن بسمع قلبك، وحدق ييصر إلى ما أشير به اليك لعلك أن تجد منه هدياً يلقيك على جادة الطريق! وشرطي عليك أن لا تطلب مني في هذا الوقت مزيد بيان بالمشافهة على ما أودعه هذه الاوراق فان المجال ضيق، والتحكم بالألفاظ على آمر ليس من شأنه أن يلفظ به خطر.

فأقول: انه لما فني عن ذاتهوعن جميع وعن جميع الذوات ولم ير في الوجود إلا الواحد القيوم، وشاهد ما شاهد، ثم عاد إلى ملاحظة الاغيار عندما آفاق من حالة تلك التي شبيه بالسكر، خطر بباله انه لا ذات له يغاير بها ذات الحق تعالى، وان حقيقة ذاته هي ذات الحق، وان الشيء الذي كان يظن أولاً انه ذات المغايرة لذات الحق، ليس شيئاً في الحقيقة، بل ليس ثم شيء إلا ذات الحق، وان ذلك بمنزلة نور الشمس الذي يقع على الأجسام الكثيفة فتراه يظهر فيها.

فإنه وإن نسب إلى الجسم الذي يظهر فيه، فليس هو في الحقيقية شيئاً سوى نور الشمس. وان زال ذلك الجسم زال نوره، وبقي نور الشمس بحاله لم ينقص عند حضور ذلك الجسم ولم يزد عند مغيبه.

ومتى حدث جسم يصلح لقبول ذلك النور، قبله، فإذا عدم الجسم عدم ذلك القبول، ولك يكن له معنى، عنده هذا الظن بما قد بان له من إن ذات الحق، عز وجل، لا تتكثر بوجهه من الوجوه، وأن علمه بذاته، وهو ذاته بعينها.

فلزم عنده من هذا أن حصل عنده العلم بذاته، فقد حصلت عنده ذاته، وقد كان حصل عنده العلم فحصلت عنده الذات.

وهذه الذات لا تحصل إلا عند ذاتها، ونفس حصولها هو الذات؛ فإذن هو الذات بعينها. وكذلك جميع الذوات المفارقة للمادة العارفة بتلك الذات الحقه التي كان يراها أولاً كثيرة، وصارت عنده بهذا الظن شيئاً واحداً. وكادت هذه الشبه ترسخ في نفسه لولا أن تداركه الله برحمته وتلافاه بهدايته، فعلم إن الشبهة انما ثارت عنده من بقايا ظلمة الأجسام، وكدورة المحسوسات. فان الكثير والقليل والواحد والوحدة، والجمع والاجتماع، والافتراق، هي كلها من صفات الأجسام، وتلك الذوات المفارقة العارفة بذات الحق، عز وجل، لبرائتها عن المادة، لا يجب إن يقال انها كثيرة، ولا واحدة، لان الكثرة انما هي مغايرة الذوات بعضها لبعض، والوحدة أيضاً لا تكون إلا بالاتصال. ولا يفهم شيء من ذلك إلا في المعاني المركبة المتلبسة بالمادة. غير إن العبارة في هذا الموضع قد تضيق جداً لانك إن عبرت عن تلك الذوات المفارقة بصيغة الجمع حسب لفظنا هذا، أوهم ذلك معنى الكثرة فيها، وهي بريئة عن الكثرة. وان أنت عبرت بصيغة الإفراد، اوهم ذلك معنى الاتحاد، وهو مستحيل عليها. وكأني بمن يقف على هذا الموضع من الخفافيش الذين تظلم الشمس في أعينهم يتحرك في سلسلة جنونه، ويقول: لقد افرطت في تدقيقك حتى انك قد انخلعت عن غريزة العقلاء، واطرحت حكم معقول، فان من أحكام العقل إن الشيء آما واحد واما كثير، فليتئد في غلوائه، وليكف من غرب لسانه وليتهم نفسه، وليعتبر بالعالم المحسوس الخسيس الذي هو أطباقه بنحو ما اعتبر به حي بن يقظان حيث كان بنظر فيه بنظر فيراه كثيراً كثرة لا تنحصر ولا تدخل تحت حد، ثم ينظر فيه بنظر آخر، فيراه واحداً. وبقي في ذلك متردداً ولم يكنه إن يقطع بأحد الوصفين دون الآخر. هذا فالعالم المحسوس منشأ الجمع والإفراد، وفيه الانفصال والاتصال، والتحيز والمغايرة، والاتفاق والاختلاف، فما ظنه بالعالم الإلهي الذي لا يقال فيه كل ولا بعض، ولا ينطق في أمره بلفظ من الألفاظ المسموعة، إلا وتوهم فيه شيء على خلاف الحقيقة، فلا يعرفه إلا من شاهده؛ ولا تثبت حقيقته إلا عند من حصل فيه. واما قوله: حتى انخلعت عن غريزة العقلاء، واطرحت حكم المعقول. فنحن نسلم له ذلك، ونتركه مع عقله وعقلائه، فان العقل الذي يعنيه هو أمثاله، انما هو القوة الناطقة التي تتصفح أشخاص الموجودات المحسوسة، وتقتنص منها المعنى الكلي. والعقلاء الذين يعنيهم، هم ينظرون من هذا النظر والنمط الذي كلامنا فيه فوق هذا كله، فليسد عنه سمعه من لا يعرف سوى المحسوسات وكلياتها، وليرجع إلى فريقه الذين "بسم الله الرحمن الرحيم" يعملون ظاهراً من الحياة الدنيا. وهم عن الآخرة هم غافلون. صدق الله العظيم. فان كنت ممن يقتنع بهذا النوع من التلويح والإشارة إلى ما في العالم الإلهي، ولا تحمل ألفاظاً من المعاني على ما جرت العادة بها في تحميلها إياه، فنحن نزيدك شيئاً مما شاهده حي بن يقظان في مقام أولي الصدق الذي تقدم ذكره، فتقول: انه بعض الاستغراق المحض، والفناء التام، وحقيقة الوصول، وشاهد للفلك الأعلى، الذي لا جسم له، ورأى ذاتاً بريئة عن المادة، ليست هي ذات الواحد الحق، ولا هي نفس الفلك، ولا هي غيرها؛ وكأنها صورة الشمس التي تظهر في مرآة من المرائي الصقيلة، فانها ليست هي الشمس ولا المرأة ولا غيرهما. وراى لذات ذلك الفلك المفارقة من الكمال والبهاء والحسن، ما يعظم عن إن يوصف بلسان، ويدق إن يكسى بحرف آو صوت، وراه في غاية من اللذة والسرور، والغبطة والفرح، بمشاهدة ذات الحق جل جلاله. وشاهد ايضاً للفلك الذي يليه، وهو فلك الكواكب الثابتة، ذاتاً بريئة عن المادة أيضاً، ليست هي ذات الواحد الحق، ولا ذات الفلك الأعلى المفارقة، ولا نفسه، ولا هي غيرها. وكأنها صورة الشمس التي تظهر في المرآة قد انعكست إليها من مرآة أخرى مقابلة للشمس، ورأى لهذه الذات ايضاً من البهاء والحسن واللذة مثل ما راى لتلك التي للفلك الأعلى. وشاهد ايضاً للفلك الذي يلي هذا، وهو فلك زحل ذاتاً مفارقة للمادة ليست هي شيئاً من الدواب التي شاهدها قبله ولا هي غيرها؛ وكأنها صورة الشمس التي تظهر في مرآة قد انعكست إليها الصورة من مرآة مقابلة للشمس؛ وراى لهذه الذات ايضاً مثل ما راى آمل قبلها من البهاء واللذة. ومازال يشاهد لكل فلك ذاتاً مفارقة بريئة عن المادة ليست هي شيئاً من الذوات التي قبلها ولا هي غيرها وكأنها صورة الشمس التي تنعكس من مرآة على مرآة، على رتب مرتبة بحسب ترتيب الأفلاك. وشاهد لكل ذات من هذه الذوات من الحسن والبهاء، واللذة والفرح، ما لا عين رأت، ولا أذن سمعت، ولا خطر على قلب بشر. إلى أن انتهى إلى عالم الكون والفساد، وهو جميعه حشو فلك القمر. فرأى له ذاتاً بريئة عن المادة ليست شيئاً من الذوات التي شاهدها قبلها، ولا هي سواها. ولهذه سبعون ألف وجه، في كل وجه سبعون ألف فم، في كل فم سبعون ألف لسان، يسبح بها ذات الواحد الحق، ويقدسها ويمجدها، لا يفتر؛ ورأى لهذه الذات، التي توهم فيها الكثرة وليست كثيرة، من الكمال واللذة، مثل الذي رآه لما قبلها. وكأن هذه الذات صورة الشمس التي تظهر في ماء مترجرج، وقد انعكست إليها الصورة من آخر المرايا التي انتهى إليها الانعكاس على الترتيب المتقدم من المرآة الأولى التي قابلت الشمس بعينها. ثم شاهد لنفسه ذاتاً مفارقة، لو جاز إن تتبعض ذات السبعين ألف وجه، لقلنا انها بعضها. ولولا إن هذه الذات حدثت بعد إن لم تكن، لقلنا إنها هي! ولولا اختصاصها ببدنه عند حدوثه، لقلنا إنها لم تحدث! وشاهد في هذه الرتبة ذواتاً، مثل ذاته، لاجسام كانت ثم اضمحلت، ولاجسام لم تزل معه في الوجود، وهي من الكثرة في حد بحيث لا تتناهى إن جاز أن يقال لها كثيرة، أو هي كلها متحدة إن جاز إن يقال لها واحدة. وراى لذاته ولتلك الذوات التي في رتبته من الحسن والبهاء واللذة غير المتناهية، ما لا عين رأت ولا أذن سمعت، ولا خطر على قلب بشر، ولا يصفه الواصفون، ولا يعقله إلا الواصلون العارفون. وشاهد ذواتاً كثيرة مفارقة للمادة كأنها مرايا صدئة، قد ران عليها الخبث، وهي مع ذلك مستدبرة للمرايا الصقيلة التي ارتسمت فيها صورة الشمس، ومولية عنها بوجوهها، وراى لهذه الذوات من القبح والنقص ما لم يقم بباله قط؛ وراها في ألام لا تنقضي، وحسرات لا تنمحي؛ قد أحاط بها سرادق العذاب، وأحرقتها نار الحجاب، ونشرت بمناشير بين الانزعاج والانجذاب. وشاهد هنا ذواتاً سوى هذه المعذبة تلوح ثم تضمحل، وتنعقد ثم تنحل، فتثبت فيها وأنعم النظر إليها، فرأى هولاً عظيماً وخطباً جسيماً، وخلقاً حثيثاً، وأحكاماً بليغة، وتسوية ونفخاً وإنشاء ونسخاً. فما هو إلا إن تثبت قليلاً، فعادت إليه حواسه، وتنبه من حاله تلك التي كانت شبيهة بالغشي، وزلت قدمه عن ذلك المقام، ولاح له العالم المحسوس، وغاب عنه العالم الإلهي: إذ لم يكن اجتماعهما في حال واحدة، إذ الأخرى والدنيا كضرتين، إن أرضيت احدهما أسخطت الأخرى، فان قلت يظهر مما حكيته من هذه المشاهدة، إن الذوات المفارقة إن كانت لجسم دائم الوجود لا يفسد، كالأفلاك، كانت هي دائمة الوجود؛ وان كانت لجسم يؤول إلى الفساد كالحيوان الناطق، فسدت هي واضمحلت وتلاشت، حسبما مثلث به في المرايا الانعكاس، فان الصورة لا ثبات لها إلا ثبات بثبات المرآة، فإذا فسدت المرآة صح فساد الصورة واضمحلت هي؛ فأقول لك: ما لأسرع ما نسيت العهد، وحلت عن الربط، ألم نقدم إليك إن مجال العبارة هنا ضيق، وان الألفاظ على كل حال توهم غير الحقيقة وذلك الذي توهمته إنما أوقعك فيه، إن جعلت المثال والممثل به على حكم واحد من جميع الوجوه. ولا ينبغي أن يفعل ذلك في أصناف المخاطبات المعتادة، فكيف ها هنا والشمس ونورها، وصورتها وتشكلها والمرايا والصور الحاصلة فيها، كلها أمور غير مفارقة للأجسام، ولا قوام لها إلا بها وفيها؟ فلذلك افتقرت في وجودها إليها وبطلت ببطلانها. واما الذوات الإلهية، والأرواح الربانية، فانها كلها بريئة عن الأجسام ولواحقها ومنزهة غاية التنزيه عنها، فلا ارتباط ولا تعلق لها بها، وسواء بالإضافة إليها بطلان الأجسام أو ثبوتها، ووجودها أو عدمها؛ وانما ارتباطها وتعلقها بذات الواحد الحق الموجود الواجب الوجود، الذي هو أولها ومبدؤها وسببها وموجدها، وهو يعطيها الدوام ويمدها بالبقاء والتسرمد؛ ولا حاجة بها إلى الأجسام بل الأجسام المحتاجة إليها. ولو جاز عدمها لعدمت الأجسام فانها هي مبديها، كما انه لو جاز إن تعدم ذات الواحد الحق - تعالى وتقدس عن ذلك؛ لا اله إلا هو! - لعدمت هذه الذوات كلها، ولعدمت الأجسام، ولعدم العالم الحسي بآسره، ولم يبق موجود، إذ الكل مرتبط بعضه ببعض. والعالم المحسوس وان كان تابعاً للعالم الإلهي، شبيه الظل له؛ والعالم الإلهي مستغن عنه وبريء منه فانه مع ذلك قد يستحيل فرض عدمه، إذ هو لا محالة تابع للعالم الإلهي، وانما فساده إن يبدل، لا إن يعدم بالجملة، وبذلك نطق الكتاب العزيز حيثما وقع هذا المعنى منه في تسيير الجبال وتسييرها كالعهن والناس كالفراش. وتكوير الشمس والقمر، وتفجيرالبحار يوم تبدل الارض غير الأرض والسموات. فهذا القدر هو الذي امكنني الآن أن أشير إليك به فيما شاهده حي بن يقظان في ذلك المقام الكريم فلا تلتمس الزيادة عليه من جهة الألفاظ فان ذلك كالمعتذر. واما تمام خبره - فسأتلوه عليك إن شاء الله تعالى: وهو انه لما عاد إلى العالم المحسوس، وذلك بعد جولا نه حيث جال، سئم تكاليف الحياة الدنيا، واشتد شوقه إلى الحياة الدنيا، واشتد شوقه إلى الحياة القصوى، فجعل يطلب العود إلى ذلك المقام بالنحو الذي طلبه أولاً حتى وصل إليه بأيسر من السعي الذي وصل به أولاً ودام فيه ثانياً مدة أطول من الأولى. ثم عاد إلى عالم الحس. ثم تكلف الوصول إلى مقامه بعد ذلك فكان ايسر عليه من الأولى والثانية وكان دوامه أطول. وما زال الوصول إلى ذلك المقام الكريم يزيد عليه سهولة، والدوام يزيد فيه طولاً مدة بعد مدة، حتى صار يصل إليه متى شاء، ولا ينفصل عنه إلا متى شاء؛ فكان يلازم مقامه ذلك ولا ينثني عنه إلا لضرورة بدنه التي كان قد قللها، حتى كان لا يوجد اقل منها. وهو في كل ذلك كله يريد إن يريحه الله عز وجل من كل بدنه الذي يدعوه إلى مفارقة مقامه ذلك، فيتخلص إلى لذته تخلصاً دائماً، ويبرأ عما يجده من الألم عند الأعراض عن مقامه ذلك إلى ضرورة البدن. وبقي على حالته تلك حتى أناف على سبعة أسابيع من منشئه وذلك خمسون عاماً. وحينئذ اتفقت له صحبة أسال وكان من قصته معه ما يأتي ذكره بعد هذا إن شاء الله تعالى. ذكروا: إن جزيرة قريبة من الجزيرة التي ولد بها حي بن يقظان على أحد القولين المختلفين على صفة مبدئه، انتقلت إليه ملة من الملل الصحيحة الماخوذه على بعض الأنبياء المتقدمين، صلوات الله عليهم. وكانت ملة محاكية لجميع الموجودات الحقيقية بالأمثال المضروبة التي خيالات تلك الأشياء، وتثبت رسومها في النفوس، حسبما جرت به العادة في مخاطبة الجمهور؛ فما زالت تلك الملة تنتشر بتلك الجزيرة وتقوى وتظهر، حتى قام بها ملكها وحمل الناس على التزامها. وكان قد نشأ بها فتيان من أهل الفضل والخير، يسمى أحدهما أسال والآخر سلامان فتلقيا هذه الملة وقبلاها احسن قبول، واخذ على أنفسهما على بالتزام جميع شرائعها والموظبة على جميع أعمالها، واصطحبا على ذلك. وكانا يتفقهان في بعض الأوقات فيما ورد من ألفاظ تلك الشريعة في صفة الله عز وجل وملائكته، وصفات الميعاد والثواب والعقاب. فأما أسال فكان أشد غوصاً على الباطن، وأكثر عثوراً على المعاني الروحانية واطمع في التأويل. واما سلامان صاحبه فكان أكثر احتفاظاً بالظاهر، وأشد بعداً عن التأويل، وأوقف عن التصرف والتأمل؛ وكلاهما مجد في الأعمال الظاهرة، ومحاسبة النفس، ومجاهدة الهوى. وكان في تلك الشريعة أقوال تحمل عن العزلة والانفراد، وتدل على إن الفوز والنجاة فيهما؛ واقوال أخر تحمل على المعاشرة وملازمة الجماعة. فتعلق أسال بطلب العزلة، ورجح القول فيها لما كان في طباعه من دوام الفكرة، وملازمة العبرة، والغوص على المعاني، وأكثر ما كان يتأتى له أمله من ذلك بالانفراد. وتعلق سلامان بملازمة الجماعة، ورجح القول فيها لما كان في طباعه من الجبن عن الفكرة والتصرف. فكانت ملازمته الجماعة عنده مما يدرأ الوسواس، ويزيل الظنون المعترضة ويعيد من همزات الشياطين. وكان اختلافهما في هذا الرأي سبب افتراقهما. وكان أسال قد سمع عن الجزيرة التي ذكر أن حي بن يقظان تكون بها وعرف ما بها من الخصب والمرافق والهواء المعتدل، وان الانفراد بها يتأتى لملتمسه، فأجمع إن يرتحل إليها ويعتزل الناس بها بقية عمره. فجمع ما كان له من المال، واشترى ببعضه مركباً تحمله إلى تلك الجزيرة، وفرق باقيه على المساكين، وودع صاحبه سلامان وركب متن البحر؛ فحمله الملاحون إلى تلك الجزيرة؛ ووضعوه بساحلها؛ وانفصلوا عنها. فبقي أسال بتلك الجزيرة يعبد الله عز وجل؛ ويعظمه ويقدسه؛ ويفكر في اسمائه الحسنى وصفاته العليا؛ فلا ينقطع خاطره؛ ولا تتكدر فكرته. واذا احتاج إلى غذاء تناول من ثمرات تلك الجزيرة وصيدها ما يسد بها جوعته. وأقام على تلك الحال مدة وهو في أتم غبطة وأعظم أنس بمناجاة ربه. وكان كل يوم يشاهد من ألطافه ومزايا تحفة وتيسره عليه في مطلبه وغذائه ما يثبت يقينه ويقر عينه. وكان في تلك المدة حي بن يقظان شديد الاستغراق في مقاماته الكريمة؛ فكان لا يبرح عن مغارته إلا مرة في الاسبوع لتناول ما سنح من الغذاء، فلذلك لم يعثر عليه أسال لأول وهلة، بل كان يتطوف بأكناف تلك الجزيرة ويسبح في أرجائها، فلا يرى أنسياً ولا يشاهد أثراً فيزيد بذلك أنسه وتنبسط نفسه لما كان قد عزم عليه من التناهي في طلب العزلة والانفراد. إلى إن اتفق في بعض تلك الأوقات إن خرج حي بن يقظان لالتماس غذائه وأسال قد ألم بتلك الجهة، فوقع بصر كل منهما على الآخر. فإما أسال فلم يشك أنه من العباد المنقطعين، وصل تلك الجزيرة لطلب العزلة عن الناس كما وصل هو إليها. فخشي إن هو تعرض له وتعرف به إن يكون سبباً في فساد حاله وعائقاً بينه وبين أمله. واما حي بن يقظان فلم يدر ما هو، لانه لم يره على صورة شيء من الحيوانات التي كان قد عاينها قبل ذلك. وكان عليه مدرعة سوداء من الشعر والصوف، فظن إنها لباس طبيعي. فوقف يتعجب منه ملياً. وولى أسال هارباً منه خيفة أن يشغله عن حاله، فاقتفى حي بن يقظان أثره لما كان في طباعه من البحث عن الحقائق. فلما رآه يشتد في الهرب. خنس عنه وتوارى له، حتى ظن أسال انه قد انصرف عنه وتباعد من تلك الجهة. فشرع أسال في الصلاة والقراءة، والدعاء والبكاء، والتضرع والتواجد، حتى شغله ذلك عن كل شيء. فجعل حي بن يقظان يتقرب منه قليلاً قليلاً، وأسال لا يشعر به حتى دنا منه بحيث يسمع قراءته وتسبيحه، ويشاهد خضوعه وبكائه. فسمع صوتاً حسناً وحروف منظمة، لم يعهد مثلها من شيء من أصناف الحيوان. ونظر إلى أشكاله وتخطيطه فرآه على صورته، وتبين له أن المدرعة التي عليه ليست جلداً طبيعياً، وانما هي لباس متخذ مثل لباسه هو، ولما رأى حسن خشوعه وتضرعه وبكائه لم يشك في انه من الذوات العارفة بالحق؛ فتشوق إليه واراد إن يرى ما عنده، وما الذي أوجب بكاءه وتضرعه؛ فزاد في الدنو منه حتى أحس به أسال؛ فاشتد في العدو، واشتد حي بن يقظان في أثره حتى التحق به - لما كان أعطاه الله من القوة والبسطة في العلم والجسم - فالتزمه وقبض عليه؛ ولم يمكنه من البراح. فلما نظر إليه أسال وهو مكتس بجلود الحيوان ذوات الاوبار؛ وشعره قد طال حتى جلل كثيراً منه، ورأى ما عنده من سرعة العدو وقوة البطش، فرق منه فرقاً شديداً، وجعل يستعطفه ويرغب إليه بكلام لا يفهمه حي بن يقظان ولا يدري ما هو، غير أنه يميز فيه شمائل الجزع. فكان يؤنسه بأصوات كان قد تعلمها من الحيوانات، ويجر يده على رأسه، ويمسح أعطافه. ويتملق إليه، ويظهر البشر والفرح به. حتى سكن جأش أسال وعلم أنه لا يريد به سوءاً. كان أسال قديماً لمحبته في علم التأويل. قد تعلم أكثر الألسن، ومهر فيها. فجعل يكلم حي بن يقظان ويسائله عن شأنه بكل لسان يعلمه ويعالج أفهامه فلا يستطيع، وحي بن يقظان في ذلك كله يتعجب مما يسمع ولا يدري ما هو. غير أنه يظهر له البشر والقبول. فاستغرب كل واحد منهما أمر صاحبه. وكان عند أسال من زاد كان قد اصطحبه من الجزيرة المعمورة، فقربه إلى حي بن يقظان فلم يدر ما هو، لانه لم يكن شاهده قبل ذلك. فأكل منه أسال وأشار إليه ليأكل ففكر حي بن يقظان فيما كان ألزم نفسه من الشروط لتناول الغذاء، ولم يدر اصل ذلك الشيء الذي قدم له ما هو، وهل يجوز له تناوله أم لا! فامتنع عن الآكل. ولم يزل أسال يرغب إليه ويستعطفه. وقد كان اولع به حي بن يقظان فخشي إن دام على امتناعه إن يوحشه، فاقدم على ذلك الزاد وأكل منه. فلما ذاقه واستطابه بدا له سوء ما صنع من نقض عهوده في شرط غذاء، وندم على فعله، وأراد الانفصال عن أسال والإقبال على شأنه من طلب الرجوع إلى مقامه الكريم، فلما تتأت له المشاهدة بسرعة. فرأى أن يقيم مع أسال في عالم الحس حتى يقف على حقيقة شأنه، ولا يبقي في نفسه هو نزوع إليه، وينصرف بعد ذلك إلى مقامه دون إن يشغله شاغل. فالتزم صحبة أسال ولما رأى أسال أيضاً انه لا يتكلم، آمن من غلوائه على دينه، ورجا أن يعلمه الكلام والعلم والدين، فيكون له بذلك أعظم أجر وزلفى عند الله. فشرع أسال في تعليمه الكلام أولاً بأن كان يشير له إلى أعيان الموجودات وينطق بأسمائها ويكرر ذلك عليه ويحمله على النطق، فينطق بها مقترناً بالاشارة، حتى علمه الأسماء كلها، ودرجه قليلاً قليلاً حتى تكلم في أقرب مدة. فجعل أسال يسأله عن شأنه ومن أين صار إلى تلك الجزيرة، فأعلمه حي بن يقظان انه لا يدري لنفسه ابتداء ولا أباً ولا أماً أكثر من الظبية التي ربته، ووصف له شأنه كله وكيف ترقى بالمعرفة، حتى انتهى إلى درجة الوصول.

فلما سمع أسال منه وصف تلك الحقائق والذوات المفارقة لعالم الحس العارفة بذات الحق عز وجل، ووصفه ذلك الحق تعالى وجل بأوصافه الحسنى، ووصف له ما أمكنه وصفه مما شاهده عند الوصول من لذات الواصلين وألام المحجوبين، لم يشك أسال في أن جميع الأشياء التي وردت في شريعته من أمر الله عز وجل، وملائكته، وكتبه، ورسله، واليوم الآخر، وجنته وناره، هي أمثلة هذه التي شاهدها حي بن يقظان؛ فانفتح بصر قلبه وانقدحت نار خطره وتطابق عنده المعقول والمنقول، وقربت عليه طرق التأويل، ولم يبق عليه مشكل في الشرع إلا تبين له، ولا مغلق إلا انفتح، ولا غامض إلا اتضح، وصار من أولى الألباب. وعند ذلك نظر إلى حي بن يقظان بعين التعظيم والتوقير، وتحقق عنده أنه من أولياء الله الذين لا خوف عليهم ولا هم يحزنون. فالتزم خدمته والاقتداء به بإشارته فيما تعارض عنده من الأعمال الشرعية التي قد تعلمها في ملته. وجعل حي بن يقظان يستفصحه عن أمره وشأنه، فجعل أسال يصف له شأن جزيرته وما فيها من العالم، وكيف كانت سيرهم قبل وصول الملة اليهم.

وكيف هي الآن بعد وصولها إليهم، وصف له جميع ما ورد في الشريعة من وصف العالم الإلهي، والجنة والنار، والبعث والنشور، والحشر والحساب، والميزان والصراط. ففهم حي بن يقظان ذلك كله ولم ير فيه شيء على خلاف ما شاهده في مقامه الكريم. فعلم أن الذي وصف ذلك وجاء به محق في وصفه، صادق في قوله، ورسول من عند ربه؛ فأمن به وصدقه وشهد برسالته.

ثم جاء يسأله عما جاء به من الفرائض، ووضعه من العبادات؛ فوصف له الصلاة والزكاة، والصيام والحج، وما أشبهها من الأعمال الظاهرة؛ فتلقى ذلك والتزمه، وأخذ نفسه بأدائه امتثالاً للآمر الذي صح عنده صدق قوله.

إلا انه بقي في نفسه أمران كان يتعجب منهما ولا يدري وجه الحكمة فيهما: أحدهما - لما ضرب هذا الرسول الأمثال للناس في أكثر ما وصفه من أمر العالم الإلهي، وأضرب عن المكاشفة حتى وقع الناس في أمر عظيم من التجسيم، واعتقاد أشياء في ذات الحق هو منزه عنها وبريء منها؟ وكذلك في أمر الثواب والعقاب! والآمر الآخر - لم اقتصر على هذه الفرائض ووظائف العبادات وأباح الاقتناء للأموال والتوسع في المأكل، حتى بفرغ الناس بالاشتغال بالباطل، والأعراض عن الحق؟ وكان رأيه هو لا يتناول أحد شيئاً إلا ما يقيم به من الرمق؛ واما الأموال فلم تكن لها عنده معنى.

وكان يرى ما في الشرع من الأحكام في أمر الأموال: كالزكاة وتشعبها، والبيوع والربا والحدود والعقوبات، فكان يستغرب هذا كله ويراه تطويلاً، ويقول: إن الناس لو فهموا الآمر على حقيقته لاعرضوا عن هذه البواطل، وأقبلو على الحق، واستغنوا عن هذا كله، ولم يكن لاحد اختصاص بمال يسأل عن زكاته، أو تقطع الأيدي على سرقته، أو تذهب النفوس على أخذه مجاهرة.

وكان الذي أوقعه في ذلك ظنه، أن الناس كلهم ذوو فطر فائقة، وأذهان ثاقبة، ونفوس عازمة، ولم يكن يدري ما هم عليه من البلادة والنقص، وسوء الرأي وضعف العزم، وأنهم كالأنعام بل هم أضل سبيلاً.

فلما اشتد إشفاقه على الناس، وطمع أن تكون نجاتهم على يديه، حدثت له النية في الوصول إليهم، وإيضاح الحق لديهم، وتبييه لهم ففاوض في ذلك صاحبه أسال وسأله: هل تمكنه حيلة في الوصول اليهم؟ فأعلمه بما هم فيه من نقص الفطرة والأعراض عن آمر الله فلم يتأت له فهم ذلك، وبقي في نفسه تعلق بما كان قد أمله.

وطمع أسال أيضاً أن يهدي الله على يديه طائفة من معارفه المريدين الذين كانوا أقرب من التخلص من سواهم، فساعده على رأيه، ورأيا أن يلتزما ساحل البحر ولا يفارقاه ليلاً ولا نهاراً، لعل الله إن السني لهما عبور البحر فالتزما ذلك وابتهلا الله تعالى أن يهيء لهما من أمرهما رشدأً.

فكان من أمر الله عز وجل أن سفينة ضلت مسلكها، ودفعها الرياح وتلاطم الأمواج إلى ساحلها. فلما قربت من البر رأى أهلها الرجلين على الشاطئ.

فدنوا منها فكلمهم أسال وسألهم أن يحملوهما معهم، فأجابوهما إلى ذلك، وأدخلوهما السفينة، فأرسل الله إليهم ريحاً رخاء حملت السفينة في أقرب مدة إلى الجزيرة التي أملاها فنزلا بها، ودخلا مدينتها، واجتمع أصحاب أسال به، فعرفهم شأن حي بن يقظان، فاشتملوا عليه شديداً وأكبروا آمره، واجتمعوا إليه واعظموه وبجلوه، وأعلمه أسال أن تلك الطائفة هم أن تلك الطائفة هم أقرب إلى الفهم والذكاء من جميع الناس، وانه إن عجز عن تعليمهم فهو عن تعليم الجمهور أعجز.

وكان رأس تلك الجزيرة سلامان وهو صاحب أسال الذي كان يراه ملازمة الجماعة، ويقول بتحريم العزلة، فشرع حي بن يقظان في تعليمهم وبث أسرار الحكمة إليهم.

فما هو إلا أن ترقى عن الظاهر قليلاً وأخذ في وصف ما سبق إلى فهمهم خلافه، فجعلوا ينقبضون منه وتشمئز نفوسهم مما يأتي به، ويتسخطونه بقلوبهم، وان اظهروا له الرضا في وجهه اكراماً لغربته فيهم، ومراعاة لحق صاحبهم أسال! وما زال حي بن يقظان يستلطفهم ليلاً ونهاراً، ويبن لهم الحق سراً وجهاراً، فلا يزيدهم ذلك إلا نبوأً ونفاراً، مع أنهم كانوا محبين للخير، راغبين في الحق، إلا انهم لنقص فطرتهم كانوا لا يطلبون الحق من طريقة ولا يأخذونه لجهة تحقيقه، ولا يلتمسونه من بابه، بل كانوا لا يريدون معرفته من طريق أربابه. فيأس من أصلاحهم، وانقطع رجائه من صلاحهم لقلة قبولهم.

وتصفح طبقات الناس بعد ذلك، فرأى كل حزب بما لديهم فرحون، قد اتخذوا ألههم هواهم، ومعبودهم شهواتهم، وتهالكوا في جميع حطام الدنيا، ألهاهم التكاثر حتى زاروا المقابر، لا تنجح فيهم الموعظة ولا تعمل فيهم الكلمة الحسنة، ولا يزدادون بالجدل إلا إصرارا.

واما الحكمة فلا سبيل لهم إليها، ولا حظ لهم منه، قد غمرتهم الجهالة وران على قلوبهم ما يكسبون ختم الله على قلوبهم وعلى سمعهم وعلى أبصارهم غشاوةً ولهم عذاب عظيم.

فلما رأى سرادق العذاب قد أحاط بهم، الظالمات الحجب قد تغشتهم، والكل منهم - إلا اليسير - لا يتمسكون من ملتهم إلا بالدنيا، وقد نبذوا أعمالهم على خفتها وسهولتها وراء ظهورهم، واشتروا بها ثمناً قليلاً، وألهاهم عن ذكر الله تعالى التجارة والبيع، ولم يخافوا يوماً تنقلب فيه القلوب والابصار، لأن له وتحقق على القطع، أن مخاطبتهم بطريق المكاشفة لا تمكن وأن تكليفهم من العمل فوق هذا القدر لا يتفق، وأن حظ أكثر الجمهور من الانتفاع بالشريعة إنما هو في حياتهم الدنيا لا يستقيم له معاشه، ولا يتعدى عليه سواه فيما اختص هو به، وانه لا يفوز منه بالسعادة الأخروية إلا الشاذ النادر، وهو من أراد حرث الآخرة وسعى لها سعياً وهو مؤمن.

وأما من طغى وأثر الحياة الدنيا فان الجحيم هي المأوى، وأي تعب أعظم وشقاوةً أطم ممن إذا تصفحت أعماله من وقت انتباهه من نومه إلى حين رجوعه إلى الكره لا تجد منها شيئاً إلا وهو يلتمس به تحصيل غايةً من هذه الأمور المحسوسة الخسيسة آما مال يجمعه أو لذة ينالها أو شهوة يقضيها أو غيطاً يتشفه به أو جاه يحرزه أو عمل من أعمال الشرع يتزين به أو يدافع عن رقبته، وهي كلها ظلمات بعضها فوق بعض في بحر لجي وان منكم إلا واردها كان على ربك حتماً مقضياً.

فلما فهم أحوال الناس وان أكثرهم بمنزلة الحيوان غير الناطق علم أن الحكمة كلها والهداية والتوفيق فيما نطقت به الرسل ووردت به الشريعة لا يمكن غير ذلك ولا يحتمل المزيد عليه ولكل عمل رجال وكل ميسر لما خلق له "بسم الله الرحمن الرحيم" سنة الله التي قد خلت من قبل ولن تجد لسنة الله تبديلاً صدق الله العظيم.

فانصرف إلى سلامان وأصحابه، فاعتذر عما تكلم به معه وتبرأ إليهم منه وأعلمهم أنه قد رآه مثل رأيهم واهتدى بمثل هديهم، وأوصاهم بملازمة ما هم عليه من التزام حدود الشرع والأعمال الظاهرة مقلة الخوض فيما لا يعنيهم، والإيمان بالمتشابهات والتسليم لها، والأعراض عن البدع والأهواء والاقتداء بالسلف الصالح والترك لمحدثات الأمور، وأمرهم بمجانبة ما عليه جمهور العوام من إهمال الشريعة والإقبال على الدنيا، وحذرهم عنه غاية التحذير، وعلم هو وصاحبه أسال أن هذه الطائفة المريدة القاصرة لا نجاة لها إلا بهذا الطريق، وأنها إن رفعت عنه إلى يفاع الاستبصار اختل ما هي عليه ولم يمكنها أن تلحق بدرجة السعداء وتذبذبت وانتكست وساءت عاقبتها. وان هي دامت على ما هي عليه حتى يوافيها اليقين فازت بالآمن وكانت من أصحاب اليمين، والسابقون السابقون أولئك المقربون. فو دعاهم وانفصلا عنهم وتلطفا في العود إلى جزيرتهما حتى يسر الله عز وجل عليهما العبور إليها. وطلب حي بن يقظان مقامه الكريم بالنحو الذي طلبه أولاً حتى عاد إليه، واقتدى به أسال حتى قرب من أو كاد وعبدا الله في تلك الجزيرة حتى أتاهما اليقين. هذا - أيدنا الله وأياك بروح منه - ما كان من نبأ حي بن يقظان وأسال وسلامان وقد أشتمل على حظ من الكلام لا يوجد في كتاب ولا يسمع في معتاد خطاب، وهو من العلم المكنون الذي لا يقبله إلا أهل المعرفة بالله، ولا يجهله إلا أهل الغرة بالله. وقد خالفنا فيه طريق السلف الصالح في الضنانا به والشح عليه. إلا أن الذي سهل علينا إفشاء هذا السر وهتك الحجاب، ما ظهر في زماننا من أراء فاسده نبغت بها متفلسفة العصر وصرحت بها، حتى انتشرت في البلدان وعما ضررها وخشينا على الضعفاء الذين اطرحوا تقليد الأنبياء صلوات الله عليهم، وأرادوا تقليد السفهاء والأغبياء أن يظنوا أن تلك الآراء هي الأسرار المضنون بها على غير أهلها، فيزيد بذلك حبهم فيها وولعهم فيها. فرأينا أن نلمح إليهم بطرف من سر الأسرار لنجتذبهم إلى جانب التحقيق، ثم نصدهم عن ذلك الطريق. ولم نخل مع ذلك ما أودعناه هذه الأوراق اليسيره من الأسرار عن حجاب رقيق وستر لطيف ينتهك سريعاً لمن هو أهله، ويتكاثف لمن لا يستحق تجاوزه حتى لا يتعداه. وأنا أسئل إخواني الواقفين على هذا الكلام، أن يقبلو عذري فيما تسائلت في تبينه وتسامحت في تثبيته، فلم أفعل ذلك إلا لأني تسمنت شواهق يزل الطرف عن مرآها. وأردت تقريب الكلام فيها على وجه الترغيب والتشويق في دخول الطريق. وأسأل الله التجاوز والعفو، وأن يوردنا من المعرفة به الصفو، إنه منعم كريم. والسلام عليك أيها الأخ المفترض إسعافه ورحمت الله وبركاته.
EOT;
}
